@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.UserOwnedStorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The user owned storage for Cognitive Services account.
 * @property identityClientId
 * @property resourceId Full resource id of a Microsoft.Storage resource.
 */
public data class UserOwnedStorageArgs(
    public val identityClientId: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.UserOwnedStorageArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.UserOwnedStorageArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.UserOwnedStorageArgs.builder()
            .identityClientId(identityClientId?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserOwnedStorageArgs].
 */
@PulumiTagMarker
public class UserOwnedStorageArgsBuilder internal constructor() {
    private var identityClientId: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("xrfvlpajbxuwonel")
    public suspend fun identityClientId(`value`: Output<String>) {
        this.identityClientId = value
    }

    /**
     * @param value Full resource id of a Microsoft.Storage resource.
     */
    @JvmName("nasfdgafmrrilyrh")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value
     */
    @JvmName("ciynbhmapjaelsmw")
    public suspend fun identityClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityClientId = mapped
    }

    /**
     * @param value Full resource id of a Microsoft.Storage resource.
     */
    @JvmName("htguiskbmdoqcrnu")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): UserOwnedStorageArgs = UserOwnedStorageArgs(
        identityClientId = identityClientId,
        resourceId = resourceId,
    )
}
