@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The abuse penalty.
 * @property action The action of AbusePenalty.
 * @property expiration The datetime of expiration of the AbusePenalty.
 * @property rateLimitPercentage The percentage of rate limit.
 */
public data class AbusePenaltyResponse(
    public val action: String? = null,
    public val expiration: String? = null,
    public val rateLimitPercentage: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.AbusePenaltyResponse): AbusePenaltyResponse = AbusePenaltyResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            expiration = javaType.expiration().map({ args0 -> args0 }).orElse(null),
            rateLimitPercentage = javaType.rateLimitPercentage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
