@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Properties of Cognitive Services account.
 * @property abusePenalty The abuse penalty.
 * @property allowedFqdnList
 * @property apiProperties The api properties for special APIs.
 * @property callRateLimit The call rate limit Cognitive Services account.
 * @property capabilities Gets the capabilities of the cognitive services account. Each item indicates the capability of a specific feature. The values are read-only and for reference only.
 * @property commitmentPlanAssociations The commitment plan associations of Cognitive Services account.
 * @property customSubDomainName Optional subdomain name used for token-based authentication.
 * @property dateCreated Gets the date of cognitive services account creation.
 * @property deletionDate The deletion date, only available for deleted account.
 * @property disableLocalAuth
 * @property dynamicThrottlingEnabled The flag to enable dynamic throttling.
 * @property encryption The encryption properties for this resource.
 * @property endpoint Endpoint of the created account.
 * @property endpoints
 * @property internalId The internal identifier (deprecated, do not use this property).
 * @property isMigrated If the resource is migrated from an existing key.
 * @property locations The multiregion settings of Cognitive Services account.
 * @property migrationToken Resource migration token.
 * @property networkAcls A collection of rules governing the accessibility from specific network locations.
 * @property privateEndpointConnections The private endpoint connection associated with the Cognitive Services account.
 * @property provisioningState Gets the status of the cognitive services account at the time the operation was called.
 * @property publicNetworkAccess Whether or not public endpoint access is allowed for this account.
 * @property quotaLimit
 * @property restrictOutboundNetworkAccess
 * @property scheduledPurgeDate The scheduled purge date, only available for deleted account.
 * @property skuChangeInfo Sku change info of account.
 * @property userOwnedStorage The storage accounts for this resource.
 */
public data class AccountPropertiesResponse(
    public val abusePenalty: AbusePenaltyResponse,
    public val allowedFqdnList: List<String>? = null,
    public val apiProperties: ApiPropertiesResponse? = null,
    public val callRateLimit: CallRateLimitResponse,
    public val capabilities: List<SkuCapabilityResponse>,
    public val commitmentPlanAssociations: List<CommitmentPlanAssociationResponse>,
    public val customSubDomainName: String? = null,
    public val dateCreated: String,
    public val deletionDate: String,
    public val disableLocalAuth: Boolean? = null,
    public val dynamicThrottlingEnabled: Boolean? = null,
    public val encryption: EncryptionResponse? = null,
    public val endpoint: String,
    public val endpoints: Map<String, String>,
    public val internalId: String,
    public val isMigrated: Boolean,
    public val locations: MultiRegionSettingsResponse? = null,
    public val migrationToken: String? = null,
    public val networkAcls: NetworkRuleSetResponse? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val quotaLimit: QuotaLimitResponse,
    public val restrictOutboundNetworkAccess: Boolean? = null,
    public val scheduledPurgeDate: String,
    public val skuChangeInfo: SkuChangeInfoResponse,
    public val userOwnedStorage: List<UserOwnedStorageResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.AccountPropertiesResponse): AccountPropertiesResponse = AccountPropertiesResponse(
            abusePenalty = javaType.abusePenalty().let({ args0 ->
                com.pulumi.azurenative.cognitiveservices.kotlin.outputs.AbusePenaltyResponse.Companion.toKotlin(args0)
            }),
            allowedFqdnList = javaType.allowedFqdnList().map({ args0 -> args0 }),
            apiProperties = javaType.apiProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.ApiPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            callRateLimit = javaType.callRateLimit().let({ args0 ->
                com.pulumi.azurenative.cognitiveservices.kotlin.outputs.CallRateLimitResponse.Companion.toKotlin(args0)
            }),
            capabilities = javaType.capabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SkuCapabilityResponse.Companion.toKotlin(args0)
                })
            }),
            commitmentPlanAssociations = javaType.commitmentPlanAssociations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.CommitmentPlanAssociationResponse.Companion.toKotlin(args0)
                })
            }),
            customSubDomainName = javaType.customSubDomainName().map({ args0 -> args0 }).orElse(null),
            dateCreated = javaType.dateCreated(),
            deletionDate = javaType.deletionDate(),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            dynamicThrottlingEnabled = javaType.dynamicThrottlingEnabled().map({ args0 -> args0 }).orElse(null),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.EncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endpoint = javaType.endpoint(),
            endpoints = javaType.endpoints().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            internalId = javaType.internalId(),
            isMigrated = javaType.isMigrated(),
            locations = javaType.locations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.MultiRegionSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            migrationToken = javaType.migrationToken().map({ args0 -> args0 }).orElse(null),
            networkAcls = javaType.networkAcls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.NetworkRuleSetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            quotaLimit = javaType.quotaLimit().let({ args0 ->
                com.pulumi.azurenative.cognitiveservices.kotlin.outputs.QuotaLimitResponse.Companion.toKotlin(args0)
            }),
            restrictOutboundNetworkAccess = javaType.restrictOutboundNetworkAccess().map({ args0 ->
                args0
            }).orElse(null),
            scheduledPurgeDate = javaType.scheduledPurgeDate(),
            skuChangeInfo = javaType.skuChangeInfo().let({ args0 ->
                com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SkuChangeInfoResponse.Companion.toKotlin(args0)
            }),
            userOwnedStorage = javaType.userOwnedStorage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.UserOwnedStorageResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
