@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Cognitive Services account commitment period.
 * @property count Commitment period commitment count.
 * @property endDate Commitment period end date.
 * @property quota Cognitive Services account commitment quota.
 * @property startDate Commitment period start date.
 * @property tier Commitment period commitment tier.
 */
public data class CommitmentPeriodResponse(
    public val count: Int? = null,
    public val endDate: String,
    public val quota: CommitmentQuotaResponse,
    public val startDate: String,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.CommitmentPeriodResponse): CommitmentPeriodResponse = CommitmentPeriodResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            endDate = javaType.endDate(),
            quota = javaType.quota().let({ args0 ->
                com.pulumi.azurenative.cognitiveservices.kotlin.outputs.CommitmentQuotaResponse.Companion.toKotlin(args0)
            }),
            startDate = javaType.startDate(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
