@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The commitment plan association.
 * @property commitmentPlanId The Azure resource id of the commitment plan.
 * @property commitmentPlanLocation The location of of the commitment plan.
 */
public data class CommitmentPlanAssociationResponse(
    public val commitmentPlanId: String? = null,
    public val commitmentPlanLocation: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.CommitmentPlanAssociationResponse): CommitmentPlanAssociationResponse = CommitmentPlanAssociationResponse(
            commitmentPlanId = javaType.commitmentPlanId().map({ args0 -> args0 }).orElse(null),
            commitmentPlanLocation = javaType.commitmentPlanLocation().map({ args0 -> args0 }).orElse(null),
        )
    }
}
