@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of Cognitive Services account commitment plan.
 * @property autoRenew AutoRenew commitment plan.
 * @property commitmentPlanGuid Commitment plan guid.
 * @property current Cognitive Services account commitment period.
 * @property hostingModel Account hosting model.
 * @property last Cognitive Services account commitment period.
 * @property next Cognitive Services account commitment period.
 * @property planType Commitment plan type.
 * @property provisioningIssues The list of ProvisioningIssue.
 * @property provisioningState Gets the status of the resource at the time the operation was called.
 */
public data class CommitmentPlanPropertiesResponse(
    public val autoRenew: Boolean? = null,
    public val commitmentPlanGuid: String? = null,
    public val current: CommitmentPeriodResponse? = null,
    public val hostingModel: String? = null,
    public val last: CommitmentPeriodResponse,
    public val next: CommitmentPeriodResponse? = null,
    public val planType: String? = null,
    public val provisioningIssues: List<String>,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.CommitmentPlanPropertiesResponse): CommitmentPlanPropertiesResponse = CommitmentPlanPropertiesResponse(
            autoRenew = javaType.autoRenew().map({ args0 -> args0 }).orElse(null),
            commitmentPlanGuid = javaType.commitmentPlanGuid().map({ args0 -> args0 }).orElse(null),
            current = javaType.current().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.CommitmentPeriodResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostingModel = javaType.hostingModel().map({ args0 -> args0 }).orElse(null),
            last = javaType.last().let({ args0 ->
                com.pulumi.azurenative.cognitiveservices.kotlin.outputs.CommitmentPeriodResponse.Companion.toKotlin(args0)
            }),
            next = javaType.next().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.CommitmentPeriodResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            planType = javaType.planType().map({ args0 -> args0 }).orElse(null),
            provisioningIssues = javaType.provisioningIssues().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
