@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties to configure Encryption
 * @property keySource Enumerates the possible value of keySource for Encryption
 * @property keyVaultProperties Properties of KeyVault
 */
public data class EncryptionResponse(
    public val keySource: String? = null,
    public val keyVaultProperties: KeyVaultPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.EncryptionResponse): EncryptionResponse = EncryptionResponse(
            keySource = javaType.keySource().map({ args0 -> args0 }).orElse(null),
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
