@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Azure OpenAI blocklist config.
 * @property blocking If blocking would occur.
 * @property blocklistName Name of ContentFilter.
 */
public data class RaiBlocklistConfigResponse(
    public val blocking: Boolean? = null,
    public val blocklistName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.RaiBlocklistConfigResponse): RaiBlocklistConfigResponse = RaiBlocklistConfigResponse(
            blocking = javaType.blocking().map({ args0 -> args0 }).orElse(null),
            blocklistName = javaType.blocklistName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
