@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * RAI Custom Blocklist Item properties.
 * @property isRegex If the pattern is a regex pattern.
 * @property pattern Pattern to match against.
 */
public data class RaiBlocklistItemPropertiesResponse(
    public val isRegex: Boolean? = null,
    public val pattern: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.RaiBlocklistItemPropertiesResponse): RaiBlocklistItemPropertiesResponse = RaiBlocklistItemPropertiesResponse(
            isRegex = javaType.isRegex().map({ args0 -> args0 }).orElse(null),
            pattern = javaType.pattern().map({ args0 -> args0 }).orElse(null),
        )
    }
}
