@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure OpenAI Content Filters properties.
 * @property basePolicyName Name of the base Content Filters.
 * @property completionBlocklists The list of blocklists for completion.
 * @property contentFilters The list of Content Filters.
 * @property mode Content Filters mode.
 * @property policyType Content Filters policy type.
 * @property promptBlocklists The list of blocklists for prompt.
 */
public data class RaiPolicyPropertiesResponse(
    public val basePolicyName: String? = null,
    public val completionBlocklists: List<RaiBlocklistConfigResponse>? = null,
    public val contentFilters: List<RaiPolicyContentFilterResponse>? = null,
    public val mode: String? = null,
    public val policyType: String,
    public val promptBlocklists: List<RaiBlocklistConfigResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.RaiPolicyPropertiesResponse): RaiPolicyPropertiesResponse = RaiPolicyPropertiesResponse(
            basePolicyName = javaType.basePolicyName().map({ args0 -> args0 }).orElse(null),
            completionBlocklists = javaType.completionBlocklists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.RaiBlocklistConfigResponse.Companion.toKotlin(args0)
                })
            }),
            contentFilters = javaType.contentFilters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.RaiPolicyContentFilterResponse.Companion.toKotlin(args0)
                })
            }),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            policyType = javaType.policyType(),
            promptBlocklists = javaType.promptBlocklists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cognitiveservices.kotlin.outputs.RaiBlocklistConfigResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
