@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The call rate limit Cognitive Services account.
 * @property customsubdomain Maps the region to the regional custom subdomain.
 * @property name Name of the region.
 * @property value A value for priority or weighted routing methods.
 */
public data class RegionSettingResponse(
    public val customsubdomain: String? = null,
    public val name: String? = null,
    public val `value`: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.RegionSettingResponse): RegionSettingResponse = RegionSettingResponse(
            customsubdomain = javaType.customsubdomain().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
