@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The user owned storage for Cognitive Services account.
 * @property identityClientId
 * @property resourceId Full resource id of a Microsoft.Storage resource.
 */
public data class UserOwnedStorageResponse(
    public val identityClientId: String? = null,
    public val resourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.UserOwnedStorageResponse): UserOwnedStorageResponse = UserOwnedStorageResponse(
            identityClientId = javaType.identityClientId().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
