@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A rule governing the accessibility from a specific virtual network.
 * @property id Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
 * @property ignoreMissingVnetServiceEndpoint Ignore missing vnet service endpoint or not.
 * @property state Gets the state of virtual network rule.
 */
public data class VirtualNetworkRuleResponse(
    public val id: String,
    public val ignoreMissingVnetServiceEndpoint: Boolean? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.VirtualNetworkRuleResponse): VirtualNetworkRuleResponse = VirtualNetworkRuleResponse(
            id = javaType.id(),
            ignoreMissingVnetServiceEndpoint = javaType.ignoreMissingVnetServiceEndpoint().map({ args0 ->
                args0
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
