@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin

import com.pulumi.azurenative.communication.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.communication.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SuppressionListAddress].
 */
@PulumiTagMarker
public class SuppressionListAddressResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SuppressionListAddressArgs = SuppressionListAddressArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SuppressionListAddressArgsBuilder.() -> Unit) {
        val builder = SuppressionListAddressArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SuppressionListAddress {
        val builtJavaResource =
            com.pulumi.azurenative.communication.SuppressionListAddress(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SuppressionListAddress(builtJavaResource)
    }
}

/**
 * A object that represents a SuppressionList record.
 * Azure REST API version: 2023-06-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate SuppressionListAddress resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var suppressionListAddress = new AzureNative.Communication.SuppressionListAddress("suppressionListAddress", new()
 *     {
 *         AddressId = "11112222-3333-4444-5555-aaaabbbbcccc",
 *         DomainName = "contoso.com",
 *         Email = "newuser1@fabrikam.com",
 *         EmailServiceName = "contosoEmailService",
 *         FirstName = "updatedFirstName",
 *         ResourceGroupName = "contosoResourceGroup",
 *         SuppressionListName = "aaaa1111-bbbb-2222-3333-aaaa11112222",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/communication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := communication.NewSuppressionListAddress(ctx, "suppressionListAddress", &communication.SuppressionListAddressArgs{
 * 			AddressId:           pulumi.String("11112222-3333-4444-5555-aaaabbbbcccc"),
 * 			DomainName:          pulumi.String("contoso.com"),
 * 			Email:               pulumi.String("newuser1@fabrikam.com"),
 * 			EmailServiceName:    pulumi.String("contosoEmailService"),
 * 			FirstName:           pulumi.String("updatedFirstName"),
 * 			ResourceGroupName:   pulumi.String("contosoResourceGroup"),
 * 			SuppressionListName: pulumi.String("aaaa1111-bbbb-2222-3333-aaaa11112222"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.communication.SuppressionListAddress;
 * import com.pulumi.azurenative.communication.SuppressionListAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var suppressionListAddress = new SuppressionListAddress("suppressionListAddress", SuppressionListAddressArgs.builder()
 *             .addressId("11112222-3333-4444-5555-aaaabbbbcccc")
 *             .domainName("contoso.com")
 *             .email("newuser1@fabrikam.com")
 *             .emailServiceName("contosoEmailService")
 *             .firstName("updatedFirstName")
 *             .resourceGroupName("contosoResourceGroup")
 *             .suppressionListName("aaaa1111-bbbb-2222-3333-aaaa11112222")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:communication:SuppressionListAddress 11112222-3333-4444-5555-aaaabbbbcccc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}/suppressionLists/{suppressionListName}/suppressionListAddresses/{addressId}
 * ```
 */
public class SuppressionListAddress internal constructor(
    override val javaResource: com.pulumi.azurenative.communication.SuppressionListAddress,
) : KotlinCustomResource(javaResource, SuppressionListAddressMapper) {
    /**
     * The location where the SuppressionListAddress data is stored at rest. This value is inherited from the parent Domains resource.
     */
    public val dataLocation: Output<String>
        get() = javaResource.dataLocation().applyValue({ args0 -> args0 })

    /**
     * Email address of the recipient.
     */
    public val email: Output<String>
        get() = javaResource.email().applyValue({ args0 -> args0 })

    /**
     * The first name of the email recipient.
     */
    public val firstName: Output<String>?
        get() = javaResource.firstName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The date the address was last updated in a suppression list.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * The last name of the email recipient.
     */
    public val lastName: Output<String>?
        get() = javaResource.lastName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * An optional property to provide contextual notes or a description for an address.
     */
    public val notes: Output<String>?
        get() = javaResource.notes().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SuppressionListAddressMapper : ResourceMapper<SuppressionListAddress> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.communication.SuppressionListAddress::class == javaResource::class

    override fun map(javaResource: Resource): SuppressionListAddress =
        SuppressionListAddress(
            javaResource as
                com.pulumi.azurenative.communication.SuppressionListAddress,
        )
}

/**
 * @see [SuppressionListAddress].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SuppressionListAddress].
 */
public suspend fun suppressionListAddress(
    name: String,
    block: suspend SuppressionListAddressResourceBuilder.() -> Unit,
): SuppressionListAddress {
    val builder = SuppressionListAddressResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SuppressionListAddress].
 * @param name The _unique_ name of the resulting resource.
 */
public fun suppressionListAddress(name: String): SuppressionListAddress {
    val builder = SuppressionListAddressResourceBuilder()
    builder.name(name)
    return builder.build()
}
