@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A class representing a CommunicationService resource.
 * @property dataLocation The location where the communication service stores its data at rest.
 * @property hostName FQDN of the CommunicationService instance.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property immutableResourceId The immutable resource Id of the communication service.
 * @property linkedDomains List of email Domain resource Ids.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property notificationHubId Resource ID of an Azure Notification Hub linked to this resource.
 * @property provisioningState Provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version Version of the CommunicationService resource. Probably you need the same or higher version of client SDKs.
 */
public data class GetCommunicationServiceResult(
    public val dataLocation: String,
    public val hostName: String,
    public val id: String,
    public val immutableResourceId: String,
    public val linkedDomains: List<String>? = null,
    public val location: String,
    public val name: String,
    public val notificationHubId: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.communication.outputs.GetCommunicationServiceResult): GetCommunicationServiceResult = GetCommunicationServiceResult(
            dataLocation = javaType.dataLocation(),
            hostName = javaType.hostName(),
            id = javaType.id(),
            immutableResourceId = javaType.immutableResourceId(),
            linkedDomains = javaType.linkedDomains().map({ args0 -> args0 }),
            location = javaType.location(),
            name = javaType.name(),
            notificationHubId = javaType.notificationHubId(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.communication.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
