@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A class representing a Domains resource.
 * @property dataLocation The location where the Domains resource data is stored at rest.
 * @property domainManagement Describes how a Domains resource is being managed.
 * @property fromSenderDomain P2 sender domain that is displayed to the email recipients [RFC 5322].
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property mailFromSenderDomain P1 sender domain that is present on the email envelope [RFC 5321].
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property userEngagementTracking Describes whether user engagement tracking is enabled or disabled.
 * @property verificationRecords List of DnsRecord
 * @property verificationStates List of VerificationStatusRecord
 */
public data class GetDomainResult(
    public val dataLocation: String,
    public val domainManagement: String,
    public val fromSenderDomain: String,
    public val id: String,
    public val location: String,
    public val mailFromSenderDomain: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val userEngagementTracking: String? = null,
    public val verificationRecords: DomainPropertiesResponseVerificationRecords,
    public val verificationStates: DomainPropertiesResponseVerificationStates,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.communication.outputs.GetDomainResult): GetDomainResult = GetDomainResult(
            dataLocation = javaType.dataLocation(),
            domainManagement = javaType.domainManagement(),
            fromSenderDomain = javaType.fromSenderDomain(),
            id = javaType.id(),
            location = javaType.location(),
            mailFromSenderDomain = javaType.mailFromSenderDomain(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.communication.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userEngagementTracking = javaType.userEngagementTracking().map({ args0 -> args0 }).orElse(null),
            verificationRecords = javaType.verificationRecords().let({ args0 ->
                com.pulumi.azurenative.communication.kotlin.outputs.DomainPropertiesResponseVerificationRecords.Companion.toKotlin(args0)
            }),
            verificationStates = javaType.verificationStates().let({ args0 ->
                com.pulumi.azurenative.communication.kotlin.outputs.DomainPropertiesResponseVerificationStates.Companion.toKotlin(args0)
            }),
        )
    }
}
