@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A object that represents a SuppressionList record.
 * @property dataLocation The location where the SuppressionListAddress data is stored at rest. This value is inherited from the parent Domains resource.
 * @property email Email address of the recipient.
 * @property firstName The first name of the email recipient.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property lastModified The date the address was last updated in a suppression list.
 * @property lastName The last name of the email recipient.
 * @property name The name of the resource
 * @property notes An optional property to provide contextual notes or a description for an address.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSuppressionListAddressResult(
    public val dataLocation: String,
    public val email: String,
    public val firstName: String? = null,
    public val id: String,
    public val lastModified: String,
    public val lastName: String? = null,
    public val name: String,
    public val notes: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.communication.outputs.GetSuppressionListAddressResult): GetSuppressionListAddressResult = GetSuppressionListAddressResult(
            dataLocation = javaType.dataLocation(),
            email = javaType.email(),
            firstName = javaType.firstName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastModified = javaType.lastModified(),
            lastName = javaType.lastName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            notes = javaType.notes().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.communication.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
