@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A class that represents a VerificationStatus record.
 * @property errorCode Error code. This property will only be present if the status is UnableToVerify.
 * @property status Status of the verification operation.
 */
public data class VerificationStatusRecordResponse(
    public val errorCode: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.communication.outputs.VerificationStatusRecordResponse): VerificationStatusRecordResponse = VerificationStatusRecordResponse(
            errorCode = javaType.errorCode(),
            status = javaType.status(),
        )
    }
}
