@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.community.kotlin

import com.pulumi.azurenative.community.CommunityFunctions.getCommunityTrainingPlain
import com.pulumi.azurenative.community.kotlin.inputs.GetCommunityTrainingPlainArgs
import com.pulumi.azurenative.community.kotlin.inputs.GetCommunityTrainingPlainArgsBuilder
import com.pulumi.azurenative.community.kotlin.outputs.GetCommunityTrainingResult
import com.pulumi.azurenative.community.kotlin.outputs.GetCommunityTrainingResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object CommunityFunctions {
    /**
     * Get a CommunityTraining
     * Azure REST API version: 2023-11-01.
     * @param argument null
     * @return A CommunityProviderHub resource
     */
    public suspend fun getCommunityTraining(argument: GetCommunityTrainingPlainArgs): GetCommunityTrainingResult = toKotlin(getCommunityTrainingPlain(argument.toJava()).await())

    /**
     * @see [getCommunityTraining].
     * @param communityTrainingName The name of the Community Training Resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A CommunityProviderHub resource
     */
    public suspend fun getCommunityTraining(communityTrainingName: String, resourceGroupName: String): GetCommunityTrainingResult {
        val argument = GetCommunityTrainingPlainArgs(
            communityTrainingName = communityTrainingName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getCommunityTrainingPlain(argument.toJava()).await())
    }

    /**
     * @see [getCommunityTraining].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;community&#46;kotlin&#46;inputs&#46;GetCommunityTrainingPlainArgs].
     * @return A CommunityProviderHub resource
     */
    public suspend fun getCommunityTraining(argument: suspend GetCommunityTrainingPlainArgsBuilder.() -> Unit): GetCommunityTrainingResult {
        val builder = GetCommunityTrainingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getCommunityTrainingPlain(builtArgument.toJava()).await())
    }
}
