@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.community.kotlin

import com.pulumi.azurenative.community.kotlin.outputs.IdentityConfigurationPropertiesResponse
import com.pulumi.azurenative.community.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.community.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.community.kotlin.outputs.IdentityConfigurationPropertiesResponse.Companion.toKotlin as identityConfigurationPropertiesResponseToKotlin
import com.pulumi.azurenative.community.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.community.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CommunityTraining].
 */
@PulumiTagMarker
public class CommunityTrainingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CommunityTrainingArgs = CommunityTrainingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CommunityTrainingArgsBuilder.() -> Unit) {
        val builder = CommunityTrainingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CommunityTraining {
        val builtJavaResource =
            com.pulumi.azurenative.community.CommunityTraining(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CommunityTraining(builtJavaResource)
    }
}

/**
 * A CommunityProviderHub resource
 * Azure REST API version: 2023-11-01.
 * ## Example Usage
 * ### CreateCommunityTrainings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var communityTraining = new AzureNative.Community.CommunityTraining("communityTraining", new()
 *     {
 *         CommunityTrainingName = "ctApplication",
 *         DisasterRecoveryEnabled = true,
 *         IdentityConfiguration = new AzureNative.Community.Inputs.IdentityConfigurationPropertiesArgs
 *         {
 *             B2cAuthenticationPolicy = "B2C_1_signup_signin",
 *             B2cPasswordResetPolicy = "B2C_1_pwd_reset",
 *             ClientId = "8c92390f-2f30-493d-bd13-d3c3eba3709d",
 *             ClientSecret = "idenityConfigurationClientSecret",
 *             CustomLoginParameters = "custom_hint",
 *             DomainName = "cttenant",
 *             IdentityType = "ADB2C",
 *             TeamsEnabled = false,
 *             TenantId = "c1ffbb60-88cf-4b83-b54f-c47ae6220c19",
 *         },
 *         Location = "southeastasia",
 *         PortalAdminEmailAddress = "ctadmin@ct.com",
 *         PortalName = "ctwebsite",
 *         PortalOwnerEmailAddress = "ctcontact@ct.com",
 *         PortalOwnerOrganizationName = "CT Portal Owner Organization",
 *         ResourceGroupName = "rgCommunityTaining",
 *         Sku = new AzureNative.Community.Inputs.SkuArgs
 *         {
 *             Name = "Commercial",
 *             Tier = AzureNative.Community.SkuTier.Standard,
 *         },
 *         ZoneRedundancyEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/community/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := community.NewCommunityTraining(ctx, "communityTraining", &community.CommunityTrainingArgs{
 * 			CommunityTrainingName:   pulumi.String("ctApplication"),
 * 			DisasterRecoveryEnabled: pulumi.Bool(true),
 * 			IdentityConfiguration: &community.IdentityConfigurationPropertiesArgs{
 * 				B2cAuthenticationPolicy: pulumi.String("B2C_1_signup_signin"),
 * 				B2cPasswordResetPolicy:  pulumi.String("B2C_1_pwd_reset"),
 * 				ClientId:                pulumi.String("8c92390f-2f30-493d-bd13-d3c3eba3709d"),
 * 				ClientSecret:            pulumi.String("idenityConfigurationClientSecret"),
 * 				CustomLoginParameters:   pulumi.String("custom_hint"),
 * 				DomainName:              pulumi.String("cttenant"),
 * 				IdentityType:            pulumi.String("ADB2C"),
 * 				TeamsEnabled:            pulumi.Bool(false),
 * 				TenantId:                pulumi.String("c1ffbb60-88cf-4b83-b54f-c47ae6220c19"),
 * 			},
 * 			Location:                    pulumi.String("southeastasia"),
 * 			PortalAdminEmailAddress:     pulumi.String("ctadmin@ct.com"),
 * 			PortalName:                  pulumi.String("ctwebsite"),
 * 			PortalOwnerEmailAddress:     pulumi.String("ctcontact@ct.com"),
 * 			PortalOwnerOrganizationName: pulumi.String("CT Portal Owner Organization"),
 * 			ResourceGroupName:           pulumi.String("rgCommunityTaining"),
 * 			Sku: &community.SkuArgs{
 * 				Name: pulumi.String("Commercial"),
 * 				Tier: community.SkuTierStandard,
 * 			},
 * 			ZoneRedundancyEnabled: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.community.CommunityTraining;
 * import com.pulumi.azurenative.community.CommunityTrainingArgs;
 * import com.pulumi.azurenative.community.inputs.IdentityConfigurationPropertiesArgs;
 * import com.pulumi.azurenative.community.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var communityTraining = new CommunityTraining("communityTraining", CommunityTrainingArgs.builder()
 *             .communityTrainingName("ctApplication")
 *             .disasterRecoveryEnabled(true)
 *             .identityConfiguration(IdentityConfigurationPropertiesArgs.builder()
 *                 .b2cAuthenticationPolicy("B2C_1_signup_signin")
 *                 .b2cPasswordResetPolicy("B2C_1_pwd_reset")
 *                 .clientId("8c92390f-2f30-493d-bd13-d3c3eba3709d")
 *                 .clientSecret("idenityConfigurationClientSecret")
 *                 .customLoginParameters("custom_hint")
 *                 .domainName("cttenant")
 *                 .identityType("ADB2C")
 *                 .teamsEnabled(false)
 *                 .tenantId("c1ffbb60-88cf-4b83-b54f-c47ae6220c19")
 *                 .build())
 *             .location("southeastasia")
 *             .portalAdminEmailAddress("ctadmin@ct.com")
 *             .portalName("ctwebsite")
 *             .portalOwnerEmailAddress("ctcontact@ct.com")
 *             .portalOwnerOrganizationName("CT Portal Owner Organization")
 *             .resourceGroupName("rgCommunityTaining")
 *             .sku(SkuArgs.builder()
 *                 .name("Commercial")
 *                 .tier("Standard")
 *                 .build())
 *             .zoneRedundancyEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:community:CommunityTraining ctApplication /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Community/communityTrainings/{communityTrainingName}
 * ```
 */
public class CommunityTraining internal constructor(
    override val javaResource: com.pulumi.azurenative.community.CommunityTraining,
) : KotlinCustomResource(javaResource, CommunityTrainingMapper) {
    /**
     * To indicate whether the Community Training instance has Disaster Recovery enabled
     */
    public val disasterRecoveryEnabled: Output<Boolean>
        get() = javaResource.disasterRecoveryEnabled().applyValue({ args0 -> args0 })

    /**
     * The identity configuration of the Community Training resource
     */
    public val identityConfiguration: Output<IdentityConfigurationPropertiesResponse>
        get() = javaResource.identityConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                identityConfigurationPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The email address of the portal admin
     */
    public val portalAdminEmailAddress: Output<String>
        get() = javaResource.portalAdminEmailAddress().applyValue({ args0 -> args0 })

    /**
     * The portal name (website name) of the Community Training instance
     */
    public val portalName: Output<String>
        get() = javaResource.portalName().applyValue({ args0 -> args0 })

    /**
     * The email address of the portal owner. Will be used as the primary contact
     */
    public val portalOwnerEmailAddress: Output<String>
        get() = javaResource.portalOwnerEmailAddress().applyValue({ args0 -> args0 })

    /**
     * The organization name of the portal owner
     */
    public val portalOwnerOrganizationName: Output<String>
        get() = javaResource.portalOwnerOrganizationName().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The SKU (Stock Keeping Unit) assigned to this resource.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * To indicate whether the Community Training instance has Zone Redundancy enabled
     */
    public val zoneRedundancyEnabled: Output<Boolean>
        get() = javaResource.zoneRedundancyEnabled().applyValue({ args0 -> args0 })
}

public object CommunityTrainingMapper : ResourceMapper<CommunityTraining> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.community.CommunityTraining::class == javaResource::class

    override fun map(javaResource: Resource): CommunityTraining = CommunityTraining(
        javaResource as
            com.pulumi.azurenative.community.CommunityTraining,
    )
}

/**
 * @see [CommunityTraining].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CommunityTraining].
 */
public suspend fun communityTraining(
    name: String,
    block: suspend CommunityTrainingResourceBuilder.() -> Unit,
): CommunityTraining {
    val builder = CommunityTrainingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CommunityTraining].
 * @param name The _unique_ name of the resulting resource.
 */
public fun communityTraining(name: String): CommunityTraining {
    val builder = CommunityTrainingResourceBuilder()
    builder.name(name)
    return builder.build()
}
