@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.community.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A CommunityProviderHub resource
 * @property disasterRecoveryEnabled To indicate whether the Community Training instance has Disaster Recovery enabled
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identityConfiguration The identity configuration of the Community Training resource
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property portalAdminEmailAddress The email address of the portal admin
 * @property portalName The portal name (website name) of the Community Training instance
 * @property portalOwnerEmailAddress The email address of the portal owner. Will be used as the primary contact
 * @property portalOwnerOrganizationName The organization name of the portal owner
 * @property provisioningState The status of the last operation.
 * @property sku The SKU (Stock Keeping Unit) assigned to this resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property zoneRedundancyEnabled To indicate whether the Community Training instance has Zone Redundancy enabled
 */
public data class GetCommunityTrainingResult(
    public val disasterRecoveryEnabled: Boolean,
    public val id: String,
    public val identityConfiguration: IdentityConfigurationPropertiesResponse,
    public val location: String,
    public val name: String,
    public val portalAdminEmailAddress: String,
    public val portalName: String,
    public val portalOwnerEmailAddress: String,
    public val portalOwnerOrganizationName: String,
    public val provisioningState: String,
    public val sku: SkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zoneRedundancyEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.community.outputs.GetCommunityTrainingResult): GetCommunityTrainingResult = GetCommunityTrainingResult(
            disasterRecoveryEnabled = javaType.disasterRecoveryEnabled(),
            id = javaType.id(),
            identityConfiguration = javaType.identityConfiguration().let({ args0 ->
                com.pulumi.azurenative.community.kotlin.outputs.IdentityConfigurationPropertiesResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            name = javaType.name(),
            portalAdminEmailAddress = javaType.portalAdminEmailAddress(),
            portalName = javaType.portalName(),
            portalOwnerEmailAddress = javaType.portalOwnerEmailAddress(),
            portalOwnerOrganizationName = javaType.portalOwnerOrganizationName(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.community.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.community.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zoneRedundancyEnabled = javaType.zoneRedundancyEnabled(),
        )
    }
}
