@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.CapacityReservationInstanceViewResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.CapacityReservationInstanceViewResponse.Companion.toKotlin as capacityReservationInstanceViewResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse.Companion.toKotlin as subResourceReadOnlyResponseToKotlin

/**
 * Builder for [CapacityReservation].
 */
@PulumiTagMarker
public class CapacityReservationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CapacityReservationArgs = CapacityReservationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CapacityReservationArgsBuilder.() -> Unit) {
        val builder = CapacityReservationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CapacityReservation {
        val builtJavaResource =
            com.pulumi.azurenative.compute.CapacityReservation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CapacityReservation(builtJavaResource)
    }
}

/**
 * Specifies information about the capacity reservation.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-04-01.
 * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create or update a capacity reservation .
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var capacityReservation = new AzureNative.Compute.CapacityReservation("capacityReservation", new()
 *     {
 *         CapacityReservationGroupName = "myCapacityReservationGroup",
 *         CapacityReservationName = "myCapacityReservation",
 *         Location = "westus",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 4,
 *             Name = "Standard_DS1_v2",
 *         },
 *         Tags =
 *         {
 *             { "department", "HR" },
 *         },
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewCapacityReservation(ctx, "capacityReservation", &compute.CapacityReservationArgs{
 * 			CapacityReservationGroupName: pulumi.String("myCapacityReservationGroup"),
 * 			CapacityReservationName:      pulumi.String("myCapacityReservation"),
 * 			Location:                     pulumi.String("westus"),
 * 			ResourceGroupName:            pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(4),
 * 				Name:     pulumi.String("Standard_DS1_v2"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"department": pulumi.String("HR"),
 * 			},
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CapacityReservation;
 * import com.pulumi.azurenative.compute.CapacityReservationArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var capacityReservation = new CapacityReservation("capacityReservation", CapacityReservationArgs.builder()
 *             .capacityReservationGroupName("myCapacityReservationGroup")
 *             .capacityReservationName("myCapacityReservation")
 *             .location("westus")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(4)
 *                 .name("Standard_DS1_v2")
 *                 .build())
 *             .tags(Map.of("department", "HR"))
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:CapacityReservation myCapacityReservation /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}/capacityReservations/{capacityReservationName}
 * ```
 */
public class CapacityReservation internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.CapacityReservation,
) : KotlinCustomResource(javaResource, CapacityReservationMapper) {
    /**
     * The Capacity reservation instance view.
     */
    public val instanceView: Output<CapacityReservationInstanceViewResponse>
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.let({ args0 ->
                capacityReservationInstanceViewResponseToKotlin(args0)
            })
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the value of fault domain count that Capacity Reservation supports for requested VM size. **Note:** The fault domain count specified for a resource (like virtual machines scale set) must be less than or equal to this value if it deploys using capacity reservation. Minimum api-version: 2022-08-01.
     */
    public val platformFaultDomainCount: Output<Int>
        get() = javaResource.platformFaultDomainCount().applyValue({ args0 -> args0 })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The date time when the capacity reservation was last updated.
     */
    public val provisioningTime: Output<String>
        get() = javaResource.provisioningTime().applyValue({ args0 -> args0 })

    /**
     * A unique id generated and assigned to the capacity reservation by the platform which does not change throughout the lifetime of the resource.
     */
    public val reservationId: Output<String>
        get() = javaResource.reservationId().applyValue({ args0 -> args0 })

    /**
     * SKU of the resource for which capacity needs be reserved. The SKU name and capacity is required to be set. Currently VM Skus with the capability called 'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported values.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the time at which the Capacity Reservation resource was created. Minimum api-version: 2021-11-01.
     */
    public val timeCreated: Output<String>
        get() = javaResource.timeCreated().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A list of all virtual machine resource ids that are associated with the capacity reservation.
     */
    public val virtualMachinesAssociated: Output<List<SubResourceReadOnlyResponse>>
        get() = javaResource.virtualMachinesAssociated().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceReadOnlyResponseToKotlin(args0) })
            })
        })

    /**
     * Availability Zone to use for this capacity reservation. The zone has to be single value and also should be part for the list of zones specified during the capacity reservation group creation. The zone can be assigned only during creation. If not provided, the reservation supports only non-zonal deployments. If provided, enforces VM/VMSS using this capacity reservation to be in same zone.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object CapacityReservationMapper : ResourceMapper<CapacityReservation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.CapacityReservation::class == javaResource::class

    override fun map(javaResource: Resource): CapacityReservation = CapacityReservation(
        javaResource
            as com.pulumi.azurenative.compute.CapacityReservation,
    )
}

/**
 * @see [CapacityReservation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CapacityReservation].
 */
public suspend fun capacityReservation(
    name: String,
    block: suspend CapacityReservationResourceBuilder.() -> Unit,
): CapacityReservation {
    val builder = CapacityReservationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CapacityReservation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun capacityReservation(name: String): CapacityReservation {
    val builder = CapacityReservationResourceBuilder()
    builder.name(name)
    return builder.build()
}
