@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.CapacityReservationArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies information about the capacity reservation.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-04-01.
 * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create or update a capacity reservation .
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var capacityReservation = new AzureNative.Compute.CapacityReservation("capacityReservation", new()
 *     {
 *         CapacityReservationGroupName = "myCapacityReservationGroup",
 *         CapacityReservationName = "myCapacityReservation",
 *         Location = "westus",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Capacity = 4,
 *             Name = "Standard_DS1_v2",
 *         },
 *         Tags =
 *         {
 *             { "department", "HR" },
 *         },
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewCapacityReservation(ctx, "capacityReservation", &compute.CapacityReservationArgs{
 * 			CapacityReservationGroupName: pulumi.String("myCapacityReservationGroup"),
 * 			CapacityReservationName:      pulumi.String("myCapacityReservation"),
 * 			Location:                     pulumi.String("westus"),
 * 			ResourceGroupName:            pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Capacity: pulumi.Float64(4),
 * 				Name:     pulumi.String("Standard_DS1_v2"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"department": pulumi.String("HR"),
 * 			},
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CapacityReservation;
 * import com.pulumi.azurenative.compute.CapacityReservationArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var capacityReservation = new CapacityReservation("capacityReservation", CapacityReservationArgs.builder()
 *             .capacityReservationGroupName("myCapacityReservationGroup")
 *             .capacityReservationName("myCapacityReservation")
 *             .location("westus")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .capacity(4)
 *                 .name("Standard_DS1_v2")
 *                 .build())
 *             .tags(Map.of("department", "HR"))
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:CapacityReservation myCapacityReservation /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}/capacityReservations/{capacityReservationName}
 * ```
 * @property capacityReservationGroupName The name of the capacity reservation group.
 * @property capacityReservationName The name of the capacity reservation.
 * @property location Resource location
 * @property resourceGroupName The name of the resource group.
 * @property sku SKU of the resource for which capacity needs be reserved. The SKU name and capacity is required to be set. Currently VM Skus with the capability called 'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported values.
 * @property tags Resource tags
 * @property zones Availability Zone to use for this capacity reservation. The zone has to be single value and also should be part for the list of zones specified during the capacity reservation group creation. The zone can be assigned only during creation. If not provided, the reservation supports only non-zonal deployments. If provided, enforces VM/VMSS using this capacity reservation to be in same zone.
 */
public data class CapacityReservationArgs(
    public val capacityReservationGroupName: Output<String>? = null,
    public val capacityReservationName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.CapacityReservationArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.CapacityReservationArgs =
        com.pulumi.azurenative.compute.CapacityReservationArgs.builder()
            .capacityReservationGroupName(capacityReservationGroupName?.applyValue({ args0 -> args0 }))
            .capacityReservationName(capacityReservationName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CapacityReservationArgs].
 */
@PulumiTagMarker
public class CapacityReservationArgsBuilder internal constructor() {
    private var capacityReservationGroupName: Output<String>? = null

    private var capacityReservationName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The name of the capacity reservation group.
     */
    @JvmName("fjqaukqbtpseoiwi")
    public suspend fun capacityReservationGroupName(`value`: Output<String>) {
        this.capacityReservationGroupName = value
    }

    /**
     * @param value The name of the capacity reservation.
     */
    @JvmName("wsnhqenalngntign")
    public suspend fun capacityReservationName(`value`: Output<String>) {
        this.capacityReservationName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("afhibqoelhsslpgr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("faaiammmddssdlvr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SKU of the resource for which capacity needs be reserved. The SKU name and capacity is required to be set. Currently VM Skus with the capability called 'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported values.
     */
    @JvmName("rknfludmjylycoyh")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("anlgtwosmsklnfmp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Availability Zone to use for this capacity reservation. The zone has to be single value and also should be part for the list of zones specified during the capacity reservation group creation. The zone can be assigned only during creation. If not provided, the reservation supports only non-zonal deployments. If provided, enforces VM/VMSS using this capacity reservation to be in same zone.
     */
    @JvmName("mxoejhcdpshvnont")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("sslwrvgbdmrrjarn")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values Availability Zone to use for this capacity reservation. The zone has to be single value and also should be part for the list of zones specified during the capacity reservation group creation. The zone can be assigned only during creation. If not provided, the reservation supports only non-zonal deployments. If provided, enforces VM/VMSS using this capacity reservation to be in same zone.
     */
    @JvmName("kppgpwhwbkluvgfj")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The name of the capacity reservation group.
     */
    @JvmName("iuhhvcbadxfpccqn")
    public suspend fun capacityReservationGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationGroupName = mapped
    }

    /**
     * @param value The name of the capacity reservation.
     */
    @JvmName("dyhxukbobogtxcup")
    public suspend fun capacityReservationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("rcwxslrsumdcpymt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mdmaspjahwwfmysg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SKU of the resource for which capacity needs be reserved. The SKU name and capacity is required to be set. Currently VM Skus with the capability called 'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported values.
     */
    @JvmName("wohxjdknnfnydvpg")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU of the resource for which capacity needs be reserved. The SKU name and capacity is required to be set. Currently VM Skus with the capability called 'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported values.
     */
    @JvmName("qsaruojiqdcecfpj")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("vyisupwrverdbfrh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("qdvhxypjgbgautyr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Availability Zone to use for this capacity reservation. The zone has to be single value and also should be part for the list of zones specified during the capacity reservation group creation. The zone can be assigned only during creation. If not provided, the reservation supports only non-zonal deployments. If provided, enforces VM/VMSS using this capacity reservation to be in same zone.
     */
    @JvmName("erdamfksvakbmsin")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values Availability Zone to use for this capacity reservation. The zone has to be single value and also should be part for the list of zones specified during the capacity reservation group creation. The zone can be assigned only during creation. If not provided, the reservation supports only non-zonal deployments. If provided, enforces VM/VMSS using this capacity reservation to be in same zone.
     */
    @JvmName("pugkvgibnijxmdwu")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): CapacityReservationArgs = CapacityReservationArgs(
        capacityReservationGroupName = capacityReservationGroupName,
        capacityReservationName = capacityReservationName,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        zones = zones,
    )
}
