@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.CloudServiceArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.CloudServicePropertiesArgs
import com.pulumi.azurenative.compute.kotlin.inputs.CloudServicePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes the cloud service.
 * Azure REST API version: 2022-09-04. Prior API version in Azure Native 1.x: 2021-03-01.
 * ## Example Usage
 * ### Create New Cloud Service with Multiple Roles
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudService = new AzureNative.Compute.CloudService("cloudService", new()
 *     {
 *         CloudServiceName = "{cs-name}",
 *         Location = "westus",
 *         Properties = new AzureNative.Compute.Inputs.CloudServicePropertiesArgs
 *         {
 *             Configuration = "{ServiceConfiguration}",
 *             NetworkProfile = new AzureNative.Compute.Inputs.CloudServiceNetworkProfileArgs
 *             {
 *                 LoadBalancerConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.LoadBalancerConfigurationArgs
 *                     {
 *                         Name = "contosolb",
 *                         Properties = new AzureNative.Compute.Inputs.LoadBalancerConfigurationPropertiesArgs
 *                         {
 *                             FrontendIpConfigurations = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationArgs
 *                                 {
 *                                     Name = "contosofe",
 *                                     Properties = new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs
 *                                     {
 *                                         PublicIPAddress = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                         {
 *                                             Id = "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             PackageUrl = "{PackageUrl}",
 *             RoleProfile = new AzureNative.Compute.Inputs.CloudServiceRoleProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoFrontend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoBackend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                 },
 *             },
 *             UpgradeMode = AzureNative.Compute.CloudServiceUpgradeMode.Auto,
 *         },
 *         ResourceGroupName = "ConstosoRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewCloudService(ctx, "cloudService", &compute.CloudServiceArgs{
 * 			CloudServiceName: pulumi.String("{cs-name}"),
 * 			Location:         pulumi.String("westus"),
 * 			Properties: &compute.CloudServicePropertiesArgs{
 * 				Configuration: pulumi.String("{ServiceConfiguration}"),
 * 				NetworkProfile: &compute.CloudServiceNetworkProfileArgs{
 * 					LoadBalancerConfigurations: compute.LoadBalancerConfigurationArray{
 * 						&compute.LoadBalancerConfigurationArgs{
 * 							Name: pulumi.String("contosolb"),
 * 							Properties: &compute.LoadBalancerConfigurationPropertiesArgs{
 * 								FrontendIpConfigurations: compute.LoadBalancerFrontendIpConfigurationArray{
 * 									&compute.LoadBalancerFrontendIpConfigurationArgs{
 * 										Name: pulumi.String("contosofe"),
 * 										Properties: &compute.LoadBalancerFrontendIpConfigurationPropertiesArgs{
 * 											PublicIPAddress: &compute.SubResourceArgs{
 * 												Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip"),
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				PackageUrl: pulumi.String("{PackageUrl}"),
 * 				RoleProfile: &compute.CloudServiceRoleProfileArgs{
 * 					Roles: compute.CloudServiceRoleProfilePropertiesArray{
 * 						&compute.CloudServiceRoleProfilePropertiesArgs{
 * 							Name: pulumi.String("ContosoFrontend"),
 * 							Sku: &compute.CloudServiceRoleSkuArgs{
 * 								Capacity: pulumi.Float64(1),
 * 								Name:     pulumi.String("Standard_D1_v2"),
 * 								Tier:     pulumi.String("Standard"),
 * 							},
 * 						},
 * 						&compute.CloudServiceRoleProfilePropertiesArgs{
 * 							Name: pulumi.String("ContosoBackend"),
 * 							Sku: &compute.CloudServiceRoleSkuArgs{
 * 								Capacity: pulumi.Float64(1),
 * 								Name:     pulumi.String("Standard_D1_v2"),
 * 								Tier:     pulumi.String("Standard"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				UpgradeMode: pulumi.String(compute.CloudServiceUpgradeModeAuto),
 * 			},
 * 			ResourceGroupName: pulumi.String("ConstosoRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CloudService;
 * import com.pulumi.azurenative.compute.CloudServiceArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServicePropertiesArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServiceRoleProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudService = new CloudService("cloudService", CloudServiceArgs.builder()
 *             .cloudServiceName("{cs-name}")
 *             .location("westus")
 *             .properties(CloudServicePropertiesArgs.builder()
 *                 .configuration("{ServiceConfiguration}")
 *                 .networkProfile(CloudServiceNetworkProfileArgs.builder()
 *                     .loadBalancerConfigurations(LoadBalancerConfigurationArgs.builder()
 *                         .name("contosolb")
 *                         .properties(LoadBalancerConfigurationPropertiesArgs.builder()
 *                             .frontendIpConfigurations(LoadBalancerFrontendIpConfigurationArgs.builder()
 *                                 .name("contosofe")
 *                                 .properties(LoadBalancerFrontendIpConfigurationPropertiesArgs.builder()
 *                                     .publicIPAddress(SubResourceArgs.builder()
 *                                         .id("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .packageUrl("{PackageUrl}")
 *                 .roleProfile(CloudServiceRoleProfileArgs.builder()
 *                     .roles(
 *                         CloudServiceRoleProfilePropertiesArgs.builder()
 *                             .name("ContosoFrontend")
 *                             .sku(CloudServiceRoleSkuArgs.builder()
 *                                 .capacity(1)
 *                                 .name("Standard_D1_v2")
 *                                 .tier("Standard")
 *                                 .build())
 *                             .build(),
 *                         CloudServiceRoleProfilePropertiesArgs.builder()
 *                             .name("ContosoBackend")
 *                             .sku(CloudServiceRoleSkuArgs.builder()
 *                                 .capacity(1)
 *                                 .name("Standard_D1_v2")
 *                                 .tier("Standard")
 *                                 .build())
 *                             .build())
 *                     .build())
 *                 .upgradeMode("Auto")
 *                 .build())
 *             .resourceGroupName("ConstosoRG")
 *             .build());
 *     }
 * }
 * ```
 * ### Create New Cloud Service with Multiple Roles in a specific availability zone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudService = new AzureNative.Compute.CloudService("cloudService", new()
 *     {
 *         CloudServiceName = "{cs-name}",
 *         Location = "westus",
 *         Properties = new AzureNative.Compute.Inputs.CloudServicePropertiesArgs
 *         {
 *             Configuration = "{ServiceConfiguration}",
 *             NetworkProfile = new AzureNative.Compute.Inputs.CloudServiceNetworkProfileArgs
 *             {
 *                 LoadBalancerConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.LoadBalancerConfigurationArgs
 *                     {
 *                         Name = "contosolb",
 *                         Properties = new AzureNative.Compute.Inputs.LoadBalancerConfigurationPropertiesArgs
 *                         {
 *                             FrontendIpConfigurations = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationArgs
 *                                 {
 *                                     Name = "contosofe",
 *                                     Properties = new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs
 *                                     {
 *                                         PublicIPAddress = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                         {
 *                                             Id = "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             PackageUrl = "{PackageUrl}",
 *             RoleProfile = new AzureNative.Compute.Inputs.CloudServiceRoleProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoFrontend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoBackend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                 },
 *             },
 *             UpgradeMode = AzureNative.Compute.CloudServiceUpgradeMode.Auto,
 *         },
 *         ResourceGroupName = "ConstosoRG",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewCloudService(ctx, "cloudService", &compute.CloudServiceArgs{
 * 			CloudServiceName: pulumi.String("{cs-name}"),
 * 			Location:         pulumi.String("westus"),
 * 			Properties: &compute.CloudServicePropertiesArgs{
 * 				Configuration: pulumi.String("{ServiceConfiguration}"),
 * 				NetworkProfile: &compute.CloudServiceNetworkProfileArgs{
 * 					LoadBalancerConfigurations: compute.LoadBalancerConfigurationArray{
 * 						&compute.LoadBalancerConfigurationArgs{
 * 							Name: pulumi.String("contosolb"),
 * 							Properties: &compute.LoadBalancerConfigurationPropertiesArgs{
 * 								FrontendIpConfigurations: compute.LoadBalancerFrontendIpConfigurationArray{
 * 									&compute.LoadBalancerFrontendIpConfigurationArgs{
 * 										Name: pulumi.String("contosofe"),
 * 										Properties: &compute.LoadBalancerFrontendIpConfigurationPropertiesArgs{
 * 											PublicIPAddress: &compute.SubResourceArgs{
 * 												Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip"),
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				PackageUrl: pulumi.String("{PackageUrl}"),
 * 				RoleProfile: &compute.CloudServiceRoleProfileArgs{
 * 					Roles: compute.CloudServiceRoleProfilePropertiesArray{
 * 						&compute.CloudServiceRoleProfilePropertiesArgs{
 * 							Name: pulumi.String("ContosoFrontend"),
 * 							Sku: &compute.CloudServiceRoleSkuArgs{
 * 								Capacity: pulumi.Float64(1),
 * 								Name:     pulumi.String("Standard_D1_v2"),
 * 								Tier:     pulumi.String("Standard"),
 * 							},
 * 						},
 * 						&compute.CloudServiceRoleProfilePropertiesArgs{
 * 							Name: pulumi.String("ContosoBackend"),
 * 							Sku: &compute.CloudServiceRoleSkuArgs{
 * 								Capacity: pulumi.Float64(1),
 * 								Name:     pulumi.String("Standard_D1_v2"),
 * 								Tier:     pulumi.String("Standard"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				UpgradeMode: pulumi.String(compute.CloudServiceUpgradeModeAuto),
 * 			},
 * 			ResourceGroupName: pulumi.String("ConstosoRG"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CloudService;
 * import com.pulumi.azurenative.compute.CloudServiceArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServicePropertiesArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServiceRoleProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudService = new CloudService("cloudService", CloudServiceArgs.builder()
 *             .cloudServiceName("{cs-name}")
 *             .location("westus")
 *             .properties(CloudServicePropertiesArgs.builder()
 *                 .configuration("{ServiceConfiguration}")
 *                 .networkProfile(CloudServiceNetworkProfileArgs.builder()
 *                     .loadBalancerConfigurations(LoadBalancerConfigurationArgs.builder()
 *                         .name("contosolb")
 *                         .properties(LoadBalancerConfigurationPropertiesArgs.builder()
 *                             .frontendIpConfigurations(LoadBalancerFrontendIpConfigurationArgs.builder()
 *                                 .name("contosofe")
 *                                 .properties(LoadBalancerFrontendIpConfigurationPropertiesArgs.builder()
 *                                     .publicIPAddress(SubResourceArgs.builder()
 *                                         .id("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .packageUrl("{PackageUrl}")
 *                 .roleProfile(CloudServiceRoleProfileArgs.builder()
 *                     .roles(
 *                         CloudServiceRoleProfilePropertiesArgs.builder()
 *                             .name("ContosoFrontend")
 *                             .sku(CloudServiceRoleSkuArgs.builder()
 *                                 .capacity(1)
 *                                 .name("Standard_D1_v2")
 *                                 .tier("Standard")
 *                                 .build())
 *                             .build(),
 *                         CloudServiceRoleProfilePropertiesArgs.builder()
 *                             .name("ContosoBackend")
 *                             .sku(CloudServiceRoleSkuArgs.builder()
 *                                 .capacity(1)
 *                                 .name("Standard_D1_v2")
 *                                 .tier("Standard")
 *                                 .build())
 *                             .build())
 *                     .build())
 *                 .upgradeMode("Auto")
 *                 .build())
 *             .resourceGroupName("ConstosoRG")
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create New Cloud Service with Single Role
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudService = new AzureNative.Compute.CloudService("cloudService", new()
 *     {
 *         CloudServiceName = "{cs-name}",
 *         Location = "westus",
 *         Properties = new AzureNative.Compute.Inputs.CloudServicePropertiesArgs
 *         {
 *             Configuration = "{ServiceConfiguration}",
 *             NetworkProfile = new AzureNative.Compute.Inputs.CloudServiceNetworkProfileArgs
 *             {
 *                 LoadBalancerConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.LoadBalancerConfigurationArgs
 *                     {
 *                         Name = "myLoadBalancer",
 *                         Properties = new AzureNative.Compute.Inputs.LoadBalancerConfigurationPropertiesArgs
 *                         {
 *                             FrontendIpConfigurations = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationArgs
 *                                 {
 *                                     Name = "myfe",
 *                                     Properties = new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs
 *                                     {
 *                                         PublicIPAddress = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                         {
 *                                             Id = "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/myPublicIP",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             PackageUrl = "{PackageUrl}",
 *             RoleProfile = new AzureNative.Compute.Inputs.CloudServiceRoleProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoFrontend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                 },
 *             },
 *             UpgradeMode = AzureNative.Compute.CloudServiceUpgradeMode.Auto,
 *         },
 *         ResourceGroupName = "ConstosoRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewCloudService(ctx, "cloudService", &compute.CloudServiceArgs{
 * 			CloudServiceName: pulumi.String("{cs-name}"),
 * 			Location:         pulumi.String("westus"),
 * 			Properties: &compute.CloudServicePropertiesArgs{
 * 				Configuration: pulumi.String("{ServiceConfiguration}"),
 * 				NetworkProfile: &compute.CloudServiceNetworkProfileArgs{
 * 					LoadBalancerConfigurations: compute.LoadBalancerConfigurationArray{
 * 						&compute.LoadBalancerConfigurationArgs{
 * 							Name: pulumi.String("myLoadBalancer"),
 * 							Properties: &compute.LoadBalancerConfigurationPropertiesArgs{
 * 								FrontendIpConfigurations: compute.LoadBalancerFrontendIpConfigurationArray{
 * 									&compute.LoadBalancerFrontendIpConfigurationArgs{
 * 										Name: pulumi.String("myfe"),
 * 										Properties: &compute.LoadBalancerFrontendIpConfigurationPropertiesArgs{
 * 											PublicIPAddress: &compute.SubResourceArgs{
 * 												Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/myPublicIP"),
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				PackageUrl: pulumi.String("{PackageUrl}"),
 * 				RoleProfile: &compute.CloudServiceRoleProfileArgs{
 * 					Roles: compute.CloudServiceRoleProfilePropertiesArray{
 * 						&compute.CloudServiceRoleProfilePropertiesArgs{
 * 							Name: pulumi.String("ContosoFrontend"),
 * 							Sku: &compute.CloudServiceRoleSkuArgs{
 * 								Capacity: pulumi.Float64(1),
 * 								Name:     pulumi.String("Standard_D1_v2"),
 * 								Tier:     pulumi.String("Standard"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				UpgradeMode: pulumi.String(compute.CloudServiceUpgradeModeAuto),
 * 			},
 * 			ResourceGroupName: pulumi.String("ConstosoRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CloudService;
 * import com.pulumi.azurenative.compute.CloudServiceArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServicePropertiesArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServiceRoleProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudService = new CloudService("cloudService", CloudServiceArgs.builder()
 *             .cloudServiceName("{cs-name}")
 *             .location("westus")
 *             .properties(CloudServicePropertiesArgs.builder()
 *                 .configuration("{ServiceConfiguration}")
 *                 .networkProfile(CloudServiceNetworkProfileArgs.builder()
 *                     .loadBalancerConfigurations(LoadBalancerConfigurationArgs.builder()
 *                         .name("myLoadBalancer")
 *                         .properties(LoadBalancerConfigurationPropertiesArgs.builder()
 *                             .frontendIpConfigurations(LoadBalancerFrontendIpConfigurationArgs.builder()
 *                                 .name("myfe")
 *                                 .properties(LoadBalancerFrontendIpConfigurationPropertiesArgs.builder()
 *                                     .publicIPAddress(SubResourceArgs.builder()
 *                                         .id("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/myPublicIP")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .packageUrl("{PackageUrl}")
 *                 .roleProfile(CloudServiceRoleProfileArgs.builder()
 *                     .roles(CloudServiceRoleProfilePropertiesArgs.builder()
 *                         .name("ContosoFrontend")
 *                         .sku(CloudServiceRoleSkuArgs.builder()
 *                             .capacity(1)
 *                             .name("Standard_D1_v2")
 *                             .tier("Standard")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .upgradeMode("Auto")
 *                 .build())
 *             .resourceGroupName("ConstosoRG")
 *             .build());
 *     }
 * }
 * ```
 * ### Create New Cloud Service with Single Role and Certificate from Key Vault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudService = new AzureNative.Compute.CloudService("cloudService", new()
 *     {
 *         CloudServiceName = "{cs-name}",
 *         Location = "westus",
 *         Properties = new AzureNative.Compute.Inputs.CloudServicePropertiesArgs
 *         {
 *             Configuration = "{ServiceConfiguration}",
 *             NetworkProfile = new AzureNative.Compute.Inputs.CloudServiceNetworkProfileArgs
 *             {
 *                 LoadBalancerConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.LoadBalancerConfigurationArgs
 *                     {
 *                         Name = "contosolb",
 *                         Properties = new AzureNative.Compute.Inputs.LoadBalancerConfigurationPropertiesArgs
 *                         {
 *                             FrontendIpConfigurations = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationArgs
 *                                 {
 *                                     Name = "contosofe",
 *                                     Properties = new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs
 *                                     {
 *                                         PublicIPAddress = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                         {
 *                                             Id = "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             OsProfile = new AzureNative.Compute.Inputs.CloudServiceOsProfileArgs
 *             {
 *                 Secrets = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.CloudServiceVaultSecretGroupArgs
 *                     {
 *                         SourceVault = new AzureNative.Compute.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.KeyVault/vaults/{keyvault-name}",
 *                         },
 *                         VaultCertificates = new[]
 *                         {
 *                             new AzureNative.Compute.Inputs.CloudServiceVaultCertificateArgs
 *                             {
 *                                 CertificateUrl = "https://{keyvault-name}.vault.azure.net:443/secrets/ContosoCertificate/{secret-id}",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             PackageUrl = "{PackageUrl}",
 *             RoleProfile = new AzureNative.Compute.Inputs.CloudServiceRoleProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoFrontend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                 },
 *             },
 *             UpgradeMode = AzureNative.Compute.CloudServiceUpgradeMode.Auto,
 *         },
 *         ResourceGroupName = "ConstosoRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewCloudService(ctx, "cloudService", &compute.CloudServiceArgs{
 * 			CloudServiceName: pulumi.String("{cs-name}"),
 * 			Location:         pulumi.String("westus"),
 * 			Properties: &compute.CloudServicePropertiesArgs{
 * 				Configuration: pulumi.String("{ServiceConfiguration}"),
 * 				NetworkProfile: &compute.CloudServiceNetworkProfileArgs{
 * 					LoadBalancerConfigurations: compute.LoadBalancerConfigurationArray{
 * 						&compute.LoadBalancerConfigurationArgs{
 * 							Name: pulumi.String("contosolb"),
 * 							Properties: &compute.LoadBalancerConfigurationPropertiesArgs{
 * 								FrontendIpConfigurations: compute.LoadBalancerFrontendIpConfigurationArray{
 * 									&compute.LoadBalancerFrontendIpConfigurationArgs{
 * 										Name: pulumi.String("contosofe"),
 * 										Properties: &compute.LoadBalancerFrontendIpConfigurationPropertiesArgs{
 * 											PublicIPAddress: &compute.SubResourceArgs{
 * 												Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip"),
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				OsProfile: &compute.CloudServiceOsProfileArgs{
 * 					Secrets: compute.CloudServiceVaultSecretGroupArray{
 * 						&compute.CloudServiceVaultSecretGroupArgs{
 * 							SourceVault: &compute.SubResourceArgs{
 * 								Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.KeyVault/vaults/{keyvault-name}"),
 * 							},
 * 							VaultCertificates: compute.CloudServiceVaultCertificateArray{
 * 								&compute.CloudServiceVaultCertificateArgs{
 * 									CertificateUrl: pulumi.String("https://{keyvault-name}.vault.azure.net:443/secrets/ContosoCertificate/{secret-id}"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				PackageUrl: pulumi.String("{PackageUrl}"),
 * 				RoleProfile: &compute.CloudServiceRoleProfileArgs{
 * 					Roles: compute.CloudServiceRoleProfilePropertiesArray{
 * 						&compute.CloudServiceRoleProfilePropertiesArgs{
 * 							Name: pulumi.String("ContosoFrontend"),
 * 							Sku: &compute.CloudServiceRoleSkuArgs{
 * 								Capacity: pulumi.Float64(1),
 * 								Name:     pulumi.String("Standard_D1_v2"),
 * 								Tier:     pulumi.String("Standard"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				UpgradeMode: pulumi.String(compute.CloudServiceUpgradeModeAuto),
 * 			},
 * 			ResourceGroupName: pulumi.String("ConstosoRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CloudService;
 * import com.pulumi.azurenative.compute.CloudServiceArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServicePropertiesArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServiceOsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServiceRoleProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudService = new CloudService("cloudService", CloudServiceArgs.builder()
 *             .cloudServiceName("{cs-name}")
 *             .location("westus")
 *             .properties(CloudServicePropertiesArgs.builder()
 *                 .configuration("{ServiceConfiguration}")
 *                 .networkProfile(CloudServiceNetworkProfileArgs.builder()
 *                     .loadBalancerConfigurations(LoadBalancerConfigurationArgs.builder()
 *                         .name("contosolb")
 *                         .properties(LoadBalancerConfigurationPropertiesArgs.builder()
 *                             .frontendIpConfigurations(LoadBalancerFrontendIpConfigurationArgs.builder()
 *                                 .name("contosofe")
 *                                 .properties(LoadBalancerFrontendIpConfigurationPropertiesArgs.builder()
 *                                     .publicIPAddress(SubResourceArgs.builder()
 *                                         .id("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .osProfile(CloudServiceOsProfileArgs.builder()
 *                     .secrets(CloudServiceVaultSecretGroupArgs.builder()
 *                         .sourceVault(SubResourceArgs.builder()
 *                             .id("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.KeyVault/vaults/{keyvault-name}")
 *                             .build())
 *                         .vaultCertificates(CloudServiceVaultCertificateArgs.builder()
 *                             .certificateUrl("https://{keyvault-name}.vault.azure.net:443/secrets/ContosoCertificate/{secret-id}")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .packageUrl("{PackageUrl}")
 *                 .roleProfile(CloudServiceRoleProfileArgs.builder()
 *                     .roles(CloudServiceRoleProfilePropertiesArgs.builder()
 *                         .name("ContosoFrontend")
 *                         .sku(CloudServiceRoleSkuArgs.builder()
 *                             .capacity(1)
 *                             .name("Standard_D1_v2")
 *                             .tier("Standard")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .upgradeMode("Auto")
 *                 .build())
 *             .resourceGroupName("ConstosoRG")
 *             .build());
 *     }
 * }
 * ```
 * ### Create New Cloud Service with Single Role and RDP Extension
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudService = new AzureNative.Compute.CloudService("cloudService", new()
 *     {
 *         CloudServiceName = "{cs-name}",
 *         Location = "westus",
 *         Properties = new AzureNative.Compute.Inputs.CloudServicePropertiesArgs
 *         {
 *             Configuration = "{ServiceConfiguration}",
 *             ExtensionProfile = new AzureNative.Compute.Inputs.CloudServiceExtensionProfileArgs
 *             {
 *                 Extensions = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.ExtensionArgs
 *                     {
 *                         Name = "RDPExtension",
 *                         Properties = new AzureNative.Compute.Inputs.CloudServiceExtensionPropertiesArgs
 *                         {
 *                             AutoUpgradeMinorVersion = false,
 *                             ProtectedSettings = "<PrivateConfig><Password>{password}</Password></PrivateConfig>",
 *                             Publisher = "Microsoft.Windows.Azure.Extensions",
 *                             Settings = "<PublicConfig><UserName>UserAzure</UserName><Expiration>10/22/2021 15:05:45</Expiration></PublicConfig>",
 *                             Type = "RDP",
 *                             TypeHandlerVersion = "1.2",
 *                         },
 *                     },
 *                 },
 *             },
 *             NetworkProfile = new AzureNative.Compute.Inputs.CloudServiceNetworkProfileArgs
 *             {
 *                 LoadBalancerConfigurations = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.LoadBalancerConfigurationArgs
 *                     {
 *                         Name = "contosolb",
 *                         Properties = new AzureNative.Compute.Inputs.LoadBalancerConfigurationPropertiesArgs
 *                         {
 *                             FrontendIpConfigurations = new[]
 *                             {
 *                                 new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationArgs
 *                                 {
 *                                     Name = "contosofe",
 *                                     Properties = new AzureNative.Compute.Inputs.LoadBalancerFrontendIpConfigurationPropertiesArgs
 *                                     {
 *                                         PublicIPAddress = new AzureNative.Compute.Inputs.SubResourceArgs
 *                                         {
 *                                             Id = "/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             PackageUrl = "{PackageUrl}",
 *             RoleProfile = new AzureNative.Compute.Inputs.CloudServiceRoleProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.Compute.Inputs.CloudServiceRoleProfilePropertiesArgs
 *                     {
 *                         Name = "ContosoFrontend",
 *                         Sku = new AzureNative.Compute.Inputs.CloudServiceRoleSkuArgs
 *                         {
 *                             Capacity = 1,
 *                             Name = "Standard_D1_v2",
 *                             Tier = "Standard",
 *                         },
 *                     },
 *                 },
 *             },
 *             UpgradeMode = AzureNative.Compute.CloudServiceUpgradeMode.Auto,
 *         },
 *         ResourceGroupName = "ConstosoRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewCloudService(ctx, "cloudService", &compute.CloudServiceArgs{
 * 			CloudServiceName: pulumi.String("{cs-name}"),
 * 			Location:         pulumi.String("westus"),
 * 			Properties: &compute.CloudServicePropertiesArgs{
 * 				Configuration: pulumi.String("{ServiceConfiguration}"),
 * 				ExtensionProfile: &compute.CloudServiceExtensionProfileArgs{
 * 					Extensions: compute.ExtensionArray{
 * 						&compute.ExtensionArgs{
 * 							Name: pulumi.String("RDPExtension"),
 * 							Properties: &compute.CloudServiceExtensionPropertiesArgs{
 * 								AutoUpgradeMinorVersion: pulumi.Bool(false),
 * 								ProtectedSettings:       pulumi.Any("<PrivateConfig><Password>{password}</Password></PrivateConfig>"),
 * 								Publisher:               pulumi.String("Microsoft.Windows.Azure.Extensions"),
 * 								Settings:                pulumi.Any("<PublicConfig><UserName>UserAzure</UserName><Expiration>10/22/2021 15:05:45</Expiration></PublicConfig>"),
 * 								Type:                    pulumi.String("RDP"),
 * 								TypeHandlerVersion:      pulumi.String("1.2"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				NetworkProfile: &compute.CloudServiceNetworkProfileArgs{
 * 					LoadBalancerConfigurations: compute.LoadBalancerConfigurationArray{
 * 						&compute.LoadBalancerConfigurationArgs{
 * 							Name: pulumi.String("contosolb"),
 * 							Properties: &compute.LoadBalancerConfigurationPropertiesArgs{
 * 								FrontendIpConfigurations: compute.LoadBalancerFrontendIpConfigurationArray{
 * 									&compute.LoadBalancerFrontendIpConfigurationArgs{
 * 										Name: pulumi.String("contosofe"),
 * 										Properties: &compute.LoadBalancerFrontendIpConfigurationPropertiesArgs{
 * 											PublicIPAddress: &compute.SubResourceArgs{
 * 												Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip"),
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				PackageUrl: pulumi.String("{PackageUrl}"),
 * 				RoleProfile: &compute.CloudServiceRoleProfileArgs{
 * 					Roles: compute.CloudServiceRoleProfilePropertiesArray{
 * 						&compute.CloudServiceRoleProfilePropertiesArgs{
 * 							Name: pulumi.String("ContosoFrontend"),
 * 							Sku: &compute.CloudServiceRoleSkuArgs{
 * 								Capacity: pulumi.Float64(1),
 * 								Name:     pulumi.String("Standard_D1_v2"),
 * 								Tier:     pulumi.String("Standard"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				UpgradeMode: pulumi.String(compute.CloudServiceUpgradeModeAuto),
 * 			},
 * 			ResourceGroupName: pulumi.String("ConstosoRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.CloudService;
 * import com.pulumi.azurenative.compute.CloudServiceArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServicePropertiesArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServiceExtensionProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServiceNetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.CloudServiceRoleProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudService = new CloudService("cloudService", CloudServiceArgs.builder()
 *             .cloudServiceName("{cs-name}")
 *             .location("westus")
 *             .properties(CloudServicePropertiesArgs.builder()
 *                 .configuration("{ServiceConfiguration}")
 *                 .extensionProfile(CloudServiceExtensionProfileArgs.builder()
 *                     .extensions(ExtensionArgs.builder()
 *                         .name("RDPExtension")
 *                         .properties(CloudServiceExtensionPropertiesArgs.builder()
 *                             .autoUpgradeMinorVersion(false)
 *                             .protectedSettings("<PrivateConfig><Password>{password}</Password></PrivateConfig>")
 *                             .publisher("Microsoft.Windows.Azure.Extensions")
 *                             .settings("<PublicConfig><UserName>UserAzure</UserName><Expiration>10/22/2021 15:05:45</Expiration></PublicConfig>")
 *                             .type("RDP")
 *                             .typeHandlerVersion("1.2")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .networkProfile(CloudServiceNetworkProfileArgs.builder()
 *                     .loadBalancerConfigurations(LoadBalancerConfigurationArgs.builder()
 *                         .name("contosolb")
 *                         .properties(LoadBalancerConfigurationPropertiesArgs.builder()
 *                             .frontendIpConfigurations(LoadBalancerFrontendIpConfigurationArgs.builder()
 *                                 .name("contosofe")
 *                                 .properties(LoadBalancerFrontendIpConfigurationPropertiesArgs.builder()
 *                                     .publicIPAddress(SubResourceArgs.builder()
 *                                         .id("/subscriptions/{subscription-id}/resourceGroups/ConstosoRG/providers/Microsoft.Network/publicIPAddresses/contosopublicip")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .packageUrl("{PackageUrl}")
 *                 .roleProfile(CloudServiceRoleProfileArgs.builder()
 *                     .roles(CloudServiceRoleProfilePropertiesArgs.builder()
 *                         .name("ContosoFrontend")
 *                         .sku(CloudServiceRoleSkuArgs.builder()
 *                             .capacity(1)
 *                             .name("Standard_D1_v2")
 *                             .tier("Standard")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .upgradeMode("Auto")
 *                 .build())
 *             .resourceGroupName("ConstosoRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:CloudService {cs-name} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}
 * ```
 * @property cloudServiceName Name of the cloud service.
 * @property location Resource location.
 * @property properties Cloud service properties
 * @property resourceGroupName Name of the resource group.
 * @property tags Resource tags.
 * @property zones List of logical availability zone of the resource. List should contain only 1 zone where cloud service should be provisioned. This field is optional.
 */
public data class CloudServiceArgs(
    public val cloudServiceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<CloudServicePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.CloudServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.CloudServiceArgs =
        com.pulumi.azurenative.compute.CloudServiceArgs.builder()
            .cloudServiceName(cloudServiceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CloudServiceArgs].
 */
@PulumiTagMarker
public class CloudServiceArgsBuilder internal constructor() {
    private var cloudServiceName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<CloudServicePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Name of the cloud service.
     */
    @JvmName("pqtheilsetglayvx")
    public suspend fun cloudServiceName(`value`: Output<String>) {
        this.cloudServiceName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("lyoglpkilivupqel")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Cloud service properties
     */
    @JvmName("pycvbsyoqfwxghio")
    public suspend fun properties(`value`: Output<CloudServicePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("ujwioikvjonkvnrn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yteklvirfprtxiig")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of logical availability zone of the resource. List should contain only 1 zone where cloud service should be provisioned. This field is optional.
     */
    @JvmName("rbbryylanfwjneld")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("kyafcivuifsvohys")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values List of logical availability zone of the resource. List should contain only 1 zone where cloud service should be provisioned. This field is optional.
     */
    @JvmName("caxlclxywrdtwsyc")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Name of the cloud service.
     */
    @JvmName("aormxbqsnmjrldiw")
    public suspend fun cloudServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudServiceName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("rxcyffmhnksipquc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Cloud service properties
     */
    @JvmName("pconprcvkfmfgvdk")
    public suspend fun properties(`value`: CloudServicePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Cloud service properties
     */
    @JvmName("oamtaygeixuwpwlr")
    public suspend fun properties(argument: suspend CloudServicePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CloudServicePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("qkdjkbdqmudvdwlc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nyticqnkxblsvtxw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qdfqicsavqyxeoef")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value List of logical availability zone of the resource. List should contain only 1 zone where cloud service should be provisioned. This field is optional.
     */
    @JvmName("logvtevhcoljruty")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values List of logical availability zone of the resource. List should contain only 1 zone where cloud service should be provisioned. This field is optional.
     */
    @JvmName("qcdmbxvaybrlvfxh")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): CloudServiceArgs = CloudServiceArgs(
        cloudServiceName = cloudServiceName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        zones = zones,
    )
}
