@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.DedicatedHostInstanceViewResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.DedicatedHostInstanceViewResponse.Companion.toKotlin as dedicatedHostInstanceViewResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse.Companion.toKotlin as subResourceReadOnlyResponseToKotlin

/**
 * Builder for [DedicatedHost].
 */
@PulumiTagMarker
public class DedicatedHostResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DedicatedHostArgs = DedicatedHostArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DedicatedHostArgsBuilder.() -> Unit) {
        val builder = DedicatedHostArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DedicatedHost {
        val builtJavaResource = com.pulumi.azurenative.compute.DedicatedHost(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DedicatedHost(builtJavaResource)
    }
}

/**
 * Specifies information about the Dedicated host.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create or update a dedicated host .
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedHost = new AzureNative.Compute.DedicatedHost("dedicatedHost", new()
 *     {
 *         HostGroupName = "myDedicatedHostGroup",
 *         HostName = "myDedicatedHost",
 *         Location = "westus",
 *         PlatformFaultDomain = 1,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Name = "DSv3-Type1",
 *         },
 *         Tags =
 *         {
 *             { "department", "HR" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDedicatedHost(ctx, "dedicatedHost", &compute.DedicatedHostArgs{
 * 			HostGroupName:       pulumi.String("myDedicatedHostGroup"),
 * 			HostName:            pulumi.String("myDedicatedHost"),
 * 			Location:            pulumi.String("westus"),
 * 			PlatformFaultDomain: pulumi.Int(1),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Name: pulumi.String("DSv3-Type1"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"department": pulumi.String("HR"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.DedicatedHost;
 * import com.pulumi.azurenative.compute.DedicatedHostArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedHost = new DedicatedHost("dedicatedHost", DedicatedHostArgs.builder()
 *             .hostGroupName("myDedicatedHostGroup")
 *             .hostName("myDedicatedHost")
 *             .location("westus")
 *             .platformFaultDomain(1)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("DSv3-Type1")
 *                 .build())
 *             .tags(Map.of("department", "HR"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:DedicatedHost myDedicatedHost /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}
 * ```
 */
public class DedicatedHost internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.DedicatedHost,
) : KotlinCustomResource(javaResource, DedicatedHostMapper) {
    /**
     * Specifies whether the dedicated host should be replaced automatically in case of a failure. The value is defaulted to 'true' when not provided.
     */
    public val autoReplaceOnFailure: Output<Boolean>?
        get() = javaResource.autoReplaceOnFailure().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique id generated and assigned to the dedicated host by the platform. Does not change throughout the lifetime of the host.
     */
    public val hostId: Output<String>
        get() = javaResource.hostId().applyValue({ args0 -> args0 })

    /**
     * The dedicated host instance view.
     */
    public val instanceView: Output<DedicatedHostInstanceViewResponse>
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.let({ args0 ->
                dedicatedHostInstanceViewResponseToKotlin(args0)
            })
        })

    /**
     * Specifies the software license type that will be applied to the VMs deployed on the dedicated host. Possible values are: **None,** **Windows_Server_Hybrid,** **Windows_Server_Perpetual.** The default value is: **None.**
     */
    public val licenseType: Output<String>?
        get() = javaResource.licenseType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Fault domain of the dedicated host within a dedicated host group.
     */
    public val platformFaultDomain: Output<Int>?
        get() = javaResource.platformFaultDomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The date when the host was first provisioned.
     */
    public val provisioningTime: Output<String>
        get() = javaResource.provisioningTime().applyValue({ args0 -> args0 })

    /**
     * SKU of the dedicated host for Hardware Generation and VM family. Only name is required to be set. List Microsoft.Compute SKUs for a list of possible values.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the time at which the Dedicated Host resource was created. Minimum api-version: 2021-11-01.
     */
    public val timeCreated: Output<String>
        get() = javaResource.timeCreated().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A list of references to all virtual machines in the Dedicated Host.
     */
    public val virtualMachines: Output<List<SubResourceReadOnlyResponse>>
        get() = javaResource.virtualMachines().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceReadOnlyResponseToKotlin(args0) })
            })
        })
}

public object DedicatedHostMapper : ResourceMapper<DedicatedHost> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.DedicatedHost::class == javaResource::class

    override fun map(javaResource: Resource): DedicatedHost = DedicatedHost(
        javaResource as
            com.pulumi.azurenative.compute.DedicatedHost,
    )
}

/**
 * @see [DedicatedHost].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DedicatedHost].
 */
public suspend fun dedicatedHost(
    name: String,
    block: suspend DedicatedHostResourceBuilder.() -> Unit,
): DedicatedHost {
    val builder = DedicatedHostResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DedicatedHost].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dedicatedHost(name: String): DedicatedHost {
    val builder = DedicatedHostResourceBuilder()
    builder.name(name)
    return builder.build()
}
