@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.DedicatedHostArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DedicatedHostLicenseTypes
import com.pulumi.azurenative.compute.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies information about the Dedicated host.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create or update a dedicated host .
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedHost = new AzureNative.Compute.DedicatedHost("dedicatedHost", new()
 *     {
 *         HostGroupName = "myDedicatedHostGroup",
 *         HostName = "myDedicatedHost",
 *         Location = "westus",
 *         PlatformFaultDomain = 1,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Compute.Inputs.SkuArgs
 *         {
 *             Name = "DSv3-Type1",
 *         },
 *         Tags =
 *         {
 *             { "department", "HR" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDedicatedHost(ctx, "dedicatedHost", &compute.DedicatedHostArgs{
 * 			HostGroupName:       pulumi.String("myDedicatedHostGroup"),
 * 			HostName:            pulumi.String("myDedicatedHost"),
 * 			Location:            pulumi.String("westus"),
 * 			PlatformFaultDomain: pulumi.Int(1),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			Sku: &compute.SkuArgs{
 * 				Name: pulumi.String("DSv3-Type1"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"department": pulumi.String("HR"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.DedicatedHost;
 * import com.pulumi.azurenative.compute.DedicatedHostArgs;
 * import com.pulumi.azurenative.compute.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedHost = new DedicatedHost("dedicatedHost", DedicatedHostArgs.builder()
 *             .hostGroupName("myDedicatedHostGroup")
 *             .hostName("myDedicatedHost")
 *             .location("westus")
 *             .platformFaultDomain(1)
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("DSv3-Type1")
 *                 .build())
 *             .tags(Map.of("department", "HR"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:DedicatedHost myDedicatedHost /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}
 * ```
 * @property autoReplaceOnFailure Specifies whether the dedicated host should be replaced automatically in case of a failure. The value is defaulted to 'true' when not provided.
 * @property hostGroupName The name of the dedicated host group.
 * @property hostName The name of the dedicated host .
 * @property licenseType Specifies the software license type that will be applied to the VMs deployed on the dedicated host. Possible values are: **None,** **Windows_Server_Hybrid,** **Windows_Server_Perpetual.** The default value is: **None.**
 * @property location Resource location
 * @property platformFaultDomain Fault domain of the dedicated host within a dedicated host group.
 * @property resourceGroupName The name of the resource group.
 * @property sku SKU of the dedicated host for Hardware Generation and VM family. Only name is required to be set. List Microsoft.Compute SKUs for a list of possible values.
 * @property tags Resource tags
 */
public data class DedicatedHostArgs(
    public val autoReplaceOnFailure: Output<Boolean>? = null,
    public val hostGroupName: Output<String>? = null,
    public val hostName: Output<String>? = null,
    public val licenseType: Output<DedicatedHostLicenseTypes>? = null,
    public val location: Output<String>? = null,
    public val platformFaultDomain: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.DedicatedHostArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.DedicatedHostArgs =
        com.pulumi.azurenative.compute.DedicatedHostArgs.builder()
            .autoReplaceOnFailure(autoReplaceOnFailure?.applyValue({ args0 -> args0 }))
            .hostGroupName(hostGroupName?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .licenseType(licenseType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .platformFaultDomain(platformFaultDomain?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DedicatedHostArgs].
 */
@PulumiTagMarker
public class DedicatedHostArgsBuilder internal constructor() {
    private var autoReplaceOnFailure: Output<Boolean>? = null

    private var hostGroupName: Output<String>? = null

    private var hostName: Output<String>? = null

    private var licenseType: Output<DedicatedHostLicenseTypes>? = null

    private var location: Output<String>? = null

    private var platformFaultDomain: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies whether the dedicated host should be replaced automatically in case of a failure. The value is defaulted to 'true' when not provided.
     */
    @JvmName("rbokxlyqomqgnrns")
    public suspend fun autoReplaceOnFailure(`value`: Output<Boolean>) {
        this.autoReplaceOnFailure = value
    }

    /**
     * @param value The name of the dedicated host group.
     */
    @JvmName("fpilgbfjgmlkbals")
    public suspend fun hostGroupName(`value`: Output<String>) {
        this.hostGroupName = value
    }

    /**
     * @param value The name of the dedicated host .
     */
    @JvmName("vlxbftjtudfeciyl")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Specifies the software license type that will be applied to the VMs deployed on the dedicated host. Possible values are: **None,** **Windows_Server_Hybrid,** **Windows_Server_Perpetual.** The default value is: **None.**
     */
    @JvmName("smfyjeejjvdqrugs")
    public suspend fun licenseType(`value`: Output<DedicatedHostLicenseTypes>) {
        this.licenseType = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("miicvlifxtirftxj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Fault domain of the dedicated host within a dedicated host group.
     */
    @JvmName("knoflpkfvpmbnmod")
    public suspend fun platformFaultDomain(`value`: Output<Int>) {
        this.platformFaultDomain = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tcfdtxokycviwmdw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SKU of the dedicated host for Hardware Generation and VM family. Only name is required to be set. List Microsoft.Compute SKUs for a list of possible values.
     */
    @JvmName("mljmwussxnjpkwdu")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("dpughmkvpntprfnd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies whether the dedicated host should be replaced automatically in case of a failure. The value is defaulted to 'true' when not provided.
     */
    @JvmName("irtyegqlddyevmoq")
    public suspend fun autoReplaceOnFailure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoReplaceOnFailure = mapped
    }

    /**
     * @param value The name of the dedicated host group.
     */
    @JvmName("bkktsqnvxdphxabg")
    public suspend fun hostGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostGroupName = mapped
    }

    /**
     * @param value The name of the dedicated host .
     */
    @JvmName("tqubbdnvxguvikug")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Specifies the software license type that will be applied to the VMs deployed on the dedicated host. Possible values are: **None,** **Windows_Server_Hybrid,** **Windows_Server_Perpetual.** The default value is: **None.**
     */
    @JvmName("yiytujrffbgdijkn")
    public suspend fun licenseType(`value`: DedicatedHostLicenseTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("kxyokdpypsxcpouh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Fault domain of the dedicated host within a dedicated host group.
     */
    @JvmName("utrycvqtckmrwevo")
    public suspend fun platformFaultDomain(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformFaultDomain = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xrnihmaogdefifpj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SKU of the dedicated host for Hardware Generation and VM family. Only name is required to be set. List Microsoft.Compute SKUs for a list of possible values.
     */
    @JvmName("tkxwddxarmrwqnof")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU of the dedicated host for Hardware Generation and VM family. Only name is required to be set. List Microsoft.Compute SKUs for a list of possible values.
     */
    @JvmName("oqlbjrdhpcuiegud")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("wkytnnlatqictavo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("drahnsxqlokmagfx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DedicatedHostArgs = DedicatedHostArgs(
        autoReplaceOnFailure = autoReplaceOnFailure,
        hostGroupName = hostGroupName,
        hostName = hostName,
        licenseType = licenseType,
        location = location,
        platformFaultDomain = platformFaultDomain,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
