@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.compute.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.compute.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin

/**
 * Builder for [DiskAccessAPrivateEndpointConnection].
 */
@PulumiTagMarker
public class DiskAccessAPrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiskAccessAPrivateEndpointConnectionArgs =
        DiskAccessAPrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiskAccessAPrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = DiskAccessAPrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DiskAccessAPrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.compute.DiskAccessAPrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DiskAccessAPrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2022-07-02. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-02, 2023-04-02, 2023-10-02.
 * ## Example Usage
 * ### Approve a Private Endpoint Connection under a disk access resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diskAccessAPrivateEndpointConnection = new AzureNative.Compute.DiskAccessAPrivateEndpointConnection("diskAccessAPrivateEndpointConnection", new()
 *     {
 *         DiskAccessName = "myDiskAccess",
 *         PrivateEndpointConnectionName = "myPrivateEndpointConnection",
 *         PrivateLinkServiceConnectionState = new AzureNative.Compute.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Approving myPrivateEndpointConnection",
 *             Status = AzureNative.Compute.PrivateEndpointServiceConnectionStatus.Approved,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDiskAccessAPrivateEndpointConnection(ctx, "diskAccessAPrivateEndpointConnection", &compute.DiskAccessAPrivateEndpointConnectionArgs{
 * 			DiskAccessName:                pulumi.String("myDiskAccess"),
 * 			PrivateEndpointConnectionName: pulumi.String("myPrivateEndpointConnection"),
 * 			PrivateLinkServiceConnectionState: &compute.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Approving myPrivateEndpointConnection"),
 * 				Status:      pulumi.String(compute.PrivateEndpointServiceConnectionStatusApproved),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.DiskAccessAPrivateEndpointConnection;
 * import com.pulumi.azurenative.compute.DiskAccessAPrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.compute.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diskAccessAPrivateEndpointConnection = new DiskAccessAPrivateEndpointConnection("diskAccessAPrivateEndpointConnection", DiskAccessAPrivateEndpointConnectionArgs.builder()
 *             .diskAccessName("myDiskAccess")
 *             .privateEndpointConnectionName("myPrivateEndpointConnection")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("Approving myPrivateEndpointConnection")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:DiskAccessAPrivateEndpointConnection myPrivateEndpointConnectionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskAccesses/{diskAccessName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class DiskAccessAPrivateEndpointConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.DiskAccessAPrivateEndpointConnection,
) : KotlinCustomResource(javaResource, DiskAccessAPrivateEndpointConnectionMapper) {
    /**
     * private endpoint connection name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource of private end point.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.let({ args0 ->
                privateEndpointResponseToKotlin(args0)
            })
        })

    /**
     * A collection of information about the state of the connection between DiskAccess and Virtual Network.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.let({ args0 -> privateLinkServiceConnectionStateResponseToKotlin(args0) })
        })

    /**
     * The provisioning state of the private endpoint connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * private endpoint connection type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DiskAccessAPrivateEndpointConnectionMapper :
    ResourceMapper<DiskAccessAPrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.DiskAccessAPrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): DiskAccessAPrivateEndpointConnection =
        DiskAccessAPrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.compute.DiskAccessAPrivateEndpointConnection,
        )
}

/**
 * @see [DiskAccessAPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DiskAccessAPrivateEndpointConnection].
 */
public suspend fun diskAccessAPrivateEndpointConnection(
    name: String,
    block: suspend DiskAccessAPrivateEndpointConnectionResourceBuilder.() -> Unit,
): DiskAccessAPrivateEndpointConnection {
    val builder = DiskAccessAPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DiskAccessAPrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun diskAccessAPrivateEndpointConnection(name: String): DiskAccessAPrivateEndpointConnection {
    val builder = DiskAccessAPrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
