@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.GalleryIdentifierResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SharingProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SharingStatusResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SoftDeletePolicyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.GalleryIdentifierResponse.Companion.toKotlin as galleryIdentifierResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SharingProfileResponse.Companion.toKotlin as sharingProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SharingStatusResponse.Companion.toKotlin as sharingStatusResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SoftDeletePolicyResponse.Companion.toKotlin as softDeletePolicyResponseToKotlin

/**
 * Builder for [Gallery].
 */
@PulumiTagMarker
public class GalleryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GalleryArgs = GalleryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GalleryArgsBuilder.() -> Unit) {
        val builder = GalleryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Gallery {
        val builtJavaResource = com.pulumi.azurenative.compute.Gallery(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Gallery(builtJavaResource)
    }
}

/**
 * Specifies information about the Shared Image Gallery that you want to create or update.
 * Azure REST API version: 2022-03-03. Prior API version in Azure Native 1.x: 2020-09-30.
 * Other available API versions: 2022-08-03, 2023-07-03.
 * ## Example Usage
 * ### Create a community gallery.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gallery = new AzureNative.Compute.Gallery("gallery", new()
 *     {
 *         Description = "This is the gallery description.",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SharingProfile = new AzureNative.Compute.Inputs.SharingProfileArgs
 *         {
 *             CommunityGalleryInfo = new AzureNative.Compute.Inputs.CommunityGalleryInfoArgs
 *             {
 *                 Eula = "eula",
 *                 PublicNamePrefix = "PirPublic",
 *                 PublisherContact = "pir@microsoft.com",
 *                 PublisherUri = "uri",
 *             },
 *             Permissions = AzureNative.Compute.GallerySharingPermissionTypes.Community,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGallery(ctx, "gallery", &compute.GalleryArgs{
 * 			Description:       pulumi.String("This is the gallery description."),
 * 			GalleryName:       pulumi.String("myGalleryName"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SharingProfile: &compute.SharingProfileArgs{
 * 				CommunityGalleryInfo: &compute.CommunityGalleryInfoArgs{
 * 					Eula:             pulumi.String("eula"),
 * 					PublicNamePrefix: pulumi.String("PirPublic"),
 * 					PublisherContact: pulumi.String("pir@microsoft.com"),
 * 					PublisherUri:     pulumi.String("uri"),
 * 				},
 * 				Permissions: pulumi.String(compute.GallerySharingPermissionTypesCommunity),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Gallery;
 * import com.pulumi.azurenative.compute.GalleryArgs;
 * import com.pulumi.azurenative.compute.inputs.SharingProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.CommunityGalleryInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gallery = new Gallery("gallery", GalleryArgs.builder()
 *             .description("This is the gallery description.")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sharingProfile(SharingProfileArgs.builder()
 *                 .communityGalleryInfo(CommunityGalleryInfoArgs.builder()
 *                     .eula("eula")
 *                     .publicNamePrefix("PirPublic")
 *                     .publisherContact("pir@microsoft.com")
 *                     .publisherUri("uri")
 *                     .build())
 *                 .permissions("Community")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple gallery with sharing profile.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gallery = new AzureNative.Compute.Gallery("gallery", new()
 *     {
 *         Description = "This is the gallery description.",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SharingProfile = new AzureNative.Compute.Inputs.SharingProfileArgs
 *         {
 *             Permissions = AzureNative.Compute.GallerySharingPermissionTypes.Groups,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGallery(ctx, "gallery", &compute.GalleryArgs{
 * 			Description:       pulumi.String("This is the gallery description."),
 * 			GalleryName:       pulumi.String("myGalleryName"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SharingProfile: &compute.SharingProfileArgs{
 * 				Permissions: pulumi.String(compute.GallerySharingPermissionTypesGroups),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Gallery;
 * import com.pulumi.azurenative.compute.GalleryArgs;
 * import com.pulumi.azurenative.compute.inputs.SharingProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gallery = new Gallery("gallery", GalleryArgs.builder()
 *             .description("This is the gallery description.")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sharingProfile(SharingProfileArgs.builder()
 *                 .permissions("Groups")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple gallery with soft deletion enabled.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gallery = new AzureNative.Compute.Gallery("gallery", new()
 *     {
 *         Description = "This is the gallery description.",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SoftDeletePolicy = new AzureNative.Compute.Inputs.SoftDeletePolicyArgs
 *         {
 *             IsSoftDeleteEnabled = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGallery(ctx, "gallery", &compute.GalleryArgs{
 * 			Description:       pulumi.String("This is the gallery description."),
 * 			GalleryName:       pulumi.String("myGalleryName"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SoftDeletePolicy: &compute.SoftDeletePolicyArgs{
 * 				IsSoftDeleteEnabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Gallery;
 * import com.pulumi.azurenative.compute.GalleryArgs;
 * import com.pulumi.azurenative.compute.inputs.SoftDeletePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gallery = new Gallery("gallery", GalleryArgs.builder()
 *             .description("This is the gallery description.")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .softDeletePolicy(SoftDeletePolicyArgs.builder()
 *                 .isSoftDeleteEnabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a simple gallery.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gallery = new AzureNative.Compute.Gallery("gallery", new()
 *     {
 *         Description = "This is the gallery description.",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewGallery(ctx, "gallery", &compute.GalleryArgs{
 * 			Description:       pulumi.String("This is the gallery description."),
 * 			GalleryName:       pulumi.String("myGalleryName"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Gallery;
 * import com.pulumi.azurenative.compute.GalleryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gallery = new Gallery("gallery", GalleryArgs.builder()
 *             .description("This is the gallery description.")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:Gallery myGalleryName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}
 * ```
 */
public class Gallery internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.Gallery,
) : KotlinCustomResource(javaResource, GalleryMapper) {
    /**
     * The description of this Shared Image Gallery resource. This property is updatable.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes the gallery unique name.
     */
    public val identifier: Output<GalleryIdentifierResponse>?
        get() = javaResource.identifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    galleryIdentifierResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Profile for gallery sharing to subscription or tenant
     */
    public val sharingProfile: Output<SharingProfileResponse>?
        get() = javaResource.sharingProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> sharingProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Sharing status of current gallery.
     */
    public val sharingStatus: Output<SharingStatusResponse>
        get() = javaResource.sharingStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                sharingStatusResponseToKotlin(args0)
            })
        })

    /**
     * Contains information about the soft deletion policy of the gallery.
     */
    public val softDeletePolicy: Output<SoftDeletePolicyResponse>?
        get() = javaResource.softDeletePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> softDeletePolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GalleryMapper : ResourceMapper<Gallery> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.Gallery::class == javaResource::class

    override fun map(javaResource: Resource): Gallery = Gallery(
        javaResource as
            com.pulumi.azurenative.compute.Gallery,
    )
}

/**
 * @see [Gallery].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Gallery].
 */
public suspend fun gallery(name: String, block: suspend GalleryResourceBuilder.() -> Unit): Gallery {
    val builder = GalleryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Gallery].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gallery(name: String): Gallery {
    val builder = GalleryResourceBuilder()
    builder.name(name)
    return builder.build()
}
