@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.compute.kotlin.outputs.ImageStorageProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.ImageStorageProfileResponse.Companion.toKotlin as imageStorageProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [Image].
 */
@PulumiTagMarker
public class ImageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImageArgs = ImageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImageArgsBuilder.() -> Unit) {
        val builder = ImageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Image {
        val builtJavaResource = com.pulumi.azurenative.compute.Image(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Image(builtJavaResource)
    }
}

/**
 * The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create a virtual machine image from a blob with DiskEncryptionSet resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 BlobUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *                 DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                 },
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * 			ImageName:         pulumi.String("myImage"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.ImageStorageProfileArgs{
 * 				OsDisk: &compute.ImageOSDiskArgs{
 * 					BlobUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 					DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 					},
 * 					OsState: compute.OperatingSystemStateTypesGeneralized,
 * 					OsType:  compute.OperatingSystemTypesLinux,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskEncryptionSetParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(ImageStorageProfileArgs.builder()
 *                 .osDisk(ImageOSDiskArgs.builder()
 *                     .blobUri("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd")
 *                     .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                         .build())
 *                     .osState("Generalized")
 *                     .osType("Linux")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image from a blob.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 BlobUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *             },
 *             ZoneResilient = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * 			ImageName:         pulumi.String("myImage"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.ImageStorageProfileArgs{
 * 				OsDisk: &compute.ImageOSDiskArgs{
 * 					BlobUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 					OsState: compute.OperatingSystemStateTypesGeneralized,
 * 					OsType:  compute.OperatingSystemTypesLinux,
 * 				},
 * 				ZoneResilient: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageOSDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(ImageStorageProfileArgs.builder()
 *                 .osDisk(ImageOSDiskArgs.builder()
 *                     .blobUri("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd")
 *                     .osState("Generalized")
 *                     .osType("Linux")
 *                     .build())
 *                 .zoneResilient(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image from a managed disk with DiskEncryptionSet resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                 },
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *                 Snapshot = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * 			ImageName:         pulumi.String("myImage"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.ImageStorageProfileArgs{
 * 				OsDisk: &compute.ImageOSDiskArgs{
 * 					DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 					},
 * 					OsState: compute.OperatingSystemStateTypesGeneralized,
 * 					OsType:  compute.OperatingSystemTypesLinux,
 * 					Snapshot: &compute.SubResourceArgs{
 * 						Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskEncryptionSetParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(ImageStorageProfileArgs.builder()
 *                 .osDisk(ImageOSDiskArgs.builder()
 *                     .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                         .build())
 *                     .osState("Generalized")
 *                     .osType("Linux")
 *                     .snapshot(SubResourceArgs.builder()
 *                         .id("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image from a managed disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 ManagedDisk = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk",
 *                 },
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *             },
 *             ZoneResilient = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * 			ImageName:         pulumi.String("myImage"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.ImageStorageProfileArgs{
 * 				OsDisk: &compute.ImageOSDiskArgs{
 * 					ManagedDisk: &compute.SubResourceArgs{
 * 						Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk"),
 * 					},
 * 					OsState: compute.OperatingSystemStateTypesGeneralized,
 * 					OsType:  compute.OperatingSystemTypesLinux,
 * 				},
 * 				ZoneResilient: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(ImageStorageProfileArgs.builder()
 *                 .osDisk(ImageOSDiskArgs.builder()
 *                     .managedDisk(SubResourceArgs.builder()
 *                         .id("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk")
 *                         .build())
 *                     .osState("Generalized")
 *                     .osType("Linux")
 *                     .build())
 *                 .zoneResilient(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image from a snapshot with DiskEncryptionSet resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                 },
 *                 ManagedDisk = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk",
 *                 },
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * 			ImageName:         pulumi.String("myImage"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.ImageStorageProfileArgs{
 * 				OsDisk: &compute.ImageOSDiskArgs{
 * 					DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 						Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 					},
 * 					ManagedDisk: &compute.SubResourceArgs{
 * 						Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk"),
 * 					},
 * 					OsState: compute.OperatingSystemStateTypesGeneralized,
 * 					OsType:  compute.OperatingSystemTypesLinux,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskEncryptionSetParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(ImageStorageProfileArgs.builder()
 *                 .osDisk(ImageOSDiskArgs.builder()
 *                     .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                         .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                         .build())
 *                     .managedDisk(SubResourceArgs.builder()
 *                         .id("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk")
 *                         .build())
 *                     .osState("Generalized")
 *                     .osType("Linux")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image from a snapshot.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *                 Snapshot = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot",
 *                 },
 *             },
 *             ZoneResilient = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * 			ImageName:         pulumi.String("myImage"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.ImageStorageProfileArgs{
 * 				OsDisk: &compute.ImageOSDiskArgs{
 * 					OsState: compute.OperatingSystemStateTypesGeneralized,
 * 					OsType:  compute.OperatingSystemTypesLinux,
 * 					Snapshot: &compute.SubResourceArgs{
 * 						Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot"),
 * 					},
 * 				},
 * 				ZoneResilient: pulumi.Bool(false),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(ImageStorageProfileArgs.builder()
 *                 .osDisk(ImageOSDiskArgs.builder()
 *                     .osState("Generalized")
 *                     .osType("Linux")
 *                     .snapshot(SubResourceArgs.builder()
 *                         .id("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot")
 *                         .build())
 *                     .build())
 *                 .zoneResilient(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image from an existing virtual machine.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SourceVirtualMachine = new AzureNative.Compute.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVM",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * 			ImageName:         pulumi.String("myImage"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SourceVirtualMachine: &compute.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVM"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .sourceVirtualMachine(SubResourceArgs.builder()
 *                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVM")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image that includes a data disk from a blob.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.ImageDataDiskArgs
 *                 {
 *                     BlobUri = "https://mystorageaccount.blob.core.windows.net/dataimages/dataimage.vhd",
 *                     Lun = 1,
 *                 },
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 BlobUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *             },
 *             ZoneResilient = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * 			ImageName:         pulumi.String("myImage"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.ImageStorageProfileArgs{
 * 				DataDisks: compute.ImageDataDiskArray{
 * 					&compute.ImageDataDiskArgs{
 * 						BlobUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/dataimages/dataimage.vhd"),
 * 						Lun:     pulumi.Int(1),
 * 					},
 * 				},
 * 				OsDisk: &compute.ImageOSDiskArgs{
 * 					BlobUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 					OsState: compute.OperatingSystemStateTypesGeneralized,
 * 					OsType:  compute.OperatingSystemTypesLinux,
 * 				},
 * 				ZoneResilient: pulumi.Bool(false),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageOSDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(ImageStorageProfileArgs.builder()
 *                 .dataDisks(ImageDataDiskArgs.builder()
 *                     .blobUri("https://mystorageaccount.blob.core.windows.net/dataimages/dataimage.vhd")
 *                     .lun(1)
 *                     .build())
 *                 .osDisk(ImageOSDiskArgs.builder()
 *                     .blobUri("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd")
 *                     .osState("Generalized")
 *                     .osType("Linux")
 *                     .build())
 *                 .zoneResilient(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image that includes a data disk from a managed disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.ImageDataDiskArgs
 *                 {
 *                     Lun = 1,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.SubResourceArgs
 *                     {
 *                         Id = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk2",
 *                     },
 *                 },
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 ManagedDisk = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk",
 *                 },
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *             },
 *             ZoneResilient = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * 			ImageName:         pulumi.String("myImage"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.ImageStorageProfileArgs{
 * 				DataDisks: compute.ImageDataDiskArray{
 * 					&compute.ImageDataDiskArgs{
 * 						Lun: pulumi.Int(1),
 * 						ManagedDisk: &compute.SubResourceArgs{
 * 							Id: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk2"),
 * 						},
 * 					},
 * 				},
 * 				OsDisk: &compute.ImageOSDiskArgs{
 * 					ManagedDisk: &compute.SubResourceArgs{
 * 						Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk"),
 * 					},
 * 					OsState: compute.OperatingSystemStateTypesGeneralized,
 * 					OsType:  compute.OperatingSystemTypesLinux,
 * 				},
 * 				ZoneResilient: pulumi.Bool(false),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(ImageStorageProfileArgs.builder()
 *                 .dataDisks(ImageDataDiskArgs.builder()
 *                     .lun(1)
 *                     .managedDisk(SubResourceArgs.builder()
 *                         .id("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk2")
 *                         .build())
 *                     .build())
 *                 .osDisk(ImageOSDiskArgs.builder()
 *                     .managedDisk(SubResourceArgs.builder()
 *                         .id("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/myManagedDisk")
 *                         .build())
 *                     .osState("Generalized")
 *                     .osType("Linux")
 *                     .build())
 *                 .zoneResilient(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a virtual machine image that includes a data disk from a snapshot.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.Compute.Image("image", new()
 *     {
 *         ImageName = "myImage",
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.ImageStorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.ImageDataDiskArgs
 *                 {
 *                     Lun = 1,
 *                     Snapshot = new AzureNative.Compute.Inputs.SubResourceArgs
 *                     {
 *                         Id = "subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot2",
 *                     },
 *                 },
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.ImageOSDiskArgs
 *             {
 *                 OsState = AzureNative.Compute.OperatingSystemStateTypes.Generalized,
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Linux,
 *                 Snapshot = new AzureNative.Compute.Inputs.SubResourceArgs
 *                 {
 *                     Id = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot",
 *                 },
 *             },
 *             ZoneResilient = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewImage(ctx, "image", &compute.ImageArgs{
 * 			ImageName:         pulumi.String("myImage"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.ImageStorageProfileArgs{
 * 				DataDisks: compute.ImageDataDiskArray{
 * 					&compute.ImageDataDiskArgs{
 * 						Lun: pulumi.Int(1),
 * 						Snapshot: &compute.SubResourceArgs{
 * 							Id: pulumi.String("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot2"),
 * 						},
 * 					},
 * 				},
 * 				OsDisk: &compute.ImageOSDiskArgs{
 * 					OsState: compute.OperatingSystemStateTypesGeneralized,
 * 					OsType:  compute.OperatingSystemTypesLinux,
 * 					Snapshot: &compute.SubResourceArgs{
 * 						Id: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot"),
 * 					},
 * 				},
 * 				ZoneResilient: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Image;
 * import com.pulumi.azurenative.compute.ImageArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageStorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageOSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .imageName("myImage")
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(ImageStorageProfileArgs.builder()
 *                 .dataDisks(ImageDataDiskArgs.builder()
 *                     .lun(1)
 *                     .snapshot(SubResourceArgs.builder()
 *                         .id("subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot2")
 *                         .build())
 *                     .build())
 *                 .osDisk(ImageOSDiskArgs.builder()
 *                     .osState("Generalized")
 *                     .osType("Linux")
 *                     .snapshot(SubResourceArgs.builder()
 *                         .id("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot")
 *                         .build())
 *                     .build())
 *                 .zoneResilient(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:Image myImage /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/images/{imageName}
 * ```
 */
public class Image internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.Image,
) : KotlinCustomResource(javaResource, ImageMapper) {
    /**
     * The extended location of the Image.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the HyperVGenerationType of the VirtualMachine created from the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to specify the value, if the source is managed resource like disk or snapshot, we may require the user to specify the property if we cannot deduce it from the source managed resource.
     */
    public val hyperVGeneration: Output<String>?
        get() = javaResource.hyperVGeneration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The source virtual machine from which Image is created.
     */
    public val sourceVirtualMachine: Output<SubResourceResponse>?
        get() = javaResource.sourceVirtualMachine().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the storage settings for the virtual machine disks.
     */
    public val storageProfile: Output<ImageStorageProfileResponse>?
        get() = javaResource.storageProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> imageStorageProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ImageMapper : ResourceMapper<Image> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.Image::class == javaResource::class

    override fun map(javaResource: Resource): Image = Image(
        javaResource as
            com.pulumi.azurenative.compute.Image,
    )
}

/**
 * @see [Image].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Image].
 */
public suspend fun image(name: String, block: suspend ImageResourceBuilder.() -> Unit): Image {
    val builder = ImageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Image].
 * @param name The _unique_ name of the resulting resource.
 */
public fun image(name: String): Image {
    val builder = ImageResourceBuilder()
    builder.name(name)
    return builder.build()
}
