@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse
import com.pulumi.azurenative.compute.kotlin.outputs.ProximityPlacementGroupPropertiesResponseIntent
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceWithColocationStatusResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.InstanceViewStatusResponse.Companion.toKotlin as instanceViewStatusResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.ProximityPlacementGroupPropertiesResponseIntent.Companion.toKotlin as proximityPlacementGroupPropertiesResponseIntentToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceWithColocationStatusResponse.Companion.toKotlin as subResourceWithColocationStatusResponseToKotlin

/**
 * Builder for [ProximityPlacementGroup].
 */
@PulumiTagMarker
public class ProximityPlacementGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProximityPlacementGroupArgs = ProximityPlacementGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProximityPlacementGroupArgsBuilder.() -> Unit) {
        val builder = ProximityPlacementGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProximityPlacementGroup {
        val builtJavaResource =
            com.pulumi.azurenative.compute.ProximityPlacementGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProximityPlacementGroup(builtJavaResource)
    }
}

/**
 * Specifies information about the proximity placement group.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2019-03-01, 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create or Update a proximity placement group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var proximityPlacementGroup = new AzureNative.Compute.ProximityPlacementGroup("proximityPlacementGroup", new()
 *     {
 *         Intent = new AzureNative.Compute.Inputs.ProximityPlacementGroupPropertiesIntentArgs
 *         {
 *             VmSizes = new[]
 *             {
 *                 "Basic_A0",
 *                 "Basic_A2",
 *             },
 *         },
 *         Location = "westus",
 *         ProximityPlacementGroupName = "myProximityPlacementGroup",
 *         ProximityPlacementGroupType = AzureNative.Compute.ProximityPlacementGroupType.Standard,
 *         ResourceGroupName = "myResourceGroup",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewProximityPlacementGroup(ctx, "proximityPlacementGroup", &compute.ProximityPlacementGroupArgs{
 * 			Intent: &compute.ProximityPlacementGroupPropertiesIntentArgs{
 * 				VmSizes: pulumi.StringArray{
 * 					pulumi.String("Basic_A0"),
 * 					pulumi.String("Basic_A2"),
 * 				},
 * 			},
 * 			Location:                    pulumi.String("westus"),
 * 			ProximityPlacementGroupName: pulumi.String("myProximityPlacementGroup"),
 * 			ProximityPlacementGroupType: pulumi.String(compute.ProximityPlacementGroupTypeStandard),
 * 			ResourceGroupName:           pulumi.String("myResourceGroup"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.ProximityPlacementGroup;
 * import com.pulumi.azurenative.compute.ProximityPlacementGroupArgs;
 * import com.pulumi.azurenative.compute.inputs.ProximityPlacementGroupPropertiesIntentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var proximityPlacementGroup = new ProximityPlacementGroup("proximityPlacementGroup", ProximityPlacementGroupArgs.builder()
 *             .intent(ProximityPlacementGroupPropertiesIntentArgs.builder()
 *                 .vmSizes(
 *                     "Basic_A0",
 *                     "Basic_A2")
 *                 .build())
 *             .location("westus")
 *             .proximityPlacementGroupName("myProximityPlacementGroup")
 *             .proximityPlacementGroupType("Standard")
 *             .resourceGroupName("myResourceGroup")
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:ProximityPlacementGroup myProximityPlacementGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/proximityPlacementGroups/{proximityPlacementGroupName}
 * ```
 */
public class ProximityPlacementGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.ProximityPlacementGroup,
) : KotlinCustomResource(javaResource, ProximityPlacementGroupMapper) {
    /**
     * A list of references to all availability sets in the proximity placement group.
     */
    public val availabilitySets: Output<List<SubResourceWithColocationStatusResponse>>
        get() = javaResource.availabilitySets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceWithColocationStatusResponseToKotlin(args0) })
            })
        })

    /**
     * Describes colocation status of the Proximity Placement Group.
     */
    public val colocationStatus: Output<InstanceViewStatusResponse>?
        get() = javaResource.colocationStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceViewStatusResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the user intent of the proximity placement group.
     */
    public val intent: Output<ProximityPlacementGroupPropertiesResponseIntent>?
        get() = javaResource.intent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    proximityPlacementGroupPropertiesResponseIntentToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the type of the proximity placement group. Possible values are: **Standard** : Co-locate resources within an Azure region or Availability Zone. **Ultra** : For future use.
     */
    public val proximityPlacementGroupType: Output<String>?
        get() = javaResource.proximityPlacementGroupType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * A list of references to all virtual machine scale sets in the proximity placement group.
     */
    public val virtualMachineScaleSets: Output<List<SubResourceWithColocationStatusResponse>>
        get() = javaResource.virtualMachineScaleSets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceWithColocationStatusResponseToKotlin(args0) })
            })
        })

    /**
     * A list of references to all virtual machines in the proximity placement group.
     */
    public val virtualMachines: Output<List<SubResourceWithColocationStatusResponse>>
        get() = javaResource.virtualMachines().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceWithColocationStatusResponseToKotlin(args0) })
            })
        })

    /**
     * Specifies the Availability Zone where virtual machine, virtual machine scale set or availability set associated with the  proximity placement group can be created.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object ProximityPlacementGroupMapper : ResourceMapper<ProximityPlacementGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.ProximityPlacementGroup::class == javaResource::class

    override fun map(javaResource: Resource): ProximityPlacementGroup =
        ProximityPlacementGroup(
            javaResource as
                com.pulumi.azurenative.compute.ProximityPlacementGroup,
        )
}

/**
 * @see [ProximityPlacementGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProximityPlacementGroup].
 */
public suspend fun proximityPlacementGroup(
    name: String,
    block: suspend ProximityPlacementGroupResourceBuilder.() -> Unit,
): ProximityPlacementGroup {
    val builder = ProximityPlacementGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProximityPlacementGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun proximityPlacementGroup(name: String): ProximityPlacementGroup {
    val builder = ProximityPlacementGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
