@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.AdditionalCapabilitiesResponse
import com.pulumi.azurenative.compute.kotlin.outputs.ApplicationProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.BillingProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.CapacityReservationProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.DiagnosticsProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.compute.kotlin.outputs.HardwareProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.NetworkProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.OSProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.PlanResponse
import com.pulumi.azurenative.compute.kotlin.outputs.ScheduledEventsProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SecurityProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.StorageProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineIdentityResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineInstanceViewResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.AdditionalCapabilitiesResponse.Companion.toKotlin as additionalCapabilitiesResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.ApplicationProfileResponse.Companion.toKotlin as applicationProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.BillingProfileResponse.Companion.toKotlin as billingProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.CapacityReservationProfileResponse.Companion.toKotlin as capacityReservationProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.DiagnosticsProfileResponse.Companion.toKotlin as diagnosticsProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin as hardwareProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin as networkProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.OSProfileResponse.Companion.toKotlin as oSProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.PlanResponse.Companion.toKotlin as planResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.ScheduledEventsProfileResponse.Companion.toKotlin as scheduledEventsProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SecurityProfileResponse.Companion.toKotlin as securityProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.StorageProfileResponse.Companion.toKotlin as storageProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionResponse.Companion.toKotlin as virtualMachineExtensionResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineIdentityResponse.Companion.toKotlin as virtualMachineIdentityResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineInstanceViewResponse.Companion.toKotlin as virtualMachineInstanceViewResponseToKotlin

/**
 * Builder for [VirtualMachine].
 */
@PulumiTagMarker
public class VirtualMachineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineArgs = VirtualMachineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineArgsBuilder.() -> Unit) {
        val builder = VirtualMachineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachine {
        val builtJavaResource = com.pulumi.azurenative.compute.VirtualMachine(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualMachine(builtJavaResource)
    }
}

/**
 * Describes a Virtual Machine.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create a Linux vm with a patch setting assessmentMode of ImageDefault.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2s_v3,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *             {
 *                 PatchSettings = new AzureNative.Compute.Inputs.LinuxPatchSettingsArgs
 *                 {
 *                     AssessmentMode = AzureNative.Compute.LinuxPatchAssessmentMode.ImageDefault,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "UbuntuServer",
 *                 Publisher = "Canonical",
 *                 Sku = "16.04-LTS",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2s_v3),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				LinuxConfiguration: &compute.LinuxConfigurationArgs{
 * 					PatchSettings: &compute.LinuxPatchSettingsArgs{
 * 						AssessmentMode: pulumi.String(compute.LinuxPatchAssessmentModeImageDefault),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("UbuntuServer"),
 * 					Publisher: pulumi.String("Canonical"),
 * 					Sku:       pulumi.String("16.04-LTS"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxPatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2s_v3")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .linuxConfiguration(LinuxConfigurationArgs.builder()
 *                     .patchSettings(LinuxPatchSettingsArgs.builder()
 *                         .assessmentMode("ImageDefault")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("UbuntuServer")
 *                     .publisher("Canonical")
 *                     .sku("16.04-LTS")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Linux vm with a patch setting patchMode of AutomaticByPlatform and AutomaticByPlatformSettings.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2s_v3,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *             {
 *                 PatchSettings = new AzureNative.Compute.Inputs.LinuxPatchSettingsArgs
 *                 {
 *                     AssessmentMode = AzureNative.Compute.LinuxPatchAssessmentMode.AutomaticByPlatform,
 *                     AutomaticByPlatformSettings = new AzureNative.Compute.Inputs.LinuxVMGuestPatchAutomaticByPlatformSettingsArgs
 *                     {
 *                         BypassPlatformSafetyChecksOnUserSchedule = true,
 *                         RebootSetting = AzureNative.Compute.LinuxVMGuestPatchAutomaticByPlatformRebootSetting.Never,
 *                     },
 *                     PatchMode = AzureNative.Compute.LinuxVMGuestPatchMode.AutomaticByPlatform,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "UbuntuServer",
 *                 Publisher = "Canonical",
 *                 Sku = "16.04-LTS",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2s_v3),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				LinuxConfiguration: &compute.LinuxConfigurationArgs{
 * 					PatchSettings: &compute.LinuxPatchSettingsArgs{
 * 						AssessmentMode: pulumi.String(compute.LinuxPatchAssessmentModeAutomaticByPlatform),
 * 						AutomaticByPlatformSettings: &compute.LinuxVMGuestPatchAutomaticByPlatformSettingsArgs{
 * 							BypassPlatformSafetyChecksOnUserSchedule: pulumi.Bool(true),
 * 							RebootSetting:                            pulumi.String(compute.LinuxVMGuestPatchAutomaticByPlatformRebootSettingNever),
 * 						},
 * 						PatchMode: pulumi.String(compute.LinuxVMGuestPatchModeAutomaticByPlatform),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("UbuntuServer"),
 * 					Publisher: pulumi.String("Canonical"),
 * 					Sku:       pulumi.String("16.04-LTS"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxPatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxVMGuestPatchAutomaticByPlatformSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2s_v3")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .linuxConfiguration(LinuxConfigurationArgs.builder()
 *                     .patchSettings(LinuxPatchSettingsArgs.builder()
 *                         .assessmentMode("AutomaticByPlatform")
 *                         .automaticByPlatformSettings(LinuxVMGuestPatchAutomaticByPlatformSettingsArgs.builder()
 *                             .bypassPlatformSafetyChecksOnUserSchedule(true)
 *                             .rebootSetting("Never")
 *                             .build())
 *                         .patchMode("AutomaticByPlatform")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("UbuntuServer")
 *                     .publisher("Canonical")
 *                     .sku("16.04-LTS")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Linux vm with a patch setting patchMode of ImageDefault.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2s_v3,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *             {
 *                 PatchSettings = new AzureNative.Compute.Inputs.LinuxPatchSettingsArgs
 *                 {
 *                     PatchMode = AzureNative.Compute.LinuxVMGuestPatchMode.ImageDefault,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "UbuntuServer",
 *                 Publisher = "Canonical",
 *                 Sku = "16.04-LTS",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2s_v3),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				LinuxConfiguration: &compute.LinuxConfigurationArgs{
 * 					PatchSettings: &compute.LinuxPatchSettingsArgs{
 * 						PatchMode: pulumi.String(compute.LinuxVMGuestPatchModeImageDefault),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("UbuntuServer"),
 * 					Publisher: pulumi.String("Canonical"),
 * 					Sku:       pulumi.String("16.04-LTS"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxPatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2s_v3")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .linuxConfiguration(LinuxConfigurationArgs.builder()
 *                     .patchSettings(LinuxPatchSettingsArgs.builder()
 *                         .patchMode("ImageDefault")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("UbuntuServer")
 *                     .publisher("Canonical")
 *                     .sku("16.04-LTS")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Linux vm with a patch settings patchMode and assessmentMode set to AutomaticByPlatform.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2s_v3,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *             {
 *                 PatchSettings = new AzureNative.Compute.Inputs.LinuxPatchSettingsArgs
 *                 {
 *                     AssessmentMode = AzureNative.Compute.LinuxPatchAssessmentMode.AutomaticByPlatform,
 *                     PatchMode = AzureNative.Compute.LinuxVMGuestPatchMode.AutomaticByPlatform,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "UbuntuServer",
 *                 Publisher = "Canonical",
 *                 Sku = "16.04-LTS",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2s_v3),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				LinuxConfiguration: &compute.LinuxConfigurationArgs{
 * 					PatchSettings: &compute.LinuxPatchSettingsArgs{
 * 						AssessmentMode: pulumi.String(compute.LinuxPatchAssessmentModeAutomaticByPlatform),
 * 						PatchMode:      pulumi.String(compute.LinuxVMGuestPatchModeAutomaticByPlatform),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("UbuntuServer"),
 * 					Publisher: pulumi.String("Canonical"),
 * 					Sku:       pulumi.String("16.04-LTS"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxPatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2s_v3")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .linuxConfiguration(LinuxConfigurationArgs.builder()
 *                     .patchSettings(LinuxPatchSettingsArgs.builder()
 *                         .assessmentMode("AutomaticByPlatform")
 *                         .patchMode("AutomaticByPlatform")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("UbuntuServer")
 *                     .publisher("Canonical")
 *                     .sku("16.04-LTS")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM from a community gallery image
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 CommunityGalleryImageId = "/CommunityGalleries/galleryPublicName/Images/communityGalleryImageName/Versions/communityGalleryImageVersionName",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					CommunityGalleryImageId: pulumi.String("/CommunityGalleries/galleryPublicName/Images/communityGalleryImageName/Versions/communityGalleryImageVersionName"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .communityGalleryImageId("/CommunityGalleries/galleryPublicName/Images/communityGalleryImageName/Versions/communityGalleryImageVersionName")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM from a shared gallery image
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 SharedGalleryImageId = "/SharedGalleries/sharedGalleryName/Images/sharedGalleryImageName/Versions/sharedGalleryImageVersionName",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					SharedGalleryImageId: pulumi.String("/SharedGalleries/sharedGalleryName/Images/sharedGalleryImageName/Versions/sharedGalleryImageVersionName"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .sharedGalleryImageId("/SharedGalleries/sharedGalleryName/Images/sharedGalleryImageName/Versions/sharedGalleryImageVersionName")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with Disk Controller Type
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D4_v3,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             DiskControllerType = AzureNative.Compute.DiskControllerTypes.NVMe,
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         UserData = "U29tZSBDdXN0b20gRGF0YQ==",
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D4_v3),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				DiskControllerType: pulumi.String(compute.DiskControllerTypesNVMe),
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			UserData: pulumi.String("U29tZSBDdXN0b20gRGF0YQ=="),
 * 			VmName:   pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D4_v3")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .diskControllerType("NVMe")
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .userData("U29tZSBDdXN0b20gRGF0YQ==")
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with HibernationEnabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         AdditionalCapabilities = new AzureNative.Compute.Inputs.AdditionalCapabilitiesArgs
 *         {
 *             HibernationEnabled = true,
 *         },
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2s_v3,
 *         },
 *         Location = "eastus2euap",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "{vm-name}",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2019-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "vmOSdisk",
 *             },
 *         },
 *         VmName = "{vm-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			AdditionalCapabilities: &compute.AdditionalCapabilitiesArgs{
 * 				HibernationEnabled: pulumi.Bool(true),
 * 			},
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2s_v3),
 * 			},
 * 			Location: pulumi.String("eastus2euap"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("{vm-name}"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2019-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("vmOSdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("{vm-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.AdditionalCapabilitiesArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .additionalCapabilities(AdditionalCapabilitiesArgs.builder()
 *                 .hibernationEnabled(true)
 *                 .build())
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2s_v3")
 *                 .build())
 *             .location("eastus2euap")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("{vm-name}")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2019-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("vmOSdisk")
 *                     .build())
 *                 .build())
 *             .vmName("{vm-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with Uefi Settings of secureBoot and vTPM.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2s_v3,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *         {
 *             SecurityType = AzureNative.Compute.SecurityTypes.TrustedLaunch,
 *             UefiSettings = new AzureNative.Compute.Inputs.UefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *                 VTpmEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windowsserver-gen2preview-preview",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "windows10-tvm",
 *                 Version = "18363.592.2001092016",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.StandardSSD_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2s_v3),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.SecurityProfileArgs{
 * 				SecurityType: pulumi.String(compute.SecurityTypesTrustedLaunch),
 * 				UefiSettings: &compute.UefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 					VTpmEnabled:       pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windowsserver-gen2preview-preview"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("windows10-tvm"),
 * 					Version:   pulumi.String("18363.592.2001092016"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_StandardSSD_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.UefiSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2s_v3")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(SecurityProfileArgs.builder()
 *                 .securityType("TrustedLaunch")
 *                 .uefiSettings(UefiSettingsArgs.builder()
 *                     .secureBootEnabled(true)
 *                     .vTpmEnabled(true)
 *                     .build())
 *                 .build())
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windowsserver-gen2preview-preview")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("windows10-tvm")
 *                     .version("18363.592.2001092016")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("StandardSSD_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with UserData
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "{vm-name}",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "vmOSdisk",
 *             },
 *         },
 *         UserData = "RXhhbXBsZSBVc2VyRGF0YQ==",
 *         VmName = "{vm-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("{vm-name}"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("vmOSdisk"),
 * 				},
 * 			},
 * 			UserData: pulumi.String("RXhhbXBsZSBVc2VyRGF0YQ=="),
 * 			VmName:   pulumi.String("{vm-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("{vm-name}")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("vmOSdisk")
 *                     .build())
 *                 .build())
 *             .userData("RXhhbXBsZSBVc2VyRGF0YQ==")
 *             .vmName("{vm-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with VM Size Properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D4_v3,
 *             VmSizeProperties = new AzureNative.Compute.Inputs.VMSizePropertiesArgs
 *             {
 *                 VCPUsAvailable = 1,
 *                 VCPUsPerCore = 1,
 *             },
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         UserData = "U29tZSBDdXN0b20gRGF0YQ==",
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D4_v3),
 * 				VmSizeProperties: &compute.VMSizePropertiesArgs{
 * 					VCPUsAvailable: pulumi.Int(1),
 * 					VCPUsPerCore:   pulumi.Int(1),
 * 				},
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			UserData: pulumi.String("U29tZSBDdXN0b20gRGF0YQ=="),
 * 			VmName:   pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VMSizePropertiesArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D4_v3")
 *                 .vmSizeProperties(VMSizePropertiesArgs.builder()
 *                     .vCPUsAvailable(1)
 *                     .vCPUsPerCore(1)
 *                     .build())
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .userData("U29tZSBDdXN0b20gRGF0YQ==")
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with network interface configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkApiVersion = AzureNative.Compute.NetworkApiVersion.NetworkApiVersion_2020_11_01,
 *             NetworkInterfaceConfigurations = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.VirtualMachineNetworkInterfaceConfigurationArgs
 *                 {
 *                     DeleteOption = AzureNative.Compute.DeleteOptions.Delete,
 *                     IpConfigurations = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.VirtualMachineNetworkInterfaceIPConfigurationArgs
 *                         {
 *                             Name = "{ip-config-name}",
 *                             Primary = true,
 *                             PublicIPAddressConfiguration = new AzureNative.Compute.Inputs.VirtualMachinePublicIPAddressConfigurationArgs
 *                             {
 *                                 DeleteOption = AzureNative.Compute.DeleteOptions.Detach,
 *                                 Name = "{publicIP-config-name}",
 *                                 PublicIPAllocationMethod = AzureNative.Compute.PublicIPAllocationMethod.Static,
 *                                 Sku = new AzureNative.Compute.Inputs.PublicIPAddressSkuArgs
 *                                 {
 *                                     Name = AzureNative.Compute.PublicIPAddressSkuName.Basic,
 *                                     Tier = AzureNative.Compute.PublicIPAddressSkuTier.Global,
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     Name = "{nic-config-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkApiVersion: pulumi.String(compute.NetworkApiVersion_2020_11_01),
 * 				NetworkInterfaceConfigurations: compute.VirtualMachineNetworkInterfaceConfigurationArray{
 * 					&compute.VirtualMachineNetworkInterfaceConfigurationArgs{
 * 						DeleteOption: pulumi.String(compute.DeleteOptionsDelete),
 * 						IpConfigurations: compute.VirtualMachineNetworkInterfaceIPConfigurationArray{
 * 							&compute.VirtualMachineNetworkInterfaceIPConfigurationArgs{
 * 								Name:    pulumi.String("{ip-config-name}"),
 * 								Primary: pulumi.Bool(true),
 * 								PublicIPAddressConfiguration: &compute.VirtualMachinePublicIPAddressConfigurationArgs{
 * 									DeleteOption:             pulumi.String(compute.DeleteOptionsDetach),
 * 									Name:                     pulumi.String("{publicIP-config-name}"),
 * 									PublicIPAllocationMethod: pulumi.String(compute.PublicIPAllocationMethodStatic),
 * 									Sku: &compute.PublicIPAddressSkuArgs{
 * 										Name: pulumi.String(compute.PublicIPAddressSkuNameBasic),
 * 										Tier: pulumi.String(compute.PublicIPAddressSkuTierGlobal),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						Name:    pulumi.String("{nic-config-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkApiVersion("2020-11-01")
 *                 .networkInterfaceConfigurations(VirtualMachineNetworkInterfaceConfigurationArgs.builder()
 *                     .deleteOption("Delete")
 *                     .ipConfigurations(VirtualMachineNetworkInterfaceIPConfigurationArgs.builder()
 *                         .name("{ip-config-name}")
 *                         .primary(true)
 *                         .publicIPAddressConfiguration(VirtualMachinePublicIPAddressConfigurationArgs.builder()
 *                             .deleteOption("Detach")
 *                             .name("{publicIP-config-name}")
 *                             .publicIPAllocationMethod("Static")
 *                             .sku(PublicIPAddressSkuArgs.builder()
 *                                 .name("Basic")
 *                                 .tier("Global")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .name("{nic-config-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with securityType ConfidentialVM with Customer Managed Keys
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = "Standard_DC2as_v5",
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *         {
 *             SecurityType = AzureNative.Compute.SecurityTypes.ConfidentialVM,
 *             UefiSettings = new AzureNative.Compute.Inputs.UefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *                 VTpmEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "2019-datacenter-cvm",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "windows-cvm",
 *                 Version = "17763.2183.2109130127",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     SecurityProfile = new AzureNative.Compute.Inputs.VMDiskSecurityProfileArgs
 *                     {
 *                         DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                         {
 *                             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                         },
 *                         SecurityEncryptionType = AzureNative.Compute.SecurityEncryptionTypes.DiskWithVMGuestState,
 *                     },
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.StandardSSD_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String("Standard_DC2as_v5"),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.SecurityProfileArgs{
 * 				SecurityType: pulumi.String(compute.SecurityTypesConfidentialVM),
 * 				UefiSettings: &compute.UefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 					VTpmEnabled:       pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("2019-datacenter-cvm"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("windows-cvm"),
 * 					Version:   pulumi.String("17763.2183.2109130127"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						SecurityProfile: &compute.VMDiskSecurityProfileArgs{
 * 							DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 								Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 							},
 * 							SecurityEncryptionType: pulumi.String(compute.SecurityEncryptionTypesDiskWithVMGuestState),
 * 						},
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_StandardSSD_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.UefiSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.VMDiskSecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskEncryptionSetParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DC2as_v5")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(SecurityProfileArgs.builder()
 *                 .securityType("ConfidentialVM")
 *                 .uefiSettings(UefiSettingsArgs.builder()
 *                     .secureBootEnabled(true)
 *                     .vTpmEnabled(true)
 *                     .build())
 *                 .build())
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("2019-datacenter-cvm")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("windows-cvm")
 *                     .version("17763.2183.2109130127")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .securityProfile(VMDiskSecurityProfileArgs.builder()
 *                             .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                                 .build())
 *                             .securityEncryptionType("DiskWithVMGuestState")
 *                             .build())
 *                         .storageAccountType("StandardSSD_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with securityType ConfidentialVM with Platform Managed Keys
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = "Standard_DC2as_v5",
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *         {
 *             SecurityType = AzureNative.Compute.SecurityTypes.ConfidentialVM,
 *             UefiSettings = new AzureNative.Compute.Inputs.UefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *                 VTpmEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "2019-datacenter-cvm",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "windows-cvm",
 *                 Version = "17763.2183.2109130127",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     SecurityProfile = new AzureNative.Compute.Inputs.VMDiskSecurityProfileArgs
 *                     {
 *                         SecurityEncryptionType = AzureNative.Compute.SecurityEncryptionTypes.DiskWithVMGuestState,
 *                     },
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.StandardSSD_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String("Standard_DC2as_v5"),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.SecurityProfileArgs{
 * 				SecurityType: pulumi.String(compute.SecurityTypesConfidentialVM),
 * 				UefiSettings: &compute.UefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 					VTpmEnabled:       pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("2019-datacenter-cvm"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("windows-cvm"),
 * 					Version:   pulumi.String("17763.2183.2109130127"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						SecurityProfile: &compute.VMDiskSecurityProfileArgs{
 * 							SecurityEncryptionType: pulumi.String(compute.SecurityEncryptionTypesDiskWithVMGuestState),
 * 						},
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_StandardSSD_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.UefiSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.VMDiskSecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DC2as_v5")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(SecurityProfileArgs.builder()
 *                 .securityType("ConfidentialVM")
 *                 .uefiSettings(UefiSettingsArgs.builder()
 *                     .secureBootEnabled(true)
 *                     .vTpmEnabled(true)
 *                     .build())
 *                 .build())
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("2019-datacenter-cvm")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("windows-cvm")
 *                     .version("17763.2183.2109130127")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .securityProfile(VMDiskSecurityProfileArgs.builder()
 *                             .securityEncryptionType("DiskWithVMGuestState")
 *                             .build())
 *                         .storageAccountType("StandardSSD_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Windows vm with a patch setting assessmentMode of ImageDefault.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     AssessmentMode = AzureNative.Compute.WindowsPatchAssessmentMode.ImageDefault,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				WindowsConfiguration: &compute.WindowsConfigurationArgs{
 * 					EnableAutomaticUpdates: pulumi.Bool(true),
 * 					PatchSettings: &compute.PatchSettingsArgs{
 * 						AssessmentMode: pulumi.String(compute.WindowsPatchAssessmentModeImageDefault),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.PatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .windowsConfiguration(WindowsConfigurationArgs.builder()
 *                     .enableAutomaticUpdates(true)
 *                     .patchSettings(PatchSettingsArgs.builder()
 *                         .assessmentMode("ImageDefault")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Windows vm with a patch setting patchMode of AutomaticByOS.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/nsgExistingNic",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     PatchMode = AzureNative.Compute.WindowsVMGuestPatchMode.AutomaticByOS,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/nsgExistingNic"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				WindowsConfiguration: &compute.WindowsConfigurationArgs{
 * 					EnableAutomaticUpdates: pulumi.Bool(true),
 * 					PatchSettings: &compute.PatchSettingsArgs{
 * 						PatchMode: pulumi.String(compute.WindowsVMGuestPatchModeAutomaticByOS),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.PatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/nsgExistingNic")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .windowsConfiguration(WindowsConfigurationArgs.builder()
 *                     .enableAutomaticUpdates(true)
 *                     .patchSettings(PatchSettingsArgs.builder()
 *                         .patchMode("AutomaticByOS")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Windows vm with a patch setting patchMode of AutomaticByPlatform and AutomaticByPlatformSettings.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     AssessmentMode = AzureNative.Compute.WindowsPatchAssessmentMode.AutomaticByPlatform,
 *                     AutomaticByPlatformSettings = new AzureNative.Compute.Inputs.WindowsVMGuestPatchAutomaticByPlatformSettingsArgs
 *                     {
 *                         BypassPlatformSafetyChecksOnUserSchedule = false,
 *                         RebootSetting = AzureNative.Compute.WindowsVMGuestPatchAutomaticByPlatformRebootSetting.Never,
 *                     },
 *                     PatchMode = AzureNative.Compute.WindowsVMGuestPatchMode.AutomaticByPlatform,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				WindowsConfiguration: &compute.WindowsConfigurationArgs{
 * 					EnableAutomaticUpdates: pulumi.Bool(true),
 * 					PatchSettings: &compute.PatchSettingsArgs{
 * 						AssessmentMode: pulumi.String(compute.WindowsPatchAssessmentModeAutomaticByPlatform),
 * 						AutomaticByPlatformSettings: &compute.WindowsVMGuestPatchAutomaticByPlatformSettingsArgs{
 * 							BypassPlatformSafetyChecksOnUserSchedule: pulumi.Bool(false),
 * 							RebootSetting:                            pulumi.String(compute.WindowsVMGuestPatchAutomaticByPlatformRebootSettingNever),
 * 						},
 * 						PatchMode: pulumi.String(compute.WindowsVMGuestPatchModeAutomaticByPlatform),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.PatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsVMGuestPatchAutomaticByPlatformSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .windowsConfiguration(WindowsConfigurationArgs.builder()
 *                     .enableAutomaticUpdates(true)
 *                     .patchSettings(PatchSettingsArgs.builder()
 *                         .assessmentMode("AutomaticByPlatform")
 *                         .automaticByPlatformSettings(WindowsVMGuestPatchAutomaticByPlatformSettingsArgs.builder()
 *                             .bypassPlatformSafetyChecksOnUserSchedule(false)
 *                             .rebootSetting("Never")
 *                             .build())
 *                         .patchMode("AutomaticByPlatform")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Windows vm with a patch setting patchMode of AutomaticByPlatform and enableHotpatching set to true.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     EnableHotpatching = true,
 *                     PatchMode = AzureNative.Compute.WindowsVMGuestPatchMode.AutomaticByPlatform,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				WindowsConfiguration: &compute.WindowsConfigurationArgs{
 * 					EnableAutomaticUpdates: pulumi.Bool(true),
 * 					PatchSettings: &compute.PatchSettingsArgs{
 * 						EnableHotpatching: pulumi.Bool(true),
 * 						PatchMode:         pulumi.String(compute.WindowsVMGuestPatchModeAutomaticByPlatform),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.PatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .windowsConfiguration(WindowsConfigurationArgs.builder()
 *                     .enableAutomaticUpdates(true)
 *                     .patchSettings(PatchSettingsArgs.builder()
 *                         .enableHotpatching(true)
 *                         .patchMode("AutomaticByPlatform")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Windows vm with a patch setting patchMode of Manual.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     PatchMode = AzureNative.Compute.WindowsVMGuestPatchMode.Manual,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				WindowsConfiguration: &compute.WindowsConfigurationArgs{
 * 					EnableAutomaticUpdates: pulumi.Bool(true),
 * 					PatchSettings: &compute.PatchSettingsArgs{
 * 						PatchMode: pulumi.String(compute.WindowsVMGuestPatchModeManual),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.PatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .windowsConfiguration(WindowsConfigurationArgs.builder()
 *                     .enableAutomaticUpdates(true)
 *                     .patchSettings(PatchSettingsArgs.builder()
 *                         .patchMode("Manual")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Windows vm with patch settings patchMode and assessmentMode set to AutomaticByPlatform.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     AssessmentMode = AzureNative.Compute.WindowsPatchAssessmentMode.AutomaticByPlatform,
 *                     PatchMode = AzureNative.Compute.WindowsVMGuestPatchMode.AutomaticByPlatform,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				WindowsConfiguration: &compute.WindowsConfigurationArgs{
 * 					EnableAutomaticUpdates: pulumi.Bool(true),
 * 					PatchSettings: &compute.PatchSettingsArgs{
 * 						AssessmentMode: pulumi.String(compute.WindowsPatchAssessmentModeAutomaticByPlatform),
 * 						PatchMode:      pulumi.String(compute.WindowsVMGuestPatchModeAutomaticByPlatform),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.PatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .windowsConfiguration(WindowsConfigurationArgs.builder()
 *                     .enableAutomaticUpdates(true)
 *                     .patchSettings(PatchSettingsArgs.builder()
 *                         .assessmentMode("AutomaticByPlatform")
 *                         .patchMode("AutomaticByPlatform")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a custom-image vm from an unmanaged generalized os image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 Image = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                 {
 *                     Uri = "http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/{existing-generalized-os-image-blob-name}.vhd",
 *                 },
 *                 Name = "myVMosdisk",
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *                 Vhd = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                 {
 *                     Uri = "http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk.vhd",
 *                 },
 *             },
 *         },
 *         VmName = "{vm-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					Image: &compute.VirtualHardDiskArgs{
 * 						Uri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/{existing-generalized-os-image-blob-name}.vhd"),
 * 					},
 * 					Name:   pulumi.String("myVMosdisk"),
 * 					OsType: compute.OperatingSystemTypesWindows,
 * 					Vhd: &compute.VirtualHardDiskArgs{
 * 						Uri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk.vhd"),
 * 					},
 * 				},
 * 			},
 * 			VmName: pulumi.String("{vm-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualHardDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .image(VirtualHardDiskArgs.builder()
 *                         .uri("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/{existing-generalized-os-image-blob-name}.vhd")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .osType("Windows")
 *                     .vhd(VirtualHardDiskArgs.builder()
 *                         .uri("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk.vhd")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmName("{vm-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a platform-image vm with unmanaged os and data disks.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                     DiskSizeGB = 1023,
 *                     Lun = 0,
 *                     Vhd = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                     {
 *                         Uri = "http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk0.vhd",
 *                     },
 *                 },
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                     DiskSizeGB = 1023,
 *                     Lun = 1,
 *                     Vhd = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                     {
 *                         Uri = "http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk1.vhd",
 *                     },
 *                 },
 *             },
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 Name = "myVMosdisk",
 *                 Vhd = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                 {
 *                     Uri = "http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk.vhd",
 *                 },
 *             },
 *         },
 *         VmName = "{vm-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				DataDisks: compute.DataDiskArray{
 * 					&compute.DataDiskArgs{
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 						DiskSizeGB:   pulumi.Int(1023),
 * 						Lun:          pulumi.Int(0),
 * 						Vhd: &compute.VirtualHardDiskArgs{
 * 							Uri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk0.vhd"),
 * 						},
 * 					},
 * 					&compute.DataDiskArgs{
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 						DiskSizeGB:   pulumi.Int(1023),
 * 						Lun:          pulumi.Int(1),
 * 						Vhd: &compute.VirtualHardDiskArgs{
 * 							Uri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk1.vhd"),
 * 						},
 * 					},
 * 				},
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					Name:         pulumi.String("myVMosdisk"),
 * 					Vhd: &compute.VirtualHardDiskArgs{
 * 						Uri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk.vhd"),
 * 					},
 * 				},
 * 			},
 * 			VmName: pulumi.String("{vm-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualHardDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .dataDisks(
 *                     DataDiskArgs.builder()
 *                         .createOption("Empty")
 *                         .diskSizeGB(1023)
 *                         .lun(0)
 *                         .vhd(VirtualHardDiskArgs.builder()
 *                             .uri("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk0.vhd")
 *                             .build())
 *                         .build(),
 *                     DataDiskArgs.builder()
 *                         .createOption("Empty")
 *                         .diskSizeGB(1023)
 *                         .lun(1)
 *                         .vhd(VirtualHardDiskArgs.builder()
 *                             .uri("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk1.vhd")
 *                             .build())
 *                         .build())
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .name("myVMosdisk")
 *                     .vhd(VirtualHardDiskArgs.builder()
 *                         .uri("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk.vhd")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmName("{vm-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm from a custom image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm from a generalized shared image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm from a specialized shared image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm in a Virtual Machine Scale Set with customer assigned platformFaultDomain.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         PlatformFaultDomain = 1,
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VirtualMachineScaleSet = new AzureNative.Compute.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachineScaleSets/{existing-flex-vmss-name-with-platformFaultDomainCount-greater-than-1}",
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			PlatformFaultDomain: pulumi.Int(1),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VirtualMachineScaleSet: &compute.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachineScaleSets/{existing-flex-vmss-name-with-platformFaultDomainCount-greater-than-1}"),
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .platformFaultDomain(1)
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .virtualMachineScaleSet(SubResourceArgs.builder()
 *                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachineScaleSets/{existing-flex-vmss-name-with-platformFaultDomainCount-greater-than-1}")
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm in an availability set.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         AvailabilitySet = new AzureNative.Compute.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/availabilitySets/{existing-availability-set-name}",
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			AvailabilitySet: &compute.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/availabilitySets/{existing-availability-set-name}"),
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .availabilitySet(SubResourceArgs.builder()
 *                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/availabilitySets/{existing-availability-set-name}")
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with Application Profile.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         ApplicationProfile = new AzureNative.Compute.Inputs.ApplicationProfileArgs
 *         {
 *             GalleryApplications = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.VMGalleryApplicationArgs
 *                 {
 *                     ConfigurationReference = "https://mystorageaccount.blob.core.windows.net/configurations/settings.config",
 *                     EnableAutomaticUpgrade = false,
 *                     Order = 1,
 *                     PackageReferenceId = "/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdb/resourceGroups/myresourceGroupName2/providers/Microsoft.Compute/galleries/myGallery1/applications/MyApplication1/versions/1.0",
 *                     Tags = "myTag1",
 *                     TreatFailureAsDeploymentFailure = false,
 *                 },
 *                 new AzureNative.Compute.Inputs.VMGalleryApplicationArgs
 *                 {
 *                     PackageReferenceId = "/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdg/resourceGroups/myresourceGroupName3/providers/Microsoft.Compute/galleries/myGallery2/applications/MyApplication2/versions/1.1",
 *                 },
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "{image_offer}",
 *                 Publisher = "{image_publisher}",
 *                 Sku = "{image_sku}",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			ApplicationProfile: &compute.ApplicationProfileArgs{
 * 				GalleryApplications: compute.VMGalleryApplicationArray{
 * 					&compute.VMGalleryApplicationArgs{
 * 						ConfigurationReference:          pulumi.String("https://mystorageaccount.blob.core.windows.net/configurations/settings.config"),
 * 						EnableAutomaticUpgrade:          pulumi.Bool(false),
 * 						Order:                           pulumi.Int(1),
 * 						PackageReferenceId:              pulumi.String("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdb/resourceGroups/myresourceGroupName2/providers/Microsoft.Compute/galleries/myGallery1/applications/MyApplication1/versions/1.0"),
 * 						Tags:                            pulumi.String("myTag1"),
 * 						TreatFailureAsDeploymentFailure: pulumi.Bool(false),
 * 					},
 * 					&compute.VMGalleryApplicationArgs{
 * 						PackageReferenceId: pulumi.String("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdg/resourceGroups/myresourceGroupName3/providers/Microsoft.Compute/galleries/myGallery2/applications/MyApplication2/versions/1.1"),
 * 					},
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("{image_offer}"),
 * 					Publisher: pulumi.String("{image_publisher}"),
 * 					Sku:       pulumi.String("{image_sku}"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.ApplicationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .applicationProfile(ApplicationProfileArgs.builder()
 *                 .galleryApplications(
 *                     VMGalleryApplicationArgs.builder()
 *                         .configurationReference("https://mystorageaccount.blob.core.windows.net/configurations/settings.config")
 *                         .enableAutomaticUpgrade(false)
 *                         .order(1)
 *                         .packageReferenceId("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdb/resourceGroups/myresourceGroupName2/providers/Microsoft.Compute/galleries/myGallery1/applications/MyApplication1/versions/1.0")
 *                         .tags("myTag1")
 *                         .treatFailureAsDeploymentFailure(false)
 *                         .build(),
 *                     VMGalleryApplicationArgs.builder()
 *                         .packageReferenceId("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdg/resourceGroups/myresourceGroupName3/providers/Microsoft.Compute/galleries/myGallery2/applications/MyApplication2/versions/1.1")
 *                         .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("{image_offer}")
 *                     .publisher("{image_publisher}")
 *                     .sku("{image_sku}")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with DiskEncryptionSet resource id in the os disk and data disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                     DiskSizeGB = 1023,
 *                     Lun = 0,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                     {
 *                         DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                         {
 *                             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                         },
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Attach,
 *                     DiskSizeGB = 1023,
 *                     Lun = 1,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                     {
 *                         DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                         {
 *                             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                         },
 *                         Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/{existing-managed-disk-name}",
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                     {
 *                         Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                     },
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				DataDisks: compute.DataDiskArray{
 * 					&compute.DataDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 						DiskSizeGB:   pulumi.Int(1023),
 * 						Lun:          pulumi.Int(0),
 * 						ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 							DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 								Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 							},
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 					&compute.DataDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesAttach),
 * 						DiskSizeGB:   pulumi.Int(1023),
 * 						Lun:          pulumi.Int(1),
 * 						ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 							DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 								Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 							},
 * 							Id:                 pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/{existing-managed-disk-name}"),
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 							Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 						},
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskEncryptionSetParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .dataDisks(
 *                     DataDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("Empty")
 *                         .diskSizeGB(1023)
 *                         .lun(0)
 *                         .managedDisk(ManagedDiskParametersArgs.builder()
 *                             .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                                 .build())
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build(),
 *                     DataDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("Attach")
 *                         .diskSizeGB(1023)
 *                         .lun(1)
 *                         .managedDisk(ManagedDiskParametersArgs.builder()
 *                             .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                                 .build())
 *                             .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/{existing-managed-disk-name}")
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                             .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                             .build())
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with Host Encryption using encryptionAtHost property.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_DS1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *         {
 *             EncryptionAtHost = true,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windows-data-science-vm",
 *                 Publisher = "microsoft-ads",
 *                 Sku = "windows2016",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_DS1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.SecurityProfileArgs{
 * 				EncryptionAtHost: pulumi.Bool(true),
 * 			},
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windows-data-science-vm"),
 * 					Publisher: pulumi.String("microsoft-ads"),
 * 					Sku:       pulumi.String("windows2016"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DS1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(SecurityProfileArgs.builder()
 *                 .encryptionAtHost(true)
 *                 .build())
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windows-data-science-vm")
 *                     .publisher("microsoft-ads")
 *                     .sku("windows2016")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with Scheduled Events Profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ScheduledEventsProfile = new AzureNative.Compute.Inputs.ScheduledEventsProfileArgs
 *         {
 *             OsImageNotificationProfile = new AzureNative.Compute.Inputs.OSImageNotificationProfileArgs
 *             {
 *                 Enable = true,
 *                 NotBeforeTimeout = "PT15M",
 *             },
 *             TerminateNotificationProfile = new AzureNative.Compute.Inputs.TerminateNotificationProfileArgs
 *             {
 *                 Enable = true,
 *                 NotBeforeTimeout = "PT10M",
 *             },
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ScheduledEventsProfile: &compute.ScheduledEventsProfileArgs{
 * 				OsImageNotificationProfile: &compute.OSImageNotificationProfileArgs{
 * 					Enable:           pulumi.Bool(true),
 * 					NotBeforeTimeout: pulumi.String("PT15M"),
 * 				},
 * 				TerminateNotificationProfile: &compute.TerminateNotificationProfileArgs{
 * 					Enable:           pulumi.Bool(true),
 * 					NotBeforeTimeout: pulumi.String("PT10M"),
 * 				},
 * 			},
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ScheduledEventsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSImageNotificationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.TerminateNotificationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .scheduledEventsProfile(ScheduledEventsProfileArgs.builder()
 *                 .osImageNotificationProfile(OSImageNotificationProfileArgs.builder()
 *                     .enable(true)
 *                     .notBeforeTimeout("PT15M")
 *                     .build())
 *                 .terminateNotificationProfile(TerminateNotificationProfileArgs.builder()
 *                     .enable(true)
 *                     .notBeforeTimeout("PT10M")
 *                     .build())
 *                 .build())
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with a marketplace image plan.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windows-data-science-vm",
 *                 Publisher = "microsoft-ads",
 *                 Sku = "windows2016",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windows-data-science-vm"),
 * 					Publisher: pulumi.String("microsoft-ads"),
 * 					Sku:       pulumi.String("windows2016"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windows-data-science-vm")
 *                     .publisher("microsoft-ads")
 *                     .sku("windows2016")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with an extensions time budget.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         ExtensionsTimeBudget = "PT30M",
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			ExtensionsTimeBudget: pulumi.String("PT30M"),
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .extensionsTimeBudget("PT30M")
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with boot diagnostics.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with empty data disks.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                     DiskSizeGB = 1023,
 *                     Lun = 0,
 *                 },
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                     DiskSizeGB = 1023,
 *                     Lun = 1,
 *                 },
 *             },
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				DataDisks: compute.DataDiskArray{
 * 					&compute.DataDiskArgs{
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 						DiskSizeGB:   pulumi.Int(1023),
 * 						Lun:          pulumi.Int(0),
 * 					},
 * 					&compute.DataDiskArgs{
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 						DiskSizeGB:   pulumi.Int(1023),
 * 						Lun:          pulumi.Int(1),
 * 					},
 * 				},
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .dataDisks(
 *                     DataDiskArgs.builder()
 *                         .createOption("Empty")
 *                         .diskSizeGB(1023)
 *                         .lun(0)
 *                         .build(),
 *                     DataDiskArgs.builder()
 *                         .createOption("Empty")
 *                         .diskSizeGB(1023)
 *                         .lun(1)
 *                         .build())
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with ephemeral os disk provisioning in Cache disk using placement property.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_DS1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windows-data-science-vm",
 *                 Publisher = "microsoft-ads",
 *                 Sku = "windows2016",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 DiffDiskSettings = new AzureNative.Compute.Inputs.DiffDiskSettingsArgs
 *                 {
 *                     Option = AzureNative.Compute.DiffDiskOptions.Local,
 *                     Placement = AzureNative.Compute.DiffDiskPlacement.CacheDisk,
 *                 },
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_DS1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windows-data-science-vm"),
 * 					Publisher: pulumi.String("microsoft-ads"),
 * 					Sku:       pulumi.String("windows2016"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					DiffDiskSettings: &compute.DiffDiskSettingsArgs{
 * 						Option:    pulumi.String(compute.DiffDiskOptionsLocal),
 * 						Placement: pulumi.String(compute.DiffDiskPlacementCacheDisk),
 * 					},
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DS1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windows-data-science-vm")
 *                     .publisher("microsoft-ads")
 *                     .sku("windows2016")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .diffDiskSettings(DiffDiskSettingsArgs.builder()
 *                         .option("Local")
 *                         .placement("CacheDisk")
 *                         .build())
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with ephemeral os disk provisioning in Resource disk using placement property.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_DS1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windows-data-science-vm",
 *                 Publisher = "microsoft-ads",
 *                 Sku = "windows2016",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 DiffDiskSettings = new AzureNative.Compute.Inputs.DiffDiskSettingsArgs
 *                 {
 *                     Option = AzureNative.Compute.DiffDiskOptions.Local,
 *                     Placement = AzureNative.Compute.DiffDiskPlacement.ResourceDisk,
 *                 },
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_DS1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windows-data-science-vm"),
 * 					Publisher: pulumi.String("microsoft-ads"),
 * 					Sku:       pulumi.String("windows2016"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					DiffDiskSettings: &compute.DiffDiskSettingsArgs{
 * 						Option:    pulumi.String(compute.DiffDiskOptionsLocal),
 * 						Placement: pulumi.String(compute.DiffDiskPlacementResourceDisk),
 * 					},
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DS1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windows-data-science-vm")
 *                     .publisher("microsoft-ads")
 *                     .sku("windows2016")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .diffDiskSettings(DiffDiskSettingsArgs.builder()
 *                         .option("Local")
 *                         .placement("ResourceDisk")
 *                         .build())
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with ephemeral os disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_DS1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windows-data-science-vm",
 *                 Publisher = "microsoft-ads",
 *                 Sku = "windows2016",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 DiffDiskSettings = new AzureNative.Compute.Inputs.DiffDiskSettingsArgs
 *                 {
 *                     Option = AzureNative.Compute.DiffDiskOptions.Local,
 *                 },
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_DS1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windows-data-science-vm"),
 * 					Publisher: pulumi.String("microsoft-ads"),
 * 					Sku:       pulumi.String("windows2016"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					DiffDiskSettings: &compute.DiffDiskSettingsArgs{
 * 						Option: pulumi.String(compute.DiffDiskOptionsLocal),
 * 					},
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DS1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windows-data-science-vm")
 *                     .publisher("microsoft-ads")
 *                     .sku("windows2016")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .diffDiskSettings(DiffDiskSettingsArgs.builder()
 *                         .option("Local")
 *                         .build())
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with managed boot diagnostics.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with password authentication.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with premium storage.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with ssh authentication.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *             {
 *                 DisablePasswordAuthentication = true,
 *                 Ssh = new AzureNative.Compute.Inputs.SshConfigurationArgs
 *                 {
 *                     PublicKeys = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.SshPublicKeyArgs
 *                         {
 *                             KeyData = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCeClRAk2ipUs/l5voIsDC5q9RI+YSRd1Bvd/O+axgY4WiBzG+4FwJWZm/mLLe5DoOdHQwmU2FrKXZSW4w2sYE70KeWnrFViCOX5MTVvJgPE8ClugNl8RWth/tU849DvM9sT7vFgfVSHcAS2yDRyDlueii+8nF2ym8XWAPltFVCyLHRsyBp5YPqK8JFYIa1eybKsY3hEAxRCA+/7bq8et+Gj3coOsuRmrehav7rE6N12Pb80I6ofa6SM5XNYq4Xk0iYNx7R3kdz0Jj9XgZYWjAHjJmT0gTRoOnt6upOuxK7xI/ykWrllgpXrCPu3Ymz+c+ujaqcxDopnAl2lmf69/J1",
 *                             Path = "/home/{your-username}/.ssh/authorized_keys",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "{image_offer}",
 *                 Publisher = "{image_publisher}",
 *                 Sku = "{image_sku}",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				LinuxConfiguration: &compute.LinuxConfigurationArgs{
 * 					DisablePasswordAuthentication: pulumi.Bool(true),
 * 					Ssh: &compute.SshConfigurationArgs{
 * 						PublicKeys: compute.SshPublicKeyTypeArray{
 * 							&compute.SshPublicKeyTypeArgs{
 * 								KeyData: pulumi.String("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCeClRAk2ipUs/l5voIsDC5q9RI+YSRd1Bvd/O+axgY4WiBzG+4FwJWZm/mLLe5DoOdHQwmU2FrKXZSW4w2sYE70KeWnrFViCOX5MTVvJgPE8ClugNl8RWth/tU849DvM9sT7vFgfVSHcAS2yDRyDlueii+8nF2ym8XWAPltFVCyLHRsyBp5YPqK8JFYIa1eybKsY3hEAxRCA+/7bq8et+Gj3coOsuRmrehav7rE6N12Pb80I6ofa6SM5XNYq4Xk0iYNx7R3kdz0Jj9XgZYWjAHjJmT0gTRoOnt6upOuxK7xI/ykWrllgpXrCPu3Ymz+c+ujaqcxDopnAl2lmf69/J1"),
 * 								Path:    pulumi.String("/home/{your-username}/.ssh/authorized_keys"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("{image_offer}"),
 * 					Publisher: pulumi.String("{image_publisher}"),
 * 					Sku:       pulumi.String("{image_sku}"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.SshConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .linuxConfiguration(LinuxConfigurationArgs.builder()
 *                     .disablePasswordAuthentication(true)
 *                     .ssh(SshConfigurationArgs.builder()
 *                         .publicKeys(SshPublicKeyArgs.builder()
 *                             .keyData("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCeClRAk2ipUs/l5voIsDC5q9RI+YSRd1Bvd/O+axgY4WiBzG+4FwJWZm/mLLe5DoOdHQwmU2FrKXZSW4w2sYE70KeWnrFViCOX5MTVvJgPE8ClugNl8RWth/tU849DvM9sT7vFgfVSHcAS2yDRyDlueii+8nF2ym8XWAPltFVCyLHRsyBp5YPqK8JFYIa1eybKsY3hEAxRCA+/7bq8et+Gj3coOsuRmrehav7rE6N12Pb80I6ofa6SM5XNYq4Xk0iYNx7R3kdz0Jj9XgZYWjAHjJmT0gTRoOnt6upOuxK7xI/ykWrllgpXrCPu3Ymz+c+ujaqcxDopnAl2lmf69/J1")
 *                             .path("/home/{your-username}/.ssh/authorized_keys")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("{image_offer}")
 *                     .publisher("{image_publisher}")
 *                     .sku("{image_sku}")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a VM with capacity reservation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         CapacityReservation = new AzureNative.Compute.Inputs.CapacityReservationProfileArgs
 *         {
 *             CapacityReservationGroup = new AzureNative.Compute.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/CapacityReservationGroups/{crgName}",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_DS1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windows-data-science-vm",
 *                 Publisher = "microsoft-ads",
 *                 Sku = "windows2016",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			CapacityReservation: &compute.CapacityReservationProfileArgs{
 * 				CapacityReservationGroup: &compute.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/CapacityReservationGroups/{crgName}"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_DS1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windows-data-science-vm"),
 * 					Publisher: pulumi.String("microsoft-ads"),
 * 					Sku:       pulumi.String("windows2016"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.CapacityReservationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .capacityReservation(CapacityReservationProfileArgs.builder()
 *                 .capacityReservationGroup(SubResourceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/CapacityReservationGroups/{crgName}")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DS1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windows-data-science-vm")
 *                     .publisher("microsoft-ads")
 *                     .sku("windows2016")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachine myVM /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}
 * ```
 */
public class VirtualMachine internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.VirtualMachine,
) : KotlinCustomResource(javaResource, VirtualMachineMapper) {
    /**
     * Specifies additional capabilities enabled or disabled on the virtual machine.
     */
    public val additionalCapabilities: Output<AdditionalCapabilitiesResponse>?
        get() = javaResource.additionalCapabilities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> additionalCapabilitiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the gallery applications that should be made available to the VM/VMSS.
     */
    public val applicationProfile: Output<ApplicationProfileResponse>?
        get() = javaResource.applicationProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to availability set at creation time. The availability set to which the VM is being added should be under the same resource group as the availability set resource. An existing VM cannot be added to an availability set. This property cannot exist along with a non-null properties.virtualMachineScaleSet reference.
     */
    public val availabilitySet: Output<SubResourceResponse>?
        get() = javaResource.availabilitySet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the billing related details of a Azure Spot virtual machine. Minimum api-version: 2019-03-01.
     */
    public val billingProfile: Output<BillingProfileResponse>?
        get() = javaResource.billingProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> billingProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies information about the capacity reservation that is used to allocate virtual machine. Minimum api-version: 2021-04-01.
     */
    public val capacityReservation: Output<CapacityReservationProfileResponse>?
        get() = javaResource.capacityReservation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> capacityReservationProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
     */
    public val diagnosticsProfile: Output<DiagnosticsProfileResponse>?
        get() = javaResource.diagnosticsProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> diagnosticsProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
     */
    public val evictionPolicy: Output<String>?
        get() = javaResource.evictionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The extended location of the Virtual Machine.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). Minimum api-version: 2020-06-01.
     */
    public val extensionsTimeBudget: Output<String>?
        get() = javaResource.extensionsTimeBudget().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the hardware settings for the virtual machine.
     */
    public val hardwareProfile: Output<HardwareProfileResponse>?
        get() = javaResource.hardwareProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> hardwareProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies information about the dedicated host that the virtual machine resides in. Minimum api-version: 2018-10-01.
     */
    public val host: Output<SubResourceResponse>?
        get() = javaResource.host().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies information about the dedicated host group that the virtual machine resides in. **Note:** User cannot specify both host and hostGroup properties. Minimum api-version: 2020-06-01.
     */
    public val hostGroup: Output<SubResourceResponse>?
        get() = javaResource.hostGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The identity of the virtual machine, if configured.
     */
    public val identity: Output<VirtualMachineIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The virtual machine instance view.
     */
    public val instanceView: Output<VirtualMachineInstanceViewResponse>
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualMachineInstanceViewResponseToKotlin(args0)
            })
        })

    /**
     * Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
     */
    public val licenseType: Output<String>?
        get() = javaResource.licenseType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the network interfaces of the virtual machine.
     */
    public val networkProfile: Output<NetworkProfileResponse>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the operating system settings used while creating the virtual machine. Some of the settings cannot be changed once VM is provisioned.
     */
    public val osProfile: Output<OSProfileResponse>?
        get() = javaResource.osProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    oSProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
     */
    public val plan: Output<PlanResponse>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    planResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the scale set logical fault domain into which the Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned to a fault domain that best maintains balance across available fault domains. This is applicable only if the 'virtualMachineScaleSet' property of this Virtual Machine is set. The Virtual Machine Scale Set that is referenced, must have 'platformFaultDomainCount' greater than 1. This property cannot be updated once the Virtual Machine is created. Fault domain assignment can be viewed in the Virtual Machine Instance View. Minimum api‐version: 2020‐12‐01.
     */
    public val platformFaultDomain: Output<Int>?
        get() = javaResource.platformFaultDomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the priority for the virtual machine. Minimum api-version: 2019-03-01
     */
    public val priority: Output<String>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Specifies information about the proximity placement group that the virtual machine should be assigned to. Minimum api-version: 2018-04-01.
     */
    public val proximityPlacementGroup: Output<SubResourceResponse>?
        get() = javaResource.proximityPlacementGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The virtual machine child extension resources.
     */
    public val resources: Output<List<VirtualMachineExtensionResponse>>
        get() = javaResource.resources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineExtensionResponseToKotlin(args0)
                })
            })
        })

    /**
     * Specifies Scheduled Event related configurations.
     */
    public val scheduledEventsProfile: Output<ScheduledEventsProfileResponse>?
        get() = javaResource.scheduledEventsProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> scheduledEventsProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the Security related profile settings for the virtual machine.
     */
    public val securityProfile: Output<SecurityProfileResponse>?
        get() = javaResource.securityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> securityProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the storage settings for the virtual machine disks.
     */
    public val storageProfile: Output<StorageProfileResponse>?
        get() = javaResource.storageProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the time at which the Virtual Machine resource was created. Minimum api-version: 2021-11-01.
     */
    public val timeCreated: Output<String>
        get() = javaResource.timeCreated().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. Minimum api-version: 2021-03-01.
     */
    public val userData: Output<String>?
        get() = javaResource.userData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies information about the virtual machine scale set that the virtual machine should be assigned to. Virtual machines specified in the same virtual machine scale set are allocated to different nodes to maximize availability. Currently, a VM can only be added to virtual machine scale set at creation time. An existing VM cannot be added to a virtual machine scale set. This property cannot exist along with a non-null properties.availabilitySet reference. Minimum api‐version: 2019‐03‐01.
     */
    public val virtualMachineScaleSet: Output<SubResourceResponse>?
        get() = javaResource.virtualMachineScaleSet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the VM unique ID which is a 128-bits identifier that is encoded and stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
     */
    public val vmId: Output<String>
        get() = javaResource.vmId().applyValue({ args0 -> args0 })

    /**
     * The virtual machine zones.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object VirtualMachineMapper : ResourceMapper<VirtualMachine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.VirtualMachine::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachine = VirtualMachine(
        javaResource as
            com.pulumi.azurenative.compute.VirtualMachine,
    )
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachine].
 */
public suspend fun virtualMachine(
    name: String,
    block: suspend VirtualMachineResourceBuilder.() -> Unit,
): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachine(name: String): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    return builder.build()
}
