@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.VirtualMachineArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.VirtualMachineEvictionPolicyTypes
import com.pulumi.azurenative.compute.kotlin.enums.VirtualMachinePriorityTypes
import com.pulumi.azurenative.compute.kotlin.inputs.AdditionalCapabilitiesArgs
import com.pulumi.azurenative.compute.kotlin.inputs.AdditionalCapabilitiesArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.ApplicationProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.ApplicationProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.BillingProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.BillingProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.CapacityReservationProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.CapacityReservationProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.DiagnosticsProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.DiagnosticsProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.compute.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.HardwareProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.HardwareProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.NetworkProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.NetworkProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.OSProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.OSProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.PlanArgs
import com.pulumi.azurenative.compute.kotlin.inputs.PlanArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.ScheduledEventsProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.ScheduledEventsProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SecurityProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SecurityProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.StorageProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.StorageProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineIdentityArgs
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a Virtual Machine.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-07-01, 2023-09-01, 2024-03-01.
 * ## Example Usage
 * ### Create a Linux vm with a patch setting assessmentMode of ImageDefault.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2s_v3,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *             {
 *                 PatchSettings = new AzureNative.Compute.Inputs.LinuxPatchSettingsArgs
 *                 {
 *                     AssessmentMode = AzureNative.Compute.LinuxPatchAssessmentMode.ImageDefault,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "UbuntuServer",
 *                 Publisher = "Canonical",
 *                 Sku = "16.04-LTS",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2s_v3),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				LinuxConfiguration: &compute.LinuxConfigurationArgs{
 * 					PatchSettings: &compute.LinuxPatchSettingsArgs{
 * 						AssessmentMode: pulumi.String(compute.LinuxPatchAssessmentModeImageDefault),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("UbuntuServer"),
 * 					Publisher: pulumi.String("Canonical"),
 * 					Sku:       pulumi.String("16.04-LTS"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxPatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2s_v3")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .linuxConfiguration(LinuxConfigurationArgs.builder()
 *                     .patchSettings(LinuxPatchSettingsArgs.builder()
 *                         .assessmentMode("ImageDefault")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("UbuntuServer")
 *                     .publisher("Canonical")
 *                     .sku("16.04-LTS")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Linux vm with a patch setting patchMode of AutomaticByPlatform and AutomaticByPlatformSettings.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2s_v3,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *             {
 *                 PatchSettings = new AzureNative.Compute.Inputs.LinuxPatchSettingsArgs
 *                 {
 *                     AssessmentMode = AzureNative.Compute.LinuxPatchAssessmentMode.AutomaticByPlatform,
 *                     AutomaticByPlatformSettings = new AzureNative.Compute.Inputs.LinuxVMGuestPatchAutomaticByPlatformSettingsArgs
 *                     {
 *                         BypassPlatformSafetyChecksOnUserSchedule = true,
 *                         RebootSetting = AzureNative.Compute.LinuxVMGuestPatchAutomaticByPlatformRebootSetting.Never,
 *                     },
 *                     PatchMode = AzureNative.Compute.LinuxVMGuestPatchMode.AutomaticByPlatform,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "UbuntuServer",
 *                 Publisher = "Canonical",
 *                 Sku = "16.04-LTS",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2s_v3),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				LinuxConfiguration: &compute.LinuxConfigurationArgs{
 * 					PatchSettings: &compute.LinuxPatchSettingsArgs{
 * 						AssessmentMode: pulumi.String(compute.LinuxPatchAssessmentModeAutomaticByPlatform),
 * 						AutomaticByPlatformSettings: &compute.LinuxVMGuestPatchAutomaticByPlatformSettingsArgs{
 * 							BypassPlatformSafetyChecksOnUserSchedule: pulumi.Bool(true),
 * 							RebootSetting:                            pulumi.String(compute.LinuxVMGuestPatchAutomaticByPlatformRebootSettingNever),
 * 						},
 * 						PatchMode: pulumi.String(compute.LinuxVMGuestPatchModeAutomaticByPlatform),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("UbuntuServer"),
 * 					Publisher: pulumi.String("Canonical"),
 * 					Sku:       pulumi.String("16.04-LTS"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxPatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxVMGuestPatchAutomaticByPlatformSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2s_v3")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .linuxConfiguration(LinuxConfigurationArgs.builder()
 *                     .patchSettings(LinuxPatchSettingsArgs.builder()
 *                         .assessmentMode("AutomaticByPlatform")
 *                         .automaticByPlatformSettings(LinuxVMGuestPatchAutomaticByPlatformSettingsArgs.builder()
 *                             .bypassPlatformSafetyChecksOnUserSchedule(true)
 *                             .rebootSetting("Never")
 *                             .build())
 *                         .patchMode("AutomaticByPlatform")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("UbuntuServer")
 *                     .publisher("Canonical")
 *                     .sku("16.04-LTS")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Linux vm with a patch setting patchMode of ImageDefault.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2s_v3,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *             {
 *                 PatchSettings = new AzureNative.Compute.Inputs.LinuxPatchSettingsArgs
 *                 {
 *                     PatchMode = AzureNative.Compute.LinuxVMGuestPatchMode.ImageDefault,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "UbuntuServer",
 *                 Publisher = "Canonical",
 *                 Sku = "16.04-LTS",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2s_v3),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				LinuxConfiguration: &compute.LinuxConfigurationArgs{
 * 					PatchSettings: &compute.LinuxPatchSettingsArgs{
 * 						PatchMode: pulumi.String(compute.LinuxVMGuestPatchModeImageDefault),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("UbuntuServer"),
 * 					Publisher: pulumi.String("Canonical"),
 * 					Sku:       pulumi.String("16.04-LTS"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxPatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2s_v3")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .linuxConfiguration(LinuxConfigurationArgs.builder()
 *                     .patchSettings(LinuxPatchSettingsArgs.builder()
 *                         .patchMode("ImageDefault")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("UbuntuServer")
 *                     .publisher("Canonical")
 *                     .sku("16.04-LTS")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Linux vm with a patch settings patchMode and assessmentMode set to AutomaticByPlatform.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2s_v3,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *             {
 *                 PatchSettings = new AzureNative.Compute.Inputs.LinuxPatchSettingsArgs
 *                 {
 *                     AssessmentMode = AzureNative.Compute.LinuxPatchAssessmentMode.AutomaticByPlatform,
 *                     PatchMode = AzureNative.Compute.LinuxVMGuestPatchMode.AutomaticByPlatform,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "UbuntuServer",
 *                 Publisher = "Canonical",
 *                 Sku = "16.04-LTS",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2s_v3),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				LinuxConfiguration: &compute.LinuxConfigurationArgs{
 * 					PatchSettings: &compute.LinuxPatchSettingsArgs{
 * 						AssessmentMode: pulumi.String(compute.LinuxPatchAssessmentModeAutomaticByPlatform),
 * 						PatchMode:      pulumi.String(compute.LinuxVMGuestPatchModeAutomaticByPlatform),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("UbuntuServer"),
 * 					Publisher: pulumi.String("Canonical"),
 * 					Sku:       pulumi.String("16.04-LTS"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxPatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2s_v3")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .linuxConfiguration(LinuxConfigurationArgs.builder()
 *                     .patchSettings(LinuxPatchSettingsArgs.builder()
 *                         .assessmentMode("AutomaticByPlatform")
 *                         .patchMode("AutomaticByPlatform")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("UbuntuServer")
 *                     .publisher("Canonical")
 *                     .sku("16.04-LTS")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM from a community gallery image
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 CommunityGalleryImageId = "/CommunityGalleries/galleryPublicName/Images/communityGalleryImageName/Versions/communityGalleryImageVersionName",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					CommunityGalleryImageId: pulumi.String("/CommunityGalleries/galleryPublicName/Images/communityGalleryImageName/Versions/communityGalleryImageVersionName"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .communityGalleryImageId("/CommunityGalleries/galleryPublicName/Images/communityGalleryImageName/Versions/communityGalleryImageVersionName")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM from a shared gallery image
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 SharedGalleryImageId = "/SharedGalleries/sharedGalleryName/Images/sharedGalleryImageName/Versions/sharedGalleryImageVersionName",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					SharedGalleryImageId: pulumi.String("/SharedGalleries/sharedGalleryName/Images/sharedGalleryImageName/Versions/sharedGalleryImageVersionName"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .sharedGalleryImageId("/SharedGalleries/sharedGalleryName/Images/sharedGalleryImageName/Versions/sharedGalleryImageVersionName")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with Disk Controller Type
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D4_v3,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             DiskControllerType = AzureNative.Compute.DiskControllerTypes.NVMe,
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         UserData = "U29tZSBDdXN0b20gRGF0YQ==",
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D4_v3),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				DiskControllerType: pulumi.String(compute.DiskControllerTypesNVMe),
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			UserData: pulumi.String("U29tZSBDdXN0b20gRGF0YQ=="),
 * 			VmName:   pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D4_v3")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .diskControllerType("NVMe")
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .userData("U29tZSBDdXN0b20gRGF0YQ==")
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with HibernationEnabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         AdditionalCapabilities = new AzureNative.Compute.Inputs.AdditionalCapabilitiesArgs
 *         {
 *             HibernationEnabled = true,
 *         },
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2s_v3,
 *         },
 *         Location = "eastus2euap",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "{vm-name}",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2019-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "vmOSdisk",
 *             },
 *         },
 *         VmName = "{vm-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			AdditionalCapabilities: &compute.AdditionalCapabilitiesArgs{
 * 				HibernationEnabled: pulumi.Bool(true),
 * 			},
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2s_v3),
 * 			},
 * 			Location: pulumi.String("eastus2euap"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("{vm-name}"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2019-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("vmOSdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("{vm-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.AdditionalCapabilitiesArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .additionalCapabilities(AdditionalCapabilitiesArgs.builder()
 *                 .hibernationEnabled(true)
 *                 .build())
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2s_v3")
 *                 .build())
 *             .location("eastus2euap")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("{vm-name}")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2019-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("vmOSdisk")
 *                     .build())
 *                 .build())
 *             .vmName("{vm-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with Uefi Settings of secureBoot and vTPM.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2s_v3,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *         {
 *             SecurityType = AzureNative.Compute.SecurityTypes.TrustedLaunch,
 *             UefiSettings = new AzureNative.Compute.Inputs.UefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *                 VTpmEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windowsserver-gen2preview-preview",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "windows10-tvm",
 *                 Version = "18363.592.2001092016",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.StandardSSD_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2s_v3),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.SecurityProfileArgs{
 * 				SecurityType: pulumi.String(compute.SecurityTypesTrustedLaunch),
 * 				UefiSettings: &compute.UefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 					VTpmEnabled:       pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windowsserver-gen2preview-preview"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("windows10-tvm"),
 * 					Version:   pulumi.String("18363.592.2001092016"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_StandardSSD_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.UefiSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2s_v3")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(SecurityProfileArgs.builder()
 *                 .securityType("TrustedLaunch")
 *                 .uefiSettings(UefiSettingsArgs.builder()
 *                     .secureBootEnabled(true)
 *                     .vTpmEnabled(true)
 *                     .build())
 *                 .build())
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windowsserver-gen2preview-preview")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("windows10-tvm")
 *                     .version("18363.592.2001092016")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("StandardSSD_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with UserData
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "{vm-name}",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "vmOSdisk",
 *             },
 *         },
 *         UserData = "RXhhbXBsZSBVc2VyRGF0YQ==",
 *         VmName = "{vm-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("{vm-name}"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("vmOSdisk"),
 * 				},
 * 			},
 * 			UserData: pulumi.String("RXhhbXBsZSBVc2VyRGF0YQ=="),
 * 			VmName:   pulumi.String("{vm-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("{vm-name}")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("vmOSdisk")
 *                     .build())
 *                 .build())
 *             .userData("RXhhbXBsZSBVc2VyRGF0YQ==")
 *             .vmName("{vm-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with VM Size Properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D4_v3,
 *             VmSizeProperties = new AzureNative.Compute.Inputs.VMSizePropertiesArgs
 *             {
 *                 VCPUsAvailable = 1,
 *                 VCPUsPerCore = 1,
 *             },
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         UserData = "U29tZSBDdXN0b20gRGF0YQ==",
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D4_v3),
 * 				VmSizeProperties: &compute.VMSizePropertiesArgs{
 * 					VCPUsAvailable: pulumi.Int(1),
 * 					VCPUsPerCore:   pulumi.Int(1),
 * 				},
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			UserData: pulumi.String("U29tZSBDdXN0b20gRGF0YQ=="),
 * 			VmName:   pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.VMSizePropertiesArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D4_v3")
 *                 .vmSizeProperties(VMSizePropertiesArgs.builder()
 *                     .vCPUsAvailable(1)
 *                     .vCPUsPerCore(1)
 *                     .build())
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .userData("U29tZSBDdXN0b20gRGF0YQ==")
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with network interface configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkApiVersion = AzureNative.Compute.NetworkApiVersion.NetworkApiVersion_2020_11_01,
 *             NetworkInterfaceConfigurations = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.VirtualMachineNetworkInterfaceConfigurationArgs
 *                 {
 *                     DeleteOption = AzureNative.Compute.DeleteOptions.Delete,
 *                     IpConfigurations = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.VirtualMachineNetworkInterfaceIPConfigurationArgs
 *                         {
 *                             Name = "{ip-config-name}",
 *                             Primary = true,
 *                             PublicIPAddressConfiguration = new AzureNative.Compute.Inputs.VirtualMachinePublicIPAddressConfigurationArgs
 *                             {
 *                                 DeleteOption = AzureNative.Compute.DeleteOptions.Detach,
 *                                 Name = "{publicIP-config-name}",
 *                                 PublicIPAllocationMethod = AzureNative.Compute.PublicIPAllocationMethod.Static,
 *                                 Sku = new AzureNative.Compute.Inputs.PublicIPAddressSkuArgs
 *                                 {
 *                                     Name = AzureNative.Compute.PublicIPAddressSkuName.Basic,
 *                                     Tier = AzureNative.Compute.PublicIPAddressSkuTier.Global,
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     Name = "{nic-config-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkApiVersion: pulumi.String(compute.NetworkApiVersion_2020_11_01),
 * 				NetworkInterfaceConfigurations: compute.VirtualMachineNetworkInterfaceConfigurationArray{
 * 					&compute.VirtualMachineNetworkInterfaceConfigurationArgs{
 * 						DeleteOption: pulumi.String(compute.DeleteOptionsDelete),
 * 						IpConfigurations: compute.VirtualMachineNetworkInterfaceIPConfigurationArray{
 * 							&compute.VirtualMachineNetworkInterfaceIPConfigurationArgs{
 * 								Name:    pulumi.String("{ip-config-name}"),
 * 								Primary: pulumi.Bool(true),
 * 								PublicIPAddressConfiguration: &compute.VirtualMachinePublicIPAddressConfigurationArgs{
 * 									DeleteOption:             pulumi.String(compute.DeleteOptionsDetach),
 * 									Name:                     pulumi.String("{publicIP-config-name}"),
 * 									PublicIPAllocationMethod: pulumi.String(compute.PublicIPAllocationMethodStatic),
 * 									Sku: &compute.PublicIPAddressSkuArgs{
 * 										Name: pulumi.String(compute.PublicIPAddressSkuNameBasic),
 * 										Tier: pulumi.String(compute.PublicIPAddressSkuTierGlobal),
 * 									},
 * 								},
 * 							},
 * 						},
 * 						Name:    pulumi.String("{nic-config-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkApiVersion("2020-11-01")
 *                 .networkInterfaceConfigurations(VirtualMachineNetworkInterfaceConfigurationArgs.builder()
 *                     .deleteOption("Delete")
 *                     .ipConfigurations(VirtualMachineNetworkInterfaceIPConfigurationArgs.builder()
 *                         .name("{ip-config-name}")
 *                         .primary(true)
 *                         .publicIPAddressConfiguration(VirtualMachinePublicIPAddressConfigurationArgs.builder()
 *                             .deleteOption("Detach")
 *                             .name("{publicIP-config-name}")
 *                             .publicIPAllocationMethod("Static")
 *                             .sku(PublicIPAddressSkuArgs.builder()
 *                                 .name("Basic")
 *                                 .tier("Global")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .name("{nic-config-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with securityType ConfidentialVM with Customer Managed Keys
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = "Standard_DC2as_v5",
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *         {
 *             SecurityType = AzureNative.Compute.SecurityTypes.ConfidentialVM,
 *             UefiSettings = new AzureNative.Compute.Inputs.UefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *                 VTpmEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "2019-datacenter-cvm",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "windows-cvm",
 *                 Version = "17763.2183.2109130127",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     SecurityProfile = new AzureNative.Compute.Inputs.VMDiskSecurityProfileArgs
 *                     {
 *                         DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                         {
 *                             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                         },
 *                         SecurityEncryptionType = AzureNative.Compute.SecurityEncryptionTypes.DiskWithVMGuestState,
 *                     },
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.StandardSSD_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String("Standard_DC2as_v5"),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.SecurityProfileArgs{
 * 				SecurityType: pulumi.String(compute.SecurityTypesConfidentialVM),
 * 				UefiSettings: &compute.UefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 					VTpmEnabled:       pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("2019-datacenter-cvm"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("windows-cvm"),
 * 					Version:   pulumi.String("17763.2183.2109130127"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						SecurityProfile: &compute.VMDiskSecurityProfileArgs{
 * 							DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 								Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 							},
 * 							SecurityEncryptionType: pulumi.String(compute.SecurityEncryptionTypesDiskWithVMGuestState),
 * 						},
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_StandardSSD_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.UefiSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.VMDiskSecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskEncryptionSetParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DC2as_v5")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(SecurityProfileArgs.builder()
 *                 .securityType("ConfidentialVM")
 *                 .uefiSettings(UefiSettingsArgs.builder()
 *                     .secureBootEnabled(true)
 *                     .vTpmEnabled(true)
 *                     .build())
 *                 .build())
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("2019-datacenter-cvm")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("windows-cvm")
 *                     .version("17763.2183.2109130127")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .securityProfile(VMDiskSecurityProfileArgs.builder()
 *                             .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                                 .build())
 *                             .securityEncryptionType("DiskWithVMGuestState")
 *                             .build())
 *                         .storageAccountType("StandardSSD_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a VM with securityType ConfidentialVM with Platform Managed Keys
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = "Standard_DC2as_v5",
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *         {
 *             SecurityType = AzureNative.Compute.SecurityTypes.ConfidentialVM,
 *             UefiSettings = new AzureNative.Compute.Inputs.UefiSettingsArgs
 *             {
 *                 SecureBootEnabled = true,
 *                 VTpmEnabled = true,
 *             },
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "2019-datacenter-cvm",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "windows-cvm",
 *                 Version = "17763.2183.2109130127",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     SecurityProfile = new AzureNative.Compute.Inputs.VMDiskSecurityProfileArgs
 *                     {
 *                         SecurityEncryptionType = AzureNative.Compute.SecurityEncryptionTypes.DiskWithVMGuestState,
 *                     },
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.StandardSSD_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String("Standard_DC2as_v5"),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.SecurityProfileArgs{
 * 				SecurityType: pulumi.String(compute.SecurityTypesConfidentialVM),
 * 				UefiSettings: &compute.UefiSettingsArgs{
 * 					SecureBootEnabled: pulumi.Bool(true),
 * 					VTpmEnabled:       pulumi.Bool(true),
 * 				},
 * 			},
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("2019-datacenter-cvm"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("windows-cvm"),
 * 					Version:   pulumi.String("17763.2183.2109130127"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						SecurityProfile: &compute.VMDiskSecurityProfileArgs{
 * 							SecurityEncryptionType: pulumi.String(compute.SecurityEncryptionTypesDiskWithVMGuestState),
 * 						},
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_StandardSSD_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.UefiSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.VMDiskSecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DC2as_v5")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(SecurityProfileArgs.builder()
 *                 .securityType("ConfidentialVM")
 *                 .uefiSettings(UefiSettingsArgs.builder()
 *                     .secureBootEnabled(true)
 *                     .vTpmEnabled(true)
 *                     .build())
 *                 .build())
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("2019-datacenter-cvm")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("windows-cvm")
 *                     .version("17763.2183.2109130127")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .securityProfile(VMDiskSecurityProfileArgs.builder()
 *                             .securityEncryptionType("DiskWithVMGuestState")
 *                             .build())
 *                         .storageAccountType("StandardSSD_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Windows vm with a patch setting assessmentMode of ImageDefault.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     AssessmentMode = AzureNative.Compute.WindowsPatchAssessmentMode.ImageDefault,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				WindowsConfiguration: &compute.WindowsConfigurationArgs{
 * 					EnableAutomaticUpdates: pulumi.Bool(true),
 * 					PatchSettings: &compute.PatchSettingsArgs{
 * 						AssessmentMode: pulumi.String(compute.WindowsPatchAssessmentModeImageDefault),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.PatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .windowsConfiguration(WindowsConfigurationArgs.builder()
 *                     .enableAutomaticUpdates(true)
 *                     .patchSettings(PatchSettingsArgs.builder()
 *                         .assessmentMode("ImageDefault")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Windows vm with a patch setting patchMode of AutomaticByOS.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/nsgExistingNic",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     PatchMode = AzureNative.Compute.WindowsVMGuestPatchMode.AutomaticByOS,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/nsgExistingNic"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				WindowsConfiguration: &compute.WindowsConfigurationArgs{
 * 					EnableAutomaticUpdates: pulumi.Bool(true),
 * 					PatchSettings: &compute.PatchSettingsArgs{
 * 						PatchMode: pulumi.String(compute.WindowsVMGuestPatchModeAutomaticByOS),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.PatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/nsgExistingNic")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .windowsConfiguration(WindowsConfigurationArgs.builder()
 *                     .enableAutomaticUpdates(true)
 *                     .patchSettings(PatchSettingsArgs.builder()
 *                         .patchMode("AutomaticByOS")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Windows vm with a patch setting patchMode of AutomaticByPlatform and AutomaticByPlatformSettings.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     AssessmentMode = AzureNative.Compute.WindowsPatchAssessmentMode.AutomaticByPlatform,
 *                     AutomaticByPlatformSettings = new AzureNative.Compute.Inputs.WindowsVMGuestPatchAutomaticByPlatformSettingsArgs
 *                     {
 *                         BypassPlatformSafetyChecksOnUserSchedule = false,
 *                         RebootSetting = AzureNative.Compute.WindowsVMGuestPatchAutomaticByPlatformRebootSetting.Never,
 *                     },
 *                     PatchMode = AzureNative.Compute.WindowsVMGuestPatchMode.AutomaticByPlatform,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				WindowsConfiguration: &compute.WindowsConfigurationArgs{
 * 					EnableAutomaticUpdates: pulumi.Bool(true),
 * 					PatchSettings: &compute.PatchSettingsArgs{
 * 						AssessmentMode: pulumi.String(compute.WindowsPatchAssessmentModeAutomaticByPlatform),
 * 						AutomaticByPlatformSettings: &compute.WindowsVMGuestPatchAutomaticByPlatformSettingsArgs{
 * 							BypassPlatformSafetyChecksOnUserSchedule: pulumi.Bool(false),
 * 							RebootSetting:                            pulumi.String(compute.WindowsVMGuestPatchAutomaticByPlatformRebootSettingNever),
 * 						},
 * 						PatchMode: pulumi.String(compute.WindowsVMGuestPatchModeAutomaticByPlatform),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.PatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsVMGuestPatchAutomaticByPlatformSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .windowsConfiguration(WindowsConfigurationArgs.builder()
 *                     .enableAutomaticUpdates(true)
 *                     .patchSettings(PatchSettingsArgs.builder()
 *                         .assessmentMode("AutomaticByPlatform")
 *                         .automaticByPlatformSettings(WindowsVMGuestPatchAutomaticByPlatformSettingsArgs.builder()
 *                             .bypassPlatformSafetyChecksOnUserSchedule(false)
 *                             .rebootSetting("Never")
 *                             .build())
 *                         .patchMode("AutomaticByPlatform")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Windows vm with a patch setting patchMode of AutomaticByPlatform and enableHotpatching set to true.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     EnableHotpatching = true,
 *                     PatchMode = AzureNative.Compute.WindowsVMGuestPatchMode.AutomaticByPlatform,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				WindowsConfiguration: &compute.WindowsConfigurationArgs{
 * 					EnableAutomaticUpdates: pulumi.Bool(true),
 * 					PatchSettings: &compute.PatchSettingsArgs{
 * 						EnableHotpatching: pulumi.Bool(true),
 * 						PatchMode:         pulumi.String(compute.WindowsVMGuestPatchModeAutomaticByPlatform),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.PatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .windowsConfiguration(WindowsConfigurationArgs.builder()
 *                     .enableAutomaticUpdates(true)
 *                     .patchSettings(PatchSettingsArgs.builder()
 *                         .enableHotpatching(true)
 *                         .patchMode("AutomaticByPlatform")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Windows vm with a patch setting patchMode of Manual.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     PatchMode = AzureNative.Compute.WindowsVMGuestPatchMode.Manual,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				WindowsConfiguration: &compute.WindowsConfigurationArgs{
 * 					EnableAutomaticUpdates: pulumi.Bool(true),
 * 					PatchSettings: &compute.PatchSettingsArgs{
 * 						PatchMode: pulumi.String(compute.WindowsVMGuestPatchModeManual),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.PatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .windowsConfiguration(WindowsConfigurationArgs.builder()
 *                     .enableAutomaticUpdates(true)
 *                     .patchSettings(PatchSettingsArgs.builder()
 *                         .patchMode("Manual")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a Windows vm with patch settings patchMode and assessmentMode set to AutomaticByPlatform.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             WindowsConfiguration = new AzureNative.Compute.Inputs.WindowsConfigurationArgs
 *             {
 *                 EnableAutomaticUpdates = true,
 *                 PatchSettings = new AzureNative.Compute.Inputs.PatchSettingsArgs
 *                 {
 *                     AssessmentMode = AzureNative.Compute.WindowsPatchAssessmentMode.AutomaticByPlatform,
 *                     PatchMode = AzureNative.Compute.WindowsVMGuestPatchMode.AutomaticByPlatform,
 *                 },
 *                 ProvisionVMAgent = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				WindowsConfiguration: &compute.WindowsConfigurationArgs{
 * 					EnableAutomaticUpdates: pulumi.Bool(true),
 * 					PatchSettings: &compute.PatchSettingsArgs{
 * 						AssessmentMode: pulumi.String(compute.WindowsPatchAssessmentModeAutomaticByPlatform),
 * 						PatchMode:      pulumi.String(compute.WindowsVMGuestPatchModeAutomaticByPlatform),
 * 					},
 * 					ProvisionVMAgent: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.WindowsConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.PatchSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .windowsConfiguration(WindowsConfigurationArgs.builder()
 *                     .enableAutomaticUpdates(true)
 *                     .patchSettings(PatchSettingsArgs.builder()
 *                         .assessmentMode("AutomaticByPlatform")
 *                         .patchMode("AutomaticByPlatform")
 *                         .build())
 *                     .provisionVMAgent(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a custom-image vm from an unmanaged generalized os image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 Image = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                 {
 *                     Uri = "http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/{existing-generalized-os-image-blob-name}.vhd",
 *                 },
 *                 Name = "myVMosdisk",
 *                 OsType = AzureNative.Compute.OperatingSystemTypes.Windows,
 *                 Vhd = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                 {
 *                     Uri = "http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk.vhd",
 *                 },
 *             },
 *         },
 *         VmName = "{vm-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					Image: &compute.VirtualHardDiskArgs{
 * 						Uri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/{existing-generalized-os-image-blob-name}.vhd"),
 * 					},
 * 					Name:   pulumi.String("myVMosdisk"),
 * 					OsType: compute.OperatingSystemTypesWindows,
 * 					Vhd: &compute.VirtualHardDiskArgs{
 * 						Uri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk.vhd"),
 * 					},
 * 				},
 * 			},
 * 			VmName: pulumi.String("{vm-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualHardDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .image(VirtualHardDiskArgs.builder()
 *                         .uri("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/{existing-generalized-os-image-blob-name}.vhd")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .osType("Windows")
 *                     .vhd(VirtualHardDiskArgs.builder()
 *                         .uri("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk.vhd")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmName("{vm-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a platform-image vm with unmanaged os and data disks.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                     DiskSizeGB = 1023,
 *                     Lun = 0,
 *                     Vhd = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                     {
 *                         Uri = "http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk0.vhd",
 *                     },
 *                 },
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                     DiskSizeGB = 1023,
 *                     Lun = 1,
 *                     Vhd = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                     {
 *                         Uri = "http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk1.vhd",
 *                     },
 *                 },
 *             },
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 Name = "myVMosdisk",
 *                 Vhd = new AzureNative.Compute.Inputs.VirtualHardDiskArgs
 *                 {
 *                     Uri = "http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk.vhd",
 *                 },
 *             },
 *         },
 *         VmName = "{vm-name}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				DataDisks: compute.DataDiskArray{
 * 					&compute.DataDiskArgs{
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 						DiskSizeGB:   pulumi.Int(1023),
 * 						Lun:          pulumi.Int(0),
 * 						Vhd: &compute.VirtualHardDiskArgs{
 * 							Uri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk0.vhd"),
 * 						},
 * 					},
 * 					&compute.DataDiskArgs{
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 						DiskSizeGB:   pulumi.Int(1023),
 * 						Lun:          pulumi.Int(1),
 * 						Vhd: &compute.VirtualHardDiskArgs{
 * 							Uri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk1.vhd"),
 * 						},
 * 					},
 * 				},
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					Name:         pulumi.String("myVMosdisk"),
 * 					Vhd: &compute.VirtualHardDiskArgs{
 * 						Uri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk.vhd"),
 * 					},
 * 				},
 * 			},
 * 			VmName: pulumi.String("{vm-name}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.VirtualHardDiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .dataDisks(
 *                     DataDiskArgs.builder()
 *                         .createOption("Empty")
 *                         .diskSizeGB(1023)
 *                         .lun(0)
 *                         .vhd(VirtualHardDiskArgs.builder()
 *                             .uri("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk0.vhd")
 *                             .build())
 *                         .build(),
 *                     DataDiskArgs.builder()
 *                         .createOption("Empty")
 *                         .diskSizeGB(1023)
 *                         .lun(1)
 *                         .vhd(VirtualHardDiskArgs.builder()
 *                             .uri("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk1.vhd")
 *                             .build())
 *                         .build())
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .name("myVMosdisk")
 *                     .vhd(VirtualHardDiskArgs.builder()
 *                         .uri("http://{existing-storage-account-name}.blob.core.windows.net/{existing-container-name}/myDisk.vhd")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .vmName("{vm-name}")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm from a custom image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm from a generalized shared image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm from a specialized shared image.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/mySharedGallery/images/mySharedImage")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm in a Virtual Machine Scale Set with customer assigned platformFaultDomain.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         PlatformFaultDomain = 1,
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VirtualMachineScaleSet = new AzureNative.Compute.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachineScaleSets/{existing-flex-vmss-name-with-platformFaultDomainCount-greater-than-1}",
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			PlatformFaultDomain: pulumi.Int(1),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VirtualMachineScaleSet: &compute.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachineScaleSets/{existing-flex-vmss-name-with-platformFaultDomainCount-greater-than-1}"),
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .platformFaultDomain(1)
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .virtualMachineScaleSet(SubResourceArgs.builder()
 *                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachineScaleSets/{existing-flex-vmss-name-with-platformFaultDomainCount-greater-than-1}")
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm in an availability set.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         AvailabilitySet = new AzureNative.Compute.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/availabilitySets/{existing-availability-set-name}",
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			AvailabilitySet: &compute.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/availabilitySets/{existing-availability-set-name}"),
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .availabilitySet(SubResourceArgs.builder()
 *                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/availabilitySets/{existing-availability-set-name}")
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with Application Profile.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         ApplicationProfile = new AzureNative.Compute.Inputs.ApplicationProfileArgs
 *         {
 *             GalleryApplications = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.VMGalleryApplicationArgs
 *                 {
 *                     ConfigurationReference = "https://mystorageaccount.blob.core.windows.net/configurations/settings.config",
 *                     EnableAutomaticUpgrade = false,
 *                     Order = 1,
 *                     PackageReferenceId = "/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdb/resourceGroups/myresourceGroupName2/providers/Microsoft.Compute/galleries/myGallery1/applications/MyApplication1/versions/1.0",
 *                     Tags = "myTag1",
 *                     TreatFailureAsDeploymentFailure = false,
 *                 },
 *                 new AzureNative.Compute.Inputs.VMGalleryApplicationArgs
 *                 {
 *                     PackageReferenceId = "/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdg/resourceGroups/myresourceGroupName3/providers/Microsoft.Compute/galleries/myGallery2/applications/MyApplication2/versions/1.1",
 *                 },
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "{image_offer}",
 *                 Publisher = "{image_publisher}",
 *                 Sku = "{image_sku}",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			ApplicationProfile: &compute.ApplicationProfileArgs{
 * 				GalleryApplications: compute.VMGalleryApplicationArray{
 * 					&compute.VMGalleryApplicationArgs{
 * 						ConfigurationReference:          pulumi.String("https://mystorageaccount.blob.core.windows.net/configurations/settings.config"),
 * 						EnableAutomaticUpgrade:          pulumi.Bool(false),
 * 						Order:                           pulumi.Int(1),
 * 						PackageReferenceId:              pulumi.String("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdb/resourceGroups/myresourceGroupName2/providers/Microsoft.Compute/galleries/myGallery1/applications/MyApplication1/versions/1.0"),
 * 						Tags:                            pulumi.String("myTag1"),
 * 						TreatFailureAsDeploymentFailure: pulumi.Bool(false),
 * 					},
 * 					&compute.VMGalleryApplicationArgs{
 * 						PackageReferenceId: pulumi.String("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdg/resourceGroups/myresourceGroupName3/providers/Microsoft.Compute/galleries/myGallery2/applications/MyApplication2/versions/1.1"),
 * 					},
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("{image_offer}"),
 * 					Publisher: pulumi.String("{image_publisher}"),
 * 					Sku:       pulumi.String("{image_sku}"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.ApplicationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .applicationProfile(ApplicationProfileArgs.builder()
 *                 .galleryApplications(
 *                     VMGalleryApplicationArgs.builder()
 *                         .configurationReference("https://mystorageaccount.blob.core.windows.net/configurations/settings.config")
 *                         .enableAutomaticUpgrade(false)
 *                         .order(1)
 *                         .packageReferenceId("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdb/resourceGroups/myresourceGroupName2/providers/Microsoft.Compute/galleries/myGallery1/applications/MyApplication1/versions/1.0")
 *                         .tags("myTag1")
 *                         .treatFailureAsDeploymentFailure(false)
 *                         .build(),
 *                     VMGalleryApplicationArgs.builder()
 *                         .packageReferenceId("/subscriptions/32c17a9e-aa7b-4ba5-a45b-e324116b6fdg/resourceGroups/myresourceGroupName3/providers/Microsoft.Compute/galleries/myGallery2/applications/MyApplication2/versions/1.1")
 *                         .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("{image_offer}")
 *                     .publisher("{image_publisher}")
 *                     .sku("{image_sku}")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with DiskEncryptionSet resource id in the os disk and data disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                     DiskSizeGB = 1023,
 *                     Lun = 0,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                     {
 *                         DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                         {
 *                             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                         },
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Attach,
 *                     DiskSizeGB = 1023,
 *                     Lun = 1,
 *                     ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                     {
 *                         DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                         {
 *                             Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                         },
 *                         Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/{existing-managed-disk-name}",
 *                         StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                     },
 *                 },
 *             },
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     DiskEncryptionSet = new AzureNative.Compute.Inputs.DiskEncryptionSetParametersArgs
 *                     {
 *                         Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}",
 *                     },
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				DataDisks: compute.DataDiskArray{
 * 					&compute.DataDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 						DiskSizeGB:   pulumi.Int(1023),
 * 						Lun:          pulumi.Int(0),
 * 						ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 							DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 								Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 							},
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 					&compute.DataDiskArgs{
 * 						Caching:      compute.CachingTypesReadWrite,
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesAttach),
 * 						DiskSizeGB:   pulumi.Int(1023),
 * 						Lun:          pulumi.Int(1),
 * 						ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 							DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 								Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 							},
 * 							Id:                 pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/{existing-managed-disk-name}"),
 * 							StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 						},
 * 					},
 * 				},
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						DiskEncryptionSet: &compute.DiskEncryptionSetParametersArgs{
 * 							Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}"),
 * 						},
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import com.pulumi.azurenative.compute.inputs.DiskEncryptionSetParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .dataDisks(
 *                     DataDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("Empty")
 *                         .diskSizeGB(1023)
 *                         .lun(0)
 *                         .managedDisk(ManagedDiskParametersArgs.builder()
 *                             .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                                 .build())
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build(),
 *                     DataDiskArgs.builder()
 *                         .caching("ReadWrite")
 *                         .createOption("Attach")
 *                         .diskSizeGB(1023)
 *                         .lun(1)
 *                         .managedDisk(ManagedDiskParametersArgs.builder()
 *                             .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                                 .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                                 .build())
 *                             .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/{existing-managed-disk-name}")
 *                             .storageAccountType("Standard_LRS")
 *                             .build())
 *                         .build())
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/images/{existing-custom-image-name}")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .diskEncryptionSet(DiskEncryptionSetParametersArgs.builder()
 *                             .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/diskEncryptionSets/{existing-diskEncryptionSet-name}")
 *                             .build())
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with Host Encryption using encryptionAtHost property.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_DS1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SecurityProfile = new AzureNative.Compute.Inputs.SecurityProfileArgs
 *         {
 *             EncryptionAtHost = true,
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windows-data-science-vm",
 *                 Publisher = "microsoft-ads",
 *                 Sku = "windows2016",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_DS1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SecurityProfile: &compute.SecurityProfileArgs{
 * 				EncryptionAtHost: pulumi.Bool(true),
 * 			},
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windows-data-science-vm"),
 * 					Publisher: pulumi.String("microsoft-ads"),
 * 					Sku:       pulumi.String("windows2016"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DS1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .securityProfile(SecurityProfileArgs.builder()
 *                 .encryptionAtHost(true)
 *                 .build())
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windows-data-science-vm")
 *                     .publisher("microsoft-ads")
 *                     .sku("windows2016")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with Scheduled Events Profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ScheduledEventsProfile = new AzureNative.Compute.Inputs.ScheduledEventsProfileArgs
 *         {
 *             OsImageNotificationProfile = new AzureNative.Compute.Inputs.OSImageNotificationProfileArgs
 *             {
 *                 Enable = true,
 *                 NotBeforeTimeout = "PT15M",
 *             },
 *             TerminateNotificationProfile = new AzureNative.Compute.Inputs.TerminateNotificationProfileArgs
 *             {
 *                 Enable = true,
 *                 NotBeforeTimeout = "PT10M",
 *             },
 *         },
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ScheduledEventsProfile: &compute.ScheduledEventsProfileArgs{
 * 				OsImageNotificationProfile: &compute.OSImageNotificationProfileArgs{
 * 					Enable:           pulumi.Bool(true),
 * 					NotBeforeTimeout: pulumi.String("PT15M"),
 * 				},
 * 				TerminateNotificationProfile: &compute.TerminateNotificationProfileArgs{
 * 					Enable:           pulumi.Bool(true),
 * 					NotBeforeTimeout: pulumi.String("PT10M"),
 * 				},
 * 			},
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ScheduledEventsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSImageNotificationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.TerminateNotificationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .scheduledEventsProfile(ScheduledEventsProfileArgs.builder()
 *                 .osImageNotificationProfile(OSImageNotificationProfileArgs.builder()
 *                     .enable(true)
 *                     .notBeforeTimeout("PT15M")
 *                     .build())
 *                 .terminateNotificationProfile(TerminateNotificationProfileArgs.builder()
 *                     .enable(true)
 *                     .notBeforeTimeout("PT10M")
 *                     .build())
 *                 .build())
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with a marketplace image plan.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windows-data-science-vm",
 *                 Publisher = "microsoft-ads",
 *                 Sku = "windows2016",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windows-data-science-vm"),
 * 					Publisher: pulumi.String("microsoft-ads"),
 * 					Sku:       pulumi.String("windows2016"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windows-data-science-vm")
 *                     .publisher("microsoft-ads")
 *                     .sku("windows2016")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with an extensions time budget.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         ExtensionsTimeBudget = "PT30M",
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			ExtensionsTimeBudget: pulumi.String("PT30M"),
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .extensionsTimeBudget("PT30M")
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with boot diagnostics.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *                 StorageUri = "http://{existing-storage-account-name}.blob.core.windows.net",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled:    pulumi.Bool(true),
 * 					StorageUri: pulumi.String("http://{existing-storage-account-name}.blob.core.windows.net"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .storageUri("http://{existing-storage-account-name}.blob.core.windows.net")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with empty data disks.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D2_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             DataDisks = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                     DiskSizeGB = 1023,
 *                     Lun = 0,
 *                 },
 *                 new AzureNative.Compute.Inputs.DataDiskArgs
 *                 {
 *                     CreateOption = AzureNative.Compute.DiskCreateOptionTypes.Empty,
 *                     DiskSizeGB = 1023,
 *                     Lun = 1,
 *                 },
 *             },
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D2_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				DataDisks: compute.DataDiskArray{
 * 					&compute.DataDiskArgs{
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 						DiskSizeGB:   pulumi.Int(1023),
 * 						Lun:          pulumi.Int(0),
 * 					},
 * 					&compute.DataDiskArgs{
 * 						CreateOption: pulumi.String(compute.DiskCreateOptionTypesEmpty),
 * 						DiskSizeGB:   pulumi.Int(1023),
 * 						Lun:          pulumi.Int(1),
 * 					},
 * 				},
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D2_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .dataDisks(
 *                     DataDiskArgs.builder()
 *                         .createOption("Empty")
 *                         .diskSizeGB(1023)
 *                         .lun(0)
 *                         .build(),
 *                     DataDiskArgs.builder()
 *                         .createOption("Empty")
 *                         .diskSizeGB(1023)
 *                         .lun(1)
 *                         .build())
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with ephemeral os disk provisioning in Cache disk using placement property.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_DS1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windows-data-science-vm",
 *                 Publisher = "microsoft-ads",
 *                 Sku = "windows2016",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 DiffDiskSettings = new AzureNative.Compute.Inputs.DiffDiskSettingsArgs
 *                 {
 *                     Option = AzureNative.Compute.DiffDiskOptions.Local,
 *                     Placement = AzureNative.Compute.DiffDiskPlacement.CacheDisk,
 *                 },
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_DS1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windows-data-science-vm"),
 * 					Publisher: pulumi.String("microsoft-ads"),
 * 					Sku:       pulumi.String("windows2016"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					DiffDiskSettings: &compute.DiffDiskSettingsArgs{
 * 						Option:    pulumi.String(compute.DiffDiskOptionsLocal),
 * 						Placement: pulumi.String(compute.DiffDiskPlacementCacheDisk),
 * 					},
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DS1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windows-data-science-vm")
 *                     .publisher("microsoft-ads")
 *                     .sku("windows2016")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .diffDiskSettings(DiffDiskSettingsArgs.builder()
 *                         .option("Local")
 *                         .placement("CacheDisk")
 *                         .build())
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with ephemeral os disk provisioning in Resource disk using placement property.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_DS1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windows-data-science-vm",
 *                 Publisher = "microsoft-ads",
 *                 Sku = "windows2016",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 DiffDiskSettings = new AzureNative.Compute.Inputs.DiffDiskSettingsArgs
 *                 {
 *                     Option = AzureNative.Compute.DiffDiskOptions.Local,
 *                     Placement = AzureNative.Compute.DiffDiskPlacement.ResourceDisk,
 *                 },
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_DS1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windows-data-science-vm"),
 * 					Publisher: pulumi.String("microsoft-ads"),
 * 					Sku:       pulumi.String("windows2016"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					DiffDiskSettings: &compute.DiffDiskSettingsArgs{
 * 						Option:    pulumi.String(compute.DiffDiskOptionsLocal),
 * 						Placement: pulumi.String(compute.DiffDiskPlacementResourceDisk),
 * 					},
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DS1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windows-data-science-vm")
 *                     .publisher("microsoft-ads")
 *                     .sku("windows2016")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .diffDiskSettings(DiffDiskSettingsArgs.builder()
 *                         .option("Local")
 *                         .placement("ResourceDisk")
 *                         .build())
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with ephemeral os disk.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_DS1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windows-data-science-vm",
 *                 Publisher = "microsoft-ads",
 *                 Sku = "windows2016",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 DiffDiskSettings = new AzureNative.Compute.Inputs.DiffDiskSettingsArgs
 *                 {
 *                     Option = AzureNative.Compute.DiffDiskOptions.Local,
 *                 },
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_DS1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windows-data-science-vm"),
 * 					Publisher: pulumi.String("microsoft-ads"),
 * 					Sku:       pulumi.String("windows2016"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					DiffDiskSettings: &compute.DiffDiskSettingsArgs{
 * 						Option: pulumi.String(compute.DiffDiskOptionsLocal),
 * 					},
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.DiffDiskSettingsArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DS1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windows-data-science-vm")
 *                     .publisher("microsoft-ads")
 *                     .sku("windows2016")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .diffDiskSettings(DiffDiskSettingsArgs.builder()
 *                         .option("Local")
 *                         .build())
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with managed boot diagnostics.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         DiagnosticsProfile = new AzureNative.Compute.Inputs.DiagnosticsProfileArgs
 *         {
 *             BootDiagnostics = new AzureNative.Compute.Inputs.BootDiagnosticsArgs
 *             {
 *                 Enabled = true,
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			DiagnosticsProfile: &compute.DiagnosticsProfileArgs{
 * 				BootDiagnostics: &compute.BootDiagnosticsArgs{
 * 					Enabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.DiagnosticsProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.BootDiagnosticsArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .diagnosticsProfile(DiagnosticsProfileArgs.builder()
 *                 .bootDiagnostics(BootDiagnosticsArgs.builder()
 *                     .enabled(true)
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with password authentication.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with premium storage.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "WindowsServer",
 *                 Publisher = "MicrosoftWindowsServer",
 *                 Sku = "2016-Datacenter",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Premium_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("WindowsServer"),
 * 					Publisher: pulumi.String("MicrosoftWindowsServer"),
 * 					Sku:       pulumi.String("2016-Datacenter"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Premium_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("WindowsServer")
 *                     .publisher("MicrosoftWindowsServer")
 *                     .sku("2016-Datacenter")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Premium_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a vm with ssh authentication.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_D1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *             LinuxConfiguration = new AzureNative.Compute.Inputs.LinuxConfigurationArgs
 *             {
 *                 DisablePasswordAuthentication = true,
 *                 Ssh = new AzureNative.Compute.Inputs.SshConfigurationArgs
 *                 {
 *                     PublicKeys = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.SshPublicKeyArgs
 *                         {
 *                             KeyData = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCeClRAk2ipUs/l5voIsDC5q9RI+YSRd1Bvd/O+axgY4WiBzG+4FwJWZm/mLLe5DoOdHQwmU2FrKXZSW4w2sYE70KeWnrFViCOX5MTVvJgPE8ClugNl8RWth/tU849DvM9sT7vFgfVSHcAS2yDRyDlueii+8nF2ym8XWAPltFVCyLHRsyBp5YPqK8JFYIa1eybKsY3hEAxRCA+/7bq8et+Gj3coOsuRmrehav7rE6N12Pb80I6ofa6SM5XNYq4Xk0iYNx7R3kdz0Jj9XgZYWjAHjJmT0gTRoOnt6upOuxK7xI/ykWrllgpXrCPu3Ymz+c+ujaqcxDopnAl2lmf69/J1",
 *                             Path = "/home/{your-username}/.ssh/authorized_keys",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "{image_offer}",
 *                 Publisher = "{image_publisher}",
 *                 Sku = "{image_sku}",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadWrite,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_D1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 				LinuxConfiguration: &compute.LinuxConfigurationArgs{
 * 					DisablePasswordAuthentication: pulumi.Bool(true),
 * 					Ssh: &compute.SshConfigurationArgs{
 * 						PublicKeys: compute.SshPublicKeyTypeArray{
 * 							&compute.SshPublicKeyTypeArgs{
 * 								KeyData: pulumi.String("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCeClRAk2ipUs/l5voIsDC5q9RI+YSRd1Bvd/O+axgY4WiBzG+4FwJWZm/mLLe5DoOdHQwmU2FrKXZSW4w2sYE70KeWnrFViCOX5MTVvJgPE8ClugNl8RWth/tU849DvM9sT7vFgfVSHcAS2yDRyDlueii+8nF2ym8XWAPltFVCyLHRsyBp5YPqK8JFYIa1eybKsY3hEAxRCA+/7bq8et+Gj3coOsuRmrehav7rE6N12Pb80I6ofa6SM5XNYq4Xk0iYNx7R3kdz0Jj9XgZYWjAHjJmT0gTRoOnt6upOuxK7xI/ykWrllgpXrCPu3Ymz+c+ujaqcxDopnAl2lmf69/J1"),
 * 								Path:    pulumi.String("/home/{your-username}/.ssh/authorized_keys"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("{image_offer}"),
 * 					Publisher: pulumi.String("{image_publisher}"),
 * 					Sku:       pulumi.String("{image_sku}"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadWrite,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.LinuxConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.SshConfigurationArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_D1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .linuxConfiguration(LinuxConfigurationArgs.builder()
 *                     .disablePasswordAuthentication(true)
 *                     .ssh(SshConfigurationArgs.builder()
 *                         .publicKeys(SshPublicKeyArgs.builder()
 *                             .keyData("ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCeClRAk2ipUs/l5voIsDC5q9RI+YSRd1Bvd/O+axgY4WiBzG+4FwJWZm/mLLe5DoOdHQwmU2FrKXZSW4w2sYE70KeWnrFViCOX5MTVvJgPE8ClugNl8RWth/tU849DvM9sT7vFgfVSHcAS2yDRyDlueii+8nF2ym8XWAPltFVCyLHRsyBp5YPqK8JFYIa1eybKsY3hEAxRCA+/7bq8et+Gj3coOsuRmrehav7rE6N12Pb80I6ofa6SM5XNYq4Xk0iYNx7R3kdz0Jj9XgZYWjAHjJmT0gTRoOnt6upOuxK7xI/ykWrllgpXrCPu3Ymz+c+ujaqcxDopnAl2lmf69/J1")
 *                             .path("/home/{your-username}/.ssh/authorized_keys")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("{image_offer}")
 *                     .publisher("{image_publisher}")
 *                     .sku("{image_sku}")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadWrite")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a VM with capacity reservation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.Compute.VirtualMachine("virtualMachine", new()
 *     {
 *         CapacityReservation = new AzureNative.Compute.Inputs.CapacityReservationProfileArgs
 *         {
 *             CapacityReservationGroup = new AzureNative.Compute.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/CapacityReservationGroups/{crgName}",
 *             },
 *         },
 *         HardwareProfile = new AzureNative.Compute.Inputs.HardwareProfileArgs
 *         {
 *             VmSize = AzureNative.Compute.VirtualMachineSizeTypes.Standard_DS1_v2,
 *         },
 *         Location = "westus",
 *         NetworkProfile = new AzureNative.Compute.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.NetworkInterfaceReferenceArgs
 *                 {
 *                     Id = "/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}",
 *                     Primary = true,
 *                 },
 *             },
 *         },
 *         OsProfile = new AzureNative.Compute.Inputs.OSProfileArgs
 *         {
 *             AdminPassword = "{your-password}",
 *             AdminUsername = "{your-username}",
 *             ComputerName = "myVM",
 *         },
 *         Plan = new AzureNative.Compute.Inputs.PlanArgs
 *         {
 *             Name = "windows2016",
 *             Product = "windows-data-science-vm",
 *             Publisher = "microsoft-ads",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StorageProfile = new AzureNative.Compute.Inputs.StorageProfileArgs
 *         {
 *             ImageReference = new AzureNative.Compute.Inputs.ImageReferenceArgs
 *             {
 *                 Offer = "windows-data-science-vm",
 *                 Publisher = "microsoft-ads",
 *                 Sku = "windows2016",
 *                 Version = "latest",
 *             },
 *             OsDisk = new AzureNative.Compute.Inputs.OSDiskArgs
 *             {
 *                 Caching = AzureNative.Compute.CachingTypes.ReadOnly,
 *                 CreateOption = AzureNative.Compute.DiskCreateOptionTypes.FromImage,
 *                 ManagedDisk = new AzureNative.Compute.Inputs.ManagedDiskParametersArgs
 *                 {
 *                     StorageAccountType = AzureNative.Compute.StorageAccountTypes.Standard_LRS,
 *                 },
 *                 Name = "myVMosdisk",
 *             },
 *         },
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachine(ctx, "virtualMachine", &compute.VirtualMachineArgs{
 * 			CapacityReservation: &compute.CapacityReservationProfileArgs{
 * 				CapacityReservationGroup: &compute.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/CapacityReservationGroups/{crgName}"),
 * 				},
 * 			},
 * 			HardwareProfile: &compute.HardwareProfileArgs{
 * 				VmSize: pulumi.String(compute.VirtualMachineSizeTypes_Standard_DS1_v2),
 * 			},
 * 			Location: pulumi.String("westus"),
 * 			NetworkProfile: &compute.NetworkProfileArgs{
 * 				NetworkInterfaces: compute.NetworkInterfaceReferenceArray{
 * 					&compute.NetworkInterfaceReferenceArgs{
 * 						Id:      pulumi.String("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}"),
 * 						Primary: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			OsProfile: &compute.OSProfileArgs{
 * 				AdminPassword: pulumi.String("{your-password}"),
 * 				AdminUsername: pulumi.String("{your-username}"),
 * 				ComputerName:  pulumi.String("myVM"),
 * 			},
 * 			Plan: &compute.PlanArgs{
 * 				Name:      pulumi.String("windows2016"),
 * 				Product:   pulumi.String("windows-data-science-vm"),
 * 				Publisher: pulumi.String("microsoft-ads"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StorageProfile: &compute.StorageProfileArgs{
 * 				ImageReference: &compute.ImageReferenceArgs{
 * 					Offer:     pulumi.String("windows-data-science-vm"),
 * 					Publisher: pulumi.String("microsoft-ads"),
 * 					Sku:       pulumi.String("windows2016"),
 * 					Version:   pulumi.String("latest"),
 * 				},
 * 				OsDisk: &compute.OSDiskArgs{
 * 					Caching:      compute.CachingTypesReadOnly,
 * 					CreateOption: pulumi.String(compute.DiskCreateOptionTypesFromImage),
 * 					ManagedDisk: &compute.ManagedDiskParametersArgs{
 * 						StorageAccountType: pulumi.String(compute.StorageAccountTypes_Standard_LRS),
 * 					},
 * 					Name: pulumi.String("myVMosdisk"),
 * 				},
 * 			},
 * 			VmName: pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachine;
 * import com.pulumi.azurenative.compute.VirtualMachineArgs;
 * import com.pulumi.azurenative.compute.inputs.CapacityReservationProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.SubResourceArgs;
 * import com.pulumi.azurenative.compute.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.OSProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.PlanArgs;
 * import com.pulumi.azurenative.compute.inputs.StorageProfileArgs;
 * import com.pulumi.azurenative.compute.inputs.ImageReferenceArgs;
 * import com.pulumi.azurenative.compute.inputs.OSDiskArgs;
 * import com.pulumi.azurenative.compute.inputs.ManagedDiskParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .capacityReservation(CapacityReservationProfileArgs.builder()
 *                 .capacityReservationGroup(SubResourceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/CapacityReservationGroups/{crgName}")
 *                     .build())
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .vmSize("Standard_DS1_v2")
 *                 .build())
 *             .location("westus")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceReferenceArgs.builder()
 *                     .id("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Network/networkInterfaces/{existing-nic-name}")
 *                     .primary(true)
 *                     .build())
 *                 .build())
 *             .osProfile(OSProfileArgs.builder()
 *                 .adminPassword("{your-password}")
 *                 .adminUsername("{your-username}")
 *                 .computerName("myVM")
 *                 .build())
 *             .plan(PlanArgs.builder()
 *                 .name("windows2016")
 *                 .product("windows-data-science-vm")
 *                 .publisher("microsoft-ads")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .storageProfile(StorageProfileArgs.builder()
 *                 .imageReference(ImageReferenceArgs.builder()
 *                     .offer("windows-data-science-vm")
 *                     .publisher("microsoft-ads")
 *                     .sku("windows2016")
 *                     .version("latest")
 *                     .build())
 *                 .osDisk(OSDiskArgs.builder()
 *                     .caching("ReadOnly")
 *                     .createOption("FromImage")
 *                     .managedDisk(ManagedDiskParametersArgs.builder()
 *                         .storageAccountType("Standard_LRS")
 *                         .build())
 *                     .name("myVMosdisk")
 *                     .build())
 *                 .build())
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachine myVM /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}
 * ```
 * @property additionalCapabilities Specifies additional capabilities enabled or disabled on the virtual machine.
 * @property applicationProfile Specifies the gallery applications that should be made available to the VM/VMSS.
 * @property availabilitySet Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to availability set at creation time. The availability set to which the VM is being added should be under the same resource group as the availability set resource. An existing VM cannot be added to an availability set. This property cannot exist along with a non-null properties.virtualMachineScaleSet reference.
 * @property billingProfile Specifies the billing related details of a Azure Spot virtual machine. Minimum api-version: 2019-03-01.
 * @property capacityReservation Specifies information about the capacity reservation that is used to allocate virtual machine. Minimum api-version: 2021-04-01.
 * @property diagnosticsProfile Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
 * @property evictionPolicy Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
 * @property extendedLocation The extended location of the Virtual Machine.
 * @property extensionsTimeBudget Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). Minimum api-version: 2020-06-01.
 * @property hardwareProfile Specifies the hardware settings for the virtual machine.
 * @property host Specifies information about the dedicated host that the virtual machine resides in. Minimum api-version: 2018-10-01.
 * @property hostGroup Specifies information about the dedicated host group that the virtual machine resides in. **Note:** User cannot specify both host and hostGroup properties. Minimum api-version: 2020-06-01.
 * @property identity The identity of the virtual machine, if configured.
 * @property licenseType Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
 * @property location Resource location
 * @property networkProfile Specifies the network interfaces of the virtual machine.
 * @property osProfile Specifies the operating system settings used while creating the virtual machine. Some of the settings cannot be changed once VM is provisioned.
 * @property plan Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
 * @property platformFaultDomain Specifies the scale set logical fault domain into which the Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned to a fault domain that best maintains balance across available fault domains. This is applicable only if the 'virtualMachineScaleSet' property of this Virtual Machine is set. The Virtual Machine Scale Set that is referenced, must have 'platformFaultDomainCount' greater than 1. This property cannot be updated once the Virtual Machine is created. Fault domain assignment can be viewed in the Virtual Machine Instance View. Minimum api‐version: 2020‐12‐01.
 * @property priority Specifies the priority for the virtual machine. Minimum api-version: 2019-03-01
 * @property proximityPlacementGroup Specifies information about the proximity placement group that the virtual machine should be assigned to. Minimum api-version: 2018-04-01.
 * @property resourceGroupName The name of the resource group.
 * @property scheduledEventsProfile Specifies Scheduled Event related configurations.
 * @property securityProfile Specifies the Security related profile settings for the virtual machine.
 * @property storageProfile Specifies the storage settings for the virtual machine disks.
 * @property tags Resource tags
 * @property userData UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. Minimum api-version: 2021-03-01.
 * @property virtualMachineScaleSet Specifies information about the virtual machine scale set that the virtual machine should be assigned to. Virtual machines specified in the same virtual machine scale set are allocated to different nodes to maximize availability. Currently, a VM can only be added to virtual machine scale set at creation time. An existing VM cannot be added to a virtual machine scale set. This property cannot exist along with a non-null properties.availabilitySet reference. Minimum api‐version: 2019‐03‐01.
 * @property vmName The name of the virtual machine.
 * @property zones The virtual machine zones.
 */
public data class VirtualMachineArgs(
    public val additionalCapabilities: Output<AdditionalCapabilitiesArgs>? = null,
    public val applicationProfile: Output<ApplicationProfileArgs>? = null,
    public val availabilitySet: Output<SubResourceArgs>? = null,
    public val billingProfile: Output<BillingProfileArgs>? = null,
    public val capacityReservation: Output<CapacityReservationProfileArgs>? = null,
    public val diagnosticsProfile: Output<DiagnosticsProfileArgs>? = null,
    public val evictionPolicy: Output<Either<String, VirtualMachineEvictionPolicyTypes>>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val extensionsTimeBudget: Output<String>? = null,
    public val hardwareProfile: Output<HardwareProfileArgs>? = null,
    public val host: Output<SubResourceArgs>? = null,
    public val hostGroup: Output<SubResourceArgs>? = null,
    public val identity: Output<VirtualMachineIdentityArgs>? = null,
    public val licenseType: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val osProfile: Output<OSProfileArgs>? = null,
    public val plan: Output<PlanArgs>? = null,
    public val platformFaultDomain: Output<Int>? = null,
    public val priority: Output<Either<String, VirtualMachinePriorityTypes>>? = null,
    public val proximityPlacementGroup: Output<SubResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scheduledEventsProfile: Output<ScheduledEventsProfileArgs>? = null,
    public val securityProfile: Output<SecurityProfileArgs>? = null,
    public val storageProfile: Output<StorageProfileArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userData: Output<String>? = null,
    public val virtualMachineScaleSet: Output<SubResourceArgs>? = null,
    public val vmName: Output<String>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.VirtualMachineArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.VirtualMachineArgs =
        com.pulumi.azurenative.compute.VirtualMachineArgs.builder()
            .additionalCapabilities(
                additionalCapabilities?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .applicationProfile(
                applicationProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .availabilitySet(availabilitySet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .billingProfile(billingProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .capacityReservation(
                capacityReservation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .diagnosticsProfile(
                diagnosticsProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .evictionPolicy(
                evictionPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extensionsTimeBudget(extensionsTimeBudget?.applyValue({ args0 -> args0 }))
            .hardwareProfile(hardwareProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .host(host?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hostGroup(hostGroup?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .licenseType(licenseType?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .platformFaultDomain(platformFaultDomain?.applyValue({ args0 -> args0 }))
            .priority(
                priority?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .proximityPlacementGroup(
                proximityPlacementGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scheduledEventsProfile(
                scheduledEventsProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userData(userData?.applyValue({ args0 -> args0 }))
            .virtualMachineScaleSet(
                virtualMachineScaleSet?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vmName(vmName?.applyValue({ args0 -> args0 }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [VirtualMachineArgs].
 */
@PulumiTagMarker
public class VirtualMachineArgsBuilder internal constructor() {
    private var additionalCapabilities: Output<AdditionalCapabilitiesArgs>? = null

    private var applicationProfile: Output<ApplicationProfileArgs>? = null

    private var availabilitySet: Output<SubResourceArgs>? = null

    private var billingProfile: Output<BillingProfileArgs>? = null

    private var capacityReservation: Output<CapacityReservationProfileArgs>? = null

    private var diagnosticsProfile: Output<DiagnosticsProfileArgs>? = null

    private var evictionPolicy: Output<Either<String, VirtualMachineEvictionPolicyTypes>>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var extensionsTimeBudget: Output<String>? = null

    private var hardwareProfile: Output<HardwareProfileArgs>? = null

    private var host: Output<SubResourceArgs>? = null

    private var hostGroup: Output<SubResourceArgs>? = null

    private var identity: Output<VirtualMachineIdentityArgs>? = null

    private var licenseType: Output<String>? = null

    private var location: Output<String>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var osProfile: Output<OSProfileArgs>? = null

    private var plan: Output<PlanArgs>? = null

    private var platformFaultDomain: Output<Int>? = null

    private var priority: Output<Either<String, VirtualMachinePriorityTypes>>? = null

    private var proximityPlacementGroup: Output<SubResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var scheduledEventsProfile: Output<ScheduledEventsProfileArgs>? = null

    private var securityProfile: Output<SecurityProfileArgs>? = null

    private var storageProfile: Output<StorageProfileArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userData: Output<String>? = null

    private var virtualMachineScaleSet: Output<SubResourceArgs>? = null

    private var vmName: Output<String>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Specifies additional capabilities enabled or disabled on the virtual machine.
     */
    @JvmName("yjpnavgbftunbldb")
    public suspend fun additionalCapabilities(`value`: Output<AdditionalCapabilitiesArgs>) {
        this.additionalCapabilities = value
    }

    /**
     * @param value Specifies the gallery applications that should be made available to the VM/VMSS.
     */
    @JvmName("mdlswjjkajyghqfs")
    public suspend fun applicationProfile(`value`: Output<ApplicationProfileArgs>) {
        this.applicationProfile = value
    }

    /**
     * @param value Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to availability set at creation time. The availability set to which the VM is being added should be under the same resource group as the availability set resource. An existing VM cannot be added to an availability set. This property cannot exist along with a non-null properties.virtualMachineScaleSet reference.
     */
    @JvmName("mtjjyyqxeknueckw")
    public suspend fun availabilitySet(`value`: Output<SubResourceArgs>) {
        this.availabilitySet = value
    }

    /**
     * @param value Specifies the billing related details of a Azure Spot virtual machine. Minimum api-version: 2019-03-01.
     */
    @JvmName("vtgcwjgssyupvvww")
    public suspend fun billingProfile(`value`: Output<BillingProfileArgs>) {
        this.billingProfile = value
    }

    /**
     * @param value Specifies information about the capacity reservation that is used to allocate virtual machine. Minimum api-version: 2021-04-01.
     */
    @JvmName("ofkjftykykfbusrg")
    public suspend fun capacityReservation(`value`: Output<CapacityReservationProfileArgs>) {
        this.capacityReservation = value
    }

    /**
     * @param value Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
     */
    @JvmName("owocfyhsvokmwfwu")
    public suspend fun diagnosticsProfile(`value`: Output<DiagnosticsProfileArgs>) {
        this.diagnosticsProfile = value
    }

    /**
     * @param value Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
     */
    @JvmName("olakysediexvdovq")
    public suspend fun evictionPolicy(`value`: Output<Either<String, VirtualMachineEvictionPolicyTypes>>) {
        this.evictionPolicy = value
    }

    /**
     * @param value The extended location of the Virtual Machine.
     */
    @JvmName("hdgnqlfyvcqrgsrk")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). Minimum api-version: 2020-06-01.
     */
    @JvmName("siqqpqxvcsmhiqiy")
    public suspend fun extensionsTimeBudget(`value`: Output<String>) {
        this.extensionsTimeBudget = value
    }

    /**
     * @param value Specifies the hardware settings for the virtual machine.
     */
    @JvmName("ntufltckytblxukc")
    public suspend fun hardwareProfile(`value`: Output<HardwareProfileArgs>) {
        this.hardwareProfile = value
    }

    /**
     * @param value Specifies information about the dedicated host that the virtual machine resides in. Minimum api-version: 2018-10-01.
     */
    @JvmName("mjchjtynlgotqost")
    public suspend fun host(`value`: Output<SubResourceArgs>) {
        this.host = value
    }

    /**
     * @param value Specifies information about the dedicated host group that the virtual machine resides in. **Note:** User cannot specify both host and hostGroup properties. Minimum api-version: 2020-06-01.
     */
    @JvmName("btcfaiuqkbclmimt")
    public suspend fun hostGroup(`value`: Output<SubResourceArgs>) {
        this.hostGroup = value
    }

    /**
     * @param value The identity of the virtual machine, if configured.
     */
    @JvmName("gcsaynjwsoepnfkx")
    public suspend fun identity(`value`: Output<VirtualMachineIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
     */
    @JvmName("xutfyycunlrjaioj")
    public suspend fun licenseType(`value`: Output<String>) {
        this.licenseType = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("xqyjdkqlytnungoo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Specifies the network interfaces of the virtual machine.
     */
    @JvmName("ypbraaxeseiquutk")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value Specifies the operating system settings used while creating the virtual machine. Some of the settings cannot be changed once VM is provisioned.
     */
    @JvmName("rnutymcqrgapcgqw")
    public suspend fun osProfile(`value`: Output<OSProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
     */
    @JvmName("gshedbcqkqqvqjel")
    public suspend fun plan(`value`: Output<PlanArgs>) {
        this.plan = value
    }

    /**
     * @param value Specifies the scale set logical fault domain into which the Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned to a fault domain that best maintains balance across available fault domains. This is applicable only if the 'virtualMachineScaleSet' property of this Virtual Machine is set. The Virtual Machine Scale Set that is referenced, must have 'platformFaultDomainCount' greater than 1. This property cannot be updated once the Virtual Machine is created. Fault domain assignment can be viewed in the Virtual Machine Instance View. Minimum api‐version: 2020‐12‐01.
     */
    @JvmName("asrodpmhjkrhcsgu")
    public suspend fun platformFaultDomain(`value`: Output<Int>) {
        this.platformFaultDomain = value
    }

    /**
     * @param value Specifies the priority for the virtual machine. Minimum api-version: 2019-03-01
     */
    @JvmName("cssubvgcnnyyayml")
    public suspend fun priority(`value`: Output<Either<String, VirtualMachinePriorityTypes>>) {
        this.priority = value
    }

    /**
     * @param value Specifies information about the proximity placement group that the virtual machine should be assigned to. Minimum api-version: 2018-04-01.
     */
    @JvmName("dhpaxtnhbwqdvvut")
    public suspend fun proximityPlacementGroup(`value`: Output<SubResourceArgs>) {
        this.proximityPlacementGroup = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("njrxtgdrdsdmwlna")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies Scheduled Event related configurations.
     */
    @JvmName("cmcdbuypuycaakdx")
    public suspend fun scheduledEventsProfile(`value`: Output<ScheduledEventsProfileArgs>) {
        this.scheduledEventsProfile = value
    }

    /**
     * @param value Specifies the Security related profile settings for the virtual machine.
     */
    @JvmName("mtyqnfdcnpcbchyf")
    public suspend fun securityProfile(`value`: Output<SecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("lgwlqmmcnaxnslqd")
    public suspend fun storageProfile(`value`: Output<StorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("jmtjmbpxgqjvcvpx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. Minimum api-version: 2021-03-01.
     */
    @JvmName("snjpmdartpqsjgri")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value Specifies information about the virtual machine scale set that the virtual machine should be assigned to. Virtual machines specified in the same virtual machine scale set are allocated to different nodes to maximize availability. Currently, a VM can only be added to virtual machine scale set at creation time. An existing VM cannot be added to a virtual machine scale set. This property cannot exist along with a non-null properties.availabilitySet reference. Minimum api‐version: 2019‐03‐01.
     */
    @JvmName("hixgpoibhtdbmsgd")
    public suspend fun virtualMachineScaleSet(`value`: Output<SubResourceArgs>) {
        this.virtualMachineScaleSet = value
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("xtlismjybonvgbfy")
    public suspend fun vmName(`value`: Output<String>) {
        this.vmName = value
    }

    /**
     * @param value The virtual machine zones.
     */
    @JvmName("cwbeqmsgvqnbflka")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("mltxetceefslysvj")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values The virtual machine zones.
     */
    @JvmName("rhkeoxqcdmkfqtqt")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Specifies additional capabilities enabled or disabled on the virtual machine.
     */
    @JvmName("siodipsporxhnlau")
    public suspend fun additionalCapabilities(`value`: AdditionalCapabilitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalCapabilities = mapped
    }

    /**
     * @param argument Specifies additional capabilities enabled or disabled on the virtual machine.
     */
    @JvmName("whpqnjhtpbpxurak")
    public suspend fun additionalCapabilities(argument: suspend AdditionalCapabilitiesArgsBuilder.() -> Unit) {
        val toBeMapped = AdditionalCapabilitiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.additionalCapabilities = mapped
    }

    /**
     * @param value Specifies the gallery applications that should be made available to the VM/VMSS.
     */
    @JvmName("pmvhkearebjrwnhi")
    public suspend fun applicationProfile(`value`: ApplicationProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationProfile = mapped
    }

    /**
     * @param argument Specifies the gallery applications that should be made available to the VM/VMSS.
     */
    @JvmName("viqbbsoxtnmdcfpy")
    public suspend fun applicationProfile(argument: suspend ApplicationProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.applicationProfile = mapped
    }

    /**
     * @param value Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to availability set at creation time. The availability set to which the VM is being added should be under the same resource group as the availability set resource. An existing VM cannot be added to an availability set. This property cannot exist along with a non-null properties.virtualMachineScaleSet reference.
     */
    @JvmName("wliqmabtkgleuxyh")
    public suspend fun availabilitySet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilitySet = mapped
    }

    /**
     * @param argument Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to availability set at creation time. The availability set to which the VM is being added should be under the same resource group as the availability set resource. An existing VM cannot be added to an availability set. This property cannot exist along with a non-null properties.virtualMachineScaleSet reference.
     */
    @JvmName("lyypbvweqrlslaly")
    public suspend fun availabilitySet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.availabilitySet = mapped
    }

    /**
     * @param value Specifies the billing related details of a Azure Spot virtual machine. Minimum api-version: 2019-03-01.
     */
    @JvmName("pvkbkuaixbuyrcoe")
    public suspend fun billingProfile(`value`: BillingProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingProfile = mapped
    }

    /**
     * @param argument Specifies the billing related details of a Azure Spot virtual machine. Minimum api-version: 2019-03-01.
     */
    @JvmName("apnsgqkkqysnrxko")
    public suspend fun billingProfile(argument: suspend BillingProfileArgsBuilder.() -> Unit) {
        val toBeMapped = BillingProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.billingProfile = mapped
    }

    /**
     * @param value Specifies information about the capacity reservation that is used to allocate virtual machine. Minimum api-version: 2021-04-01.
     */
    @JvmName("gfpgapbwwahuqsgi")
    public suspend fun capacityReservation(`value`: CapacityReservationProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservation = mapped
    }

    /**
     * @param argument Specifies information about the capacity reservation that is used to allocate virtual machine. Minimum api-version: 2021-04-01.
     */
    @JvmName("gixaqaprlruhgscq")
    public suspend fun capacityReservation(argument: suspend CapacityReservationProfileArgsBuilder.() -> Unit) {
        val toBeMapped = CapacityReservationProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacityReservation = mapped
    }

    /**
     * @param value Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
     */
    @JvmName("qxygqmikxmcjiwhr")
    public suspend fun diagnosticsProfile(`value`: DiagnosticsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnosticsProfile = mapped
    }

    /**
     * @param argument Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.
     */
    @JvmName("nklxqpfrcphjeaoy")
    public suspend fun diagnosticsProfile(argument: suspend DiagnosticsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = DiagnosticsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diagnosticsProfile = mapped
    }

    /**
     * @param value Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
     */
    @JvmName("vavcmdubiisjches")
    public suspend fun evictionPolicy(`value`: Either<String, VirtualMachineEvictionPolicyTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
     */
    @JvmName("tincqwqngheohvub")
    public fun evictionPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachineEvictionPolicyTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
     */
    @JvmName("anbrdyrrjvpeyohw")
    public fun evictionPolicy(`value`: VirtualMachineEvictionPolicyTypes) {
        val toBeMapped = Either.ofRight<String, VirtualMachineEvictionPolicyTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value The extended location of the Virtual Machine.
     */
    @JvmName("ysfvhckqchmntssw")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the Virtual Machine.
     */
    @JvmName("rlsoyltfgeytmdft")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Specifies the time alloted for all extensions to start. The time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in ISO 8601 format. The default value is 90 minutes (PT1H30M). Minimum api-version: 2020-06-01.
     */
    @JvmName("sautffqnnlcdvtjs")
    public suspend fun extensionsTimeBudget(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionsTimeBudget = mapped
    }

    /**
     * @param value Specifies the hardware settings for the virtual machine.
     */
    @JvmName("plaekeoqclylvnvr")
    public suspend fun hardwareProfile(`value`: HardwareProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareProfile = mapped
    }

    /**
     * @param argument Specifies the hardware settings for the virtual machine.
     */
    @JvmName("smnyvepybwplkcup")
    public suspend fun hardwareProfile(argument: suspend HardwareProfileArgsBuilder.() -> Unit) {
        val toBeMapped = HardwareProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hardwareProfile = mapped
    }

    /**
     * @param value Specifies information about the dedicated host that the virtual machine resides in. Minimum api-version: 2018-10-01.
     */
    @JvmName("dtjmleqequiwijqt")
    public suspend fun host(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param argument Specifies information about the dedicated host that the virtual machine resides in. Minimum api-version: 2018-10-01.
     */
    @JvmName("vmwtrfbxunvdnlxx")
    public suspend fun host(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.host = mapped
    }

    /**
     * @param value Specifies information about the dedicated host group that the virtual machine resides in. **Note:** User cannot specify both host and hostGroup properties. Minimum api-version: 2020-06-01.
     */
    @JvmName("vkgdiocbacpcdtrw")
    public suspend fun hostGroup(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostGroup = mapped
    }

    /**
     * @param argument Specifies information about the dedicated host group that the virtual machine resides in. **Note:** User cannot specify both host and hostGroup properties. Minimum api-version: 2020-06-01.
     */
    @JvmName("fkrruemqqmkiltyo")
    public suspend fun hostGroup(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hostGroup = mapped
    }

    /**
     * @param value The identity of the virtual machine, if configured.
     */
    @JvmName("wsopjklnwpwdyvxx")
    public suspend fun identity(`value`: VirtualMachineIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the virtual machine, if configured.
     */
    @JvmName("hhbabgvireaxiiaa")
    public suspend fun identity(argument: suspend VirtualMachineIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs&#46;microsoft&#46;com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15
     */
    @JvmName("ofshlextcmxvwljh")
    public suspend fun licenseType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("pmivvkwopxsjsuum")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Specifies the network interfaces of the virtual machine.
     */
    @JvmName("ankojcvkqjacjqej")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument Specifies the network interfaces of the virtual machine.
     */
    @JvmName("lvqmtgilaenyitvf")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value Specifies the operating system settings used while creating the virtual machine. Some of the settings cannot be changed once VM is provisioned.
     */
    @JvmName("rgdppbvudliwxiin")
    public suspend fun osProfile(`value`: OSProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument Specifies the operating system settings used while creating the virtual machine. Some of the settings cannot be changed once VM is provisioned.
     */
    @JvmName("brkdukvagghmbmdq")
    public suspend fun osProfile(argument: suspend OSProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OSProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
     */
    @JvmName("tlxfmyjcoiskfopk")
    public suspend fun plan(`value`: PlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
     */
    @JvmName("wupygbixnjfkuwca")
    public suspend fun plan(argument: suspend PlanArgsBuilder.() -> Unit) {
        val toBeMapped = PlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value Specifies the scale set logical fault domain into which the Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned to a fault domain that best maintains balance across available fault domains. This is applicable only if the 'virtualMachineScaleSet' property of this Virtual Machine is set. The Virtual Machine Scale Set that is referenced, must have 'platformFaultDomainCount' greater than 1. This property cannot be updated once the Virtual Machine is created. Fault domain assignment can be viewed in the Virtual Machine Instance View. Minimum api‐version: 2020‐12‐01.
     */
    @JvmName("srxhwfnsaeffhgoy")
    public suspend fun platformFaultDomain(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformFaultDomain = mapped
    }

    /**
     * @param value Specifies the priority for the virtual machine. Minimum api-version: 2019-03-01
     */
    @JvmName("mugepdvatwvjvgvd")
    public suspend fun priority(`value`: Either<String, VirtualMachinePriorityTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Specifies the priority for the virtual machine. Minimum api-version: 2019-03-01
     */
    @JvmName("tjnukwrbrdrnngug")
    public fun priority(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualMachinePriorityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Specifies the priority for the virtual machine. Minimum api-version: 2019-03-01
     */
    @JvmName("rwggrmmktjlssune")
    public fun priority(`value`: VirtualMachinePriorityTypes) {
        val toBeMapped = Either.ofRight<String, VirtualMachinePriorityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Specifies information about the proximity placement group that the virtual machine should be assigned to. Minimum api-version: 2018-04-01.
     */
    @JvmName("loqcslobpsqusxix")
    public suspend fun proximityPlacementGroup(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proximityPlacementGroup = mapped
    }

    /**
     * @param argument Specifies information about the proximity placement group that the virtual machine should be assigned to. Minimum api-version: 2018-04-01.
     */
    @JvmName("qhlbwdshympqclrh")
    public suspend fun proximityPlacementGroup(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.proximityPlacementGroup = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pmvynlvmffrwvsuw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies Scheduled Event related configurations.
     */
    @JvmName("qvikdnfmqkbjxpvu")
    public suspend fun scheduledEventsProfile(`value`: ScheduledEventsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduledEventsProfile = mapped
    }

    /**
     * @param argument Specifies Scheduled Event related configurations.
     */
    @JvmName("keugqkorayocsklt")
    public suspend fun scheduledEventsProfile(argument: suspend ScheduledEventsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduledEventsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scheduledEventsProfile = mapped
    }

    /**
     * @param value Specifies the Security related profile settings for the virtual machine.
     */
    @JvmName("smuukikskravrvwu")
    public suspend fun securityProfile(`value`: SecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument Specifies the Security related profile settings for the virtual machine.
     */
    @JvmName("pmsyxjcopsqacjtx")
    public suspend fun securityProfile(argument: suspend SecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("udeuufjcwsqookwr")
    public suspend fun storageProfile(`value`: StorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Specifies the storage settings for the virtual machine disks.
     */
    @JvmName("cgsmubqyhwuxvmfi")
    public suspend fun storageProfile(argument: suspend StorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("qhmdmfcqsyqrxrrw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("ixalvhrerdndpdmb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. Minimum api-version: 2021-03-01.
     */
    @JvmName("lruufllbqnpjnmty")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value Specifies information about the virtual machine scale set that the virtual machine should be assigned to. Virtual machines specified in the same virtual machine scale set are allocated to different nodes to maximize availability. Currently, a VM can only be added to virtual machine scale set at creation time. An existing VM cannot be added to a virtual machine scale set. This property cannot exist along with a non-null properties.availabilitySet reference. Minimum api‐version: 2019‐03‐01.
     */
    @JvmName("jucbjgkwkjhjogwm")
    public suspend fun virtualMachineScaleSet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineScaleSet = mapped
    }

    /**
     * @param argument Specifies information about the virtual machine scale set that the virtual machine should be assigned to. Virtual machines specified in the same virtual machine scale set are allocated to different nodes to maximize availability. Currently, a VM can only be added to virtual machine scale set at creation time. An existing VM cannot be added to a virtual machine scale set. This property cannot exist along with a non-null properties.availabilitySet reference. Minimum api‐version: 2019‐03‐01.
     */
    @JvmName("pqdguihakwtgqlwc")
    public suspend fun virtualMachineScaleSet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualMachineScaleSet = mapped
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("pntjdloxfnccygrv")
    public suspend fun vmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmName = mapped
    }

    /**
     * @param value The virtual machine zones.
     */
    @JvmName("vhoqawhldypfixsc")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values The virtual machine zones.
     */
    @JvmName("jtamirgderaoutsk")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): VirtualMachineArgs = VirtualMachineArgs(
        additionalCapabilities = additionalCapabilities,
        applicationProfile = applicationProfile,
        availabilitySet = availabilitySet,
        billingProfile = billingProfile,
        capacityReservation = capacityReservation,
        diagnosticsProfile = diagnosticsProfile,
        evictionPolicy = evictionPolicy,
        extendedLocation = extendedLocation,
        extensionsTimeBudget = extensionsTimeBudget,
        hardwareProfile = hardwareProfile,
        host = host,
        hostGroup = hostGroup,
        identity = identity,
        licenseType = licenseType,
        location = location,
        networkProfile = networkProfile,
        osProfile = osProfile,
        plan = plan,
        platformFaultDomain = platformFaultDomain,
        priority = priority,
        proximityPlacementGroup = proximityPlacementGroup,
        resourceGroupName = resourceGroupName,
        scheduledEventsProfile = scheduledEventsProfile,
        securityProfile = securityProfile,
        storageProfile = storageProfile,
        tags = tags,
        userData = userData,
        virtualMachineScaleSet = virtualMachineScaleSet,
        vmName = vmName,
        zones = zones,
    )
}
