@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * CPU architecture supported by an OS disk.
 */
public enum class Architecture(
    public val javaValue: com.pulumi.azurenative.compute.enums.Architecture,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.Architecture> {
    X64(com.pulumi.azurenative.compute.enums.Architecture.X64),
    Arm64(com.pulumi.azurenative.compute.enums.Architecture.Arm64),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.Architecture = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.Architecture): Architecture =
            Architecture.values().first { it.javaValue == javaType }
    }
}
