@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Slot type for the cloud service.
 * Possible values are <br /><br />**Production**<br /><br />**Staging**<br /><br />
 * If not specified, the default value is Production.
 */
public enum class CloudServiceSlotType(
    public val javaValue: com.pulumi.azurenative.compute.enums.CloudServiceSlotType,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.CloudServiceSlotType> {
    Production(com.pulumi.azurenative.compute.enums.CloudServiceSlotType.Production),
    Staging(com.pulumi.azurenative.compute.enums.CloudServiceSlotType.Staging),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.CloudServiceSlotType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.CloudServiceSlotType): CloudServiceSlotType = CloudServiceSlotType.values().first { it.javaValue == javaType }
    }
}
