@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * ConsistencyMode of the RestorePoint. Can be specified in the input while creating a restore point. For now, only CrashConsistent is accepted as a valid input. Please refer to https://aka.ms/RestorePoints for more details.
 */
public enum class ConsistencyModeTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.ConsistencyModeTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.ConsistencyModeTypes> {
    CrashConsistent(com.pulumi.azurenative.compute.enums.ConsistencyModeTypes.CrashConsistent),
    FileSystemConsistent(com.pulumi.azurenative.compute.enums.ConsistencyModeTypes.FileSystemConsistent),
    ApplicationConsistent(com.pulumi.azurenative.compute.enums.ConsistencyModeTypes.ApplicationConsistent),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.ConsistencyModeTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.ConsistencyModeTypes): ConsistencyModeTypes = ConsistencyModeTypes.values().first { it.javaValue == javaType }
    }
}
