@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the software license type that will be applied to the VMs deployed on the dedicated host. Possible values are: **None,** **Windows_Server_Hybrid,** **Windows_Server_Perpetual.** The default value is: **None.**
 */
public enum class DedicatedHostLicenseTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.DedicatedHostLicenseTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.DedicatedHostLicenseTypes> {
    None(com.pulumi.azurenative.compute.enums.DedicatedHostLicenseTypes.None),
    Windows_Server_Hybrid(com.pulumi.azurenative.compute.enums.DedicatedHostLicenseTypes.Windows_Server_Hybrid),
    Windows_Server_Perpetual(com.pulumi.azurenative.compute.enums.DedicatedHostLicenseTypes.Windows_Server_Perpetual),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.DedicatedHostLicenseTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.DedicatedHostLicenseTypes): DedicatedHostLicenseTypes =
            DedicatedHostLicenseTypes.values().first { it.javaValue == javaType }
    }
}
