@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the ephemeral disk placement for operating system disk. Possible values are: **CacheDisk,** **ResourceDisk.** The defaulting behavior is: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** is used. Refer to the VM size documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk.
 */
public enum class DiffDiskPlacement(
    public val javaValue: com.pulumi.azurenative.compute.enums.DiffDiskPlacement,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.DiffDiskPlacement> {
    CacheDisk(com.pulumi.azurenative.compute.enums.DiffDiskPlacement.CacheDisk),
    ResourceDisk(com.pulumi.azurenative.compute.enums.DiffDiskPlacement.ResourceDisk),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.DiffDiskPlacement = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.DiffDiskPlacement): DiffDiskPlacement = DiffDiskPlacement.values().first { it.javaValue == javaType }
    }
}
