@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies whether OS Disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the OS disk is deleted when VM is deleted. **Detach.** If this value is used, the os disk is retained after VM is deleted. The default value is set to **Detach**. For an ephemeral OS Disk, the default value is set to **Delete**. The user cannot change the delete option for an ephemeral OS Disk.
 */
public enum class DiskDeleteOptionTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.DiskDeleteOptionTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.DiskDeleteOptionTypes> {
    Delete(com.pulumi.azurenative.compute.enums.DiskDeleteOptionTypes.Delete),
    Detach(com.pulumi.azurenative.compute.enums.DiskDeleteOptionTypes.Detach),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.DiskDeleteOptionTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.DiskDeleteOptionTypes): DiskDeleteOptionTypes = DiskDeleteOptionTypes.values().first { it.javaValue == javaType }
    }
}
