@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is supported for new creations. Disk Encryption Sets can be updated with Identity type None during migration of subscription to a new Azure Active Directory tenant; it will cause the encrypted resources to lose access to the keys.
 */
public enum class DiskEncryptionSetIdentityType(
    public val javaValue: com.pulumi.azurenative.compute.enums.DiskEncryptionSetIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.DiskEncryptionSetIdentityType> {
    SystemAssigned(com.pulumi.azurenative.compute.enums.DiskEncryptionSetIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.compute.enums.DiskEncryptionSetIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.compute.enums.DiskEncryptionSetIdentityType.SystemAssigned_UserAssigned),
    None(com.pulumi.azurenative.compute.enums.DiskEncryptionSetIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.DiskEncryptionSetIdentityType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.DiskEncryptionSetIdentityType): DiskEncryptionSetIdentityType =
            DiskEncryptionSetIdentityType.values().first { it.javaValue == javaType }
    }
}
