@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of key used to encrypt the data of the disk.
 */
public enum class EncryptionType(
    public val javaValue: com.pulumi.azurenative.compute.enums.EncryptionType,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.EncryptionType> {
    /**
     * Disk is encrypted at rest with Platform managed key. It is the default encryption type. This is not a valid encryption type for disk encryption sets.
     */
    EncryptionAtRestWithPlatformKey(com.pulumi.azurenative.compute.enums.EncryptionType.EncryptionAtRestWithPlatformKey),

    /**
     * Disk is encrypted at rest with Customer managed key that can be changed and revoked by a customer.
     */
    EncryptionAtRestWithCustomerKey(com.pulumi.azurenative.compute.enums.EncryptionType.EncryptionAtRestWithCustomerKey),

    /**
     * Disk is encrypted at rest with 2 layers of encryption. One of the keys is Customer managed and the other key is Platform managed.
     */
    EncryptionAtRestWithPlatformAndCustomerKeys(com.pulumi.azurenative.compute.enums.EncryptionType.EncryptionAtRestWithPlatformAndCustomerKeys),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.EncryptionType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.EncryptionType): EncryptionType = EncryptionType.values().first { it.javaValue == javaType }
    }
}
