@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The OS State. For managed images, use Generalized.
 */
public enum class OperatingSystemStateTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.OperatingSystemStateTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.OperatingSystemStateTypes> {
    /**
     * Generalized image. Needs to be provisioned during deployment time.
     */
    Generalized(com.pulumi.azurenative.compute.enums.OperatingSystemStateTypes.Generalized),

    /**
     * Specialized image. Contains already provisioned OS Disk.
     */
    Specialized(com.pulumi.azurenative.compute.enums.OperatingSystemStateTypes.Specialized),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.OperatingSystemStateTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.OperatingSystemStateTypes): OperatingSystemStateTypes =
            OperatingSystemStateTypes.values().first { it.javaValue == javaType }
    }
}
