@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the protocol of WinRM listener. Possible values are: **http,** **https.**
 */
public enum class ProtocolTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.ProtocolTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.ProtocolTypes> {
    Http(com.pulumi.azurenative.compute.enums.ProtocolTypes.Http),
    Https(com.pulumi.azurenative.compute.enums.ProtocolTypes.Https),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.ProtocolTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.ProtocolTypes): ProtocolTypes = ProtocolTypes.values().first { it.javaValue == javaType }
    }
}
