@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the type of the proximity placement group. Possible values are: **Standard** : Co-locate resources within an Azure region or Availability Zone. **Ultra** : For future use.
 */
public enum class ProximityPlacementGroupType(
    public val javaValue: com.pulumi.azurenative.compute.enums.ProximityPlacementGroupType,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.ProximityPlacementGroupType> {
    Standard(com.pulumi.azurenative.compute.enums.ProximityPlacementGroupType.Standard),
    Ultra(com.pulumi.azurenative.compute.enums.ProximityPlacementGroupType.Ultra),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.ProximityPlacementGroupType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.ProximityPlacementGroupType): ProximityPlacementGroupType =
            ProximityPlacementGroupType.values().first { it.javaValue == javaType }
    }
}
