@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of key used to encrypt the data of the disk restore point.
 */
public enum class RestorePointEncryptionType(
    public val javaValue: com.pulumi.azurenative.compute.enums.RestorePointEncryptionType,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.RestorePointEncryptionType> {
    /**
     * Disk Restore Point is encrypted at rest with Platform managed key.
     */
    EncryptionAtRestWithPlatformKey(com.pulumi.azurenative.compute.enums.RestorePointEncryptionType.EncryptionAtRestWithPlatformKey),

    /**
     * Disk Restore Point is encrypted at rest with Customer managed key that can be changed and revoked by a customer.
     */
    EncryptionAtRestWithCustomerKey(com.pulumi.azurenative.compute.enums.RestorePointEncryptionType.EncryptionAtRestWithCustomerKey),

    /**
     * Disk Restore Point is encrypted at rest with 2 layers of encryption. One of the keys is Customer managed and the other key is Platform managed.
     */
    EncryptionAtRestWithPlatformAndCustomerKeys(com.pulumi.azurenative.compute.enums.RestorePointEncryptionType.EncryptionAtRestWithPlatformAndCustomerKeys),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.RestorePointEncryptionType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.RestorePointEncryptionType): RestorePointEncryptionType =
            RestorePointEncryptionType.values().first { it.javaValue == javaType }
    }
}
