@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob, and VMGuestStateOnly for encryption of just the VMGuestState blob. **Note:** It can be set for only Confidential VMs.
 */
public enum class SecurityEncryptionTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.SecurityEncryptionTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.SecurityEncryptionTypes> {
    VMGuestStateOnly(com.pulumi.azurenative.compute.enums.SecurityEncryptionTypes.VMGuestStateOnly),
    DiskWithVMGuestState(com.pulumi.azurenative.compute.enums.SecurityEncryptionTypes.DiskWithVMGuestState),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.SecurityEncryptionTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.SecurityEncryptionTypes): SecurityEncryptionTypes =
            SecurityEncryptionTypes.values().first { it.javaValue == javaType }
    }
}
