@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the SecurityType of the virtual machine. It has to be set to any specified value to enable UefiSettings. The default behavior is: UefiSettings will not be enabled unless this property is set.
 */
public enum class SecurityTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.SecurityTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.SecurityTypes> {
    TrustedLaunch(com.pulumi.azurenative.compute.enums.SecurityTypes.TrustedLaunch),
    ConfidentialVM(com.pulumi.azurenative.compute.enums.SecurityTypes.ConfidentialVM),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.SecurityTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.SecurityTypes): SecurityTypes = SecurityTypes.values().first { it.javaValue == javaType }
    }
}
