@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the storage account type to be used to store the image. This property is not updatable.
 */
public enum class StorageAccountType(
    public val javaValue: com.pulumi.azurenative.compute.enums.StorageAccountType,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.StorageAccountType> {
    Standard_LRS(com.pulumi.azurenative.compute.enums.StorageAccountType.Standard_LRS),
    Standard_ZRS(com.pulumi.azurenative.compute.enums.StorageAccountType.Standard_ZRS),
    Premium_LRS(com.pulumi.azurenative.compute.enums.StorageAccountType.Premium_LRS),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.StorageAccountType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.StorageAccountType): StorageAccountType = StorageAccountType.values().first { it.javaValue == javaType }
    }
}
