@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the eviction policy for the Azure Spot virtual machine and Azure Spot scale set. For Azure Spot virtual machines, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01. For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and the minimum api-version is 2017-10-30-preview.
 */
public enum class VirtualMachineEvictionPolicyTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.VirtualMachineEvictionPolicyTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.VirtualMachineEvictionPolicyTypes> {
    Deallocate(com.pulumi.azurenative.compute.enums.VirtualMachineEvictionPolicyTypes.Deallocate),
    Delete(com.pulumi.azurenative.compute.enums.VirtualMachineEvictionPolicyTypes.Delete),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.VirtualMachineEvictionPolicyTypes =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.VirtualMachineEvictionPolicyTypes): VirtualMachineEvictionPolicyTypes =
            VirtualMachineEvictionPolicyTypes.values().first { it.javaValue == javaType }
    }
}
