@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the size of the virtual machine. The enum data type is currently deprecated and will be removed by December 23rd 2023. The recommended way to get the list of available sizes is using these APIs: [List all available virtual machine sizes in an availability set](https://docs&#46;microsoft&#46;com/rest/api/compute/availabilitysets/listavailablesizes), [List all available virtual machine sizes in a region]( https://docs&#46;microsoft&#46;com/rest/api/compute/resourceskus/list), [List all available virtual machine sizes for resizing](https://docs&#46;microsoft&#46;com/rest/api/compute/virtualmachines/listavailablesizes)&#46; For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/sizes). The available VM sizes depend on region and availability set.
 */
public enum class VirtualMachineSizeTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes> {
    Basic_A0(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Basic_A0),
    Basic_A1(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Basic_A1),
    Basic_A2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Basic_A2),
    Basic_A3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Basic_A3),
    Basic_A4(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Basic_A4),
    Standard_A0(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A0),
    Standard_A1(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A1),
    Standard_A2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A2),
    Standard_A3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A3),
    Standard_A4(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A4),
    Standard_A5(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A5),
    Standard_A6(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A6),
    Standard_A7(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A7),
    Standard_A8(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A8),
    Standard_A9(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A9),
    Standard_A10(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A10),
    Standard_A11(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A11),
    Standard_A1_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A1_v2),
    Standard_A2_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A2_v2),
    Standard_A4_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A4_v2),
    Standard_A8_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A8_v2),
    Standard_A2m_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A2m_v2),
    Standard_A4m_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A4m_v2),
    Standard_A8m_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_A8m_v2),
    Standard_B1s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_B1s),
    Standard_B1ms(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_B1ms),
    Standard_B2s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_B2s),
    Standard_B2ms(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_B2ms),
    Standard_B4ms(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_B4ms),
    Standard_B8ms(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_B8ms),
    Standard_D1(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D1),
    Standard_D2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D2),
    Standard_D3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D3),
    Standard_D4(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D4),
    Standard_D11(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D11),
    Standard_D12(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D12),
    Standard_D13(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D13),
    Standard_D14(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D14),
    Standard_D1_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D1_v2),
    Standard_D2_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D2_v2),
    Standard_D3_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D3_v2),
    Standard_D4_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D4_v2),
    Standard_D5_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D5_v2),
    Standard_D2_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D2_v3),
    Standard_D4_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D4_v3),
    Standard_D8_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D8_v3),
    Standard_D16_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D16_v3),
    Standard_D32_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D32_v3),
    Standard_D64_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D64_v3),
    Standard_D2s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D2s_v3),
    Standard_D4s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D4s_v3),
    Standard_D8s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D8s_v3),
    Standard_D16s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D16s_v3),
    Standard_D32s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D32s_v3),
    Standard_D64s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D64s_v3),
    Standard_D11_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D11_v2),
    Standard_D12_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D12_v2),
    Standard_D13_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D13_v2),
    Standard_D14_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D14_v2),
    Standard_D15_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_D15_v2),
    Standard_DS1(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS1),
    Standard_DS2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS2),
    Standard_DS3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS3),
    Standard_DS4(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS4),
    Standard_DS11(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS11),
    Standard_DS12(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS12),
    Standard_DS13(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS13),
    Standard_DS14(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS14),
    Standard_DS1_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS1_v2),
    Standard_DS2_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS2_v2),
    Standard_DS3_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS3_v2),
    Standard_DS4_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS4_v2),
    Standard_DS5_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS5_v2),
    Standard_DS11_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS11_v2),
    Standard_DS12_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS12_v2),
    Standard_DS13_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS13_v2),
    Standard_DS14_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS14_v2),
    Standard_DS15_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS15_v2),
    Standard_DS134_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS134_v2),
    Standard_DS132_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS132_v2),
    Standard_DS148_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS148_v2),
    Standard_DS144_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_DS144_v2),
    Standard_E2_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E2_v3),
    Standard_E4_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E4_v3),
    Standard_E8_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E8_v3),
    Standard_E16_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E16_v3),
    Standard_E32_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E32_v3),
    Standard_E64_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E64_v3),
    Standard_E2s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E2s_v3),
    Standard_E4s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E4s_v3),
    Standard_E8s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E8s_v3),
    Standard_E16s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E16s_v3),
    Standard_E32s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E32s_v3),
    Standard_E64s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E64s_v3),
    Standard_E3216_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E3216_v3),
    Standard_E328s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E328s_v3),
    Standard_E6432s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E6432s_v3),
    Standard_E6416s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_E6416s_v3),
    Standard_F1(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F1),
    Standard_F2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F2),
    Standard_F4(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F4),
    Standard_F8(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F8),
    Standard_F16(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F16),
    Standard_F1s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F1s),
    Standard_F2s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F2s),
    Standard_F4s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F4s),
    Standard_F8s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F8s),
    Standard_F16s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F16s),
    Standard_F2s_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F2s_v2),
    Standard_F4s_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F4s_v2),
    Standard_F8s_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F8s_v2),
    Standard_F16s_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F16s_v2),
    Standard_F32s_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F32s_v2),
    Standard_F64s_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F64s_v2),
    Standard_F72s_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_F72s_v2),
    Standard_G1(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_G1),
    Standard_G2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_G2),
    Standard_G3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_G3),
    Standard_G4(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_G4),
    Standard_G5(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_G5),
    Standard_GS1(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_GS1),
    Standard_GS2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_GS2),
    Standard_GS3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_GS3),
    Standard_GS4(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_GS4),
    Standard_GS5(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_GS5),
    Standard_GS48(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_GS48),
    Standard_GS44(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_GS44),
    Standard_GS516(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_GS516),
    Standard_GS58(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_GS58),
    Standard_H8(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_H8),
    Standard_H16(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_H16),
    Standard_H8m(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_H8m),
    Standard_H16m(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_H16m),
    Standard_H16r(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_H16r),
    Standard_H16mr(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_H16mr),
    Standard_L4s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_L4s),
    Standard_L8s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_L8s),
    Standard_L16s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_L16s),
    Standard_L32s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_L32s),
    Standard_M64s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_M64s),
    Standard_M64ms(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_M64ms),
    Standard_M128s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_M128s),
    Standard_M128ms(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_M128ms),
    Standard_M6432ms(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_M6432ms),
    Standard_M6416ms(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_M6416ms),
    Standard_M12864ms(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_M12864ms),
    Standard_M12832ms(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_M12832ms),
    Standard_NC6(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NC6),
    Standard_NC12(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NC12),
    Standard_NC24(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NC24),
    Standard_NC24r(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NC24r),
    Standard_NC6s_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NC6s_v2),
    Standard_NC12s_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NC12s_v2),
    Standard_NC24s_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NC24s_v2),
    Standard_NC24rs_v2(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NC24rs_v2),
    Standard_NC6s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NC6s_v3),
    Standard_NC12s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NC12s_v3),
    Standard_NC24s_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NC24s_v3),
    Standard_NC24rs_v3(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NC24rs_v3),
    Standard_ND6s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_ND6s),
    Standard_ND12s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_ND12s),
    Standard_ND24s(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_ND24s),
    Standard_ND24rs(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_ND24rs),
    Standard_NV6(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NV6),
    Standard_NV12(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NV12),
    Standard_NV24(com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes.Standard_NV24),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.VirtualMachineSizeTypes): VirtualMachineSizeTypes =
            VirtualMachineSizeTypes.values().first { it.javaValue == javaType }
    }
}
