@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CloudServiceNetworkProfileArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.CloudServiceSlotType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network Profile for the cloud service.
 * @property loadBalancerConfigurations List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer.
 * @property slotType Slot type for the cloud service.
 * Possible values are <br /><br />**Production**<br /><br />**Staging**<br /><br />
 * If not specified, the default value is Production.
 * @property swappableCloudService The id reference of the cloud service containing the target IP with which the subject cloud service can perform a swap. This property cannot be updated once it is set. The swappable cloud service referred by this id must be present otherwise an error will be thrown.
 */
public data class CloudServiceNetworkProfileArgs(
    public val loadBalancerConfigurations: Output<List<LoadBalancerConfigurationArgs>>? = null,
    public val slotType: Output<Either<String, CloudServiceSlotType>>? = null,
    public val swappableCloudService: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CloudServiceNetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CloudServiceNetworkProfileArgs =
        com.pulumi.azurenative.compute.inputs.CloudServiceNetworkProfileArgs.builder()
            .loadBalancerConfigurations(
                loadBalancerConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .slotType(
                slotType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .swappableCloudService(
                swappableCloudService?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [CloudServiceNetworkProfileArgs].
 */
@PulumiTagMarker
public class CloudServiceNetworkProfileArgsBuilder internal constructor() {
    private var loadBalancerConfigurations: Output<List<LoadBalancerConfigurationArgs>>? = null

    private var slotType: Output<Either<String, CloudServiceSlotType>>? = null

    private var swappableCloudService: Output<SubResourceArgs>? = null

    /**
     * @param value List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer.
     */
    @JvmName("hmxketguidvcwrlw")
    public suspend fun loadBalancerConfigurations(`value`: Output<List<LoadBalancerConfigurationArgs>>) {
        this.loadBalancerConfigurations = value
    }

    @JvmName("cbxpelwhntgtddbq")
    public suspend fun loadBalancerConfigurations(vararg values: Output<LoadBalancerConfigurationArgs>) {
        this.loadBalancerConfigurations = Output.all(values.asList())
    }

    /**
     * @param values List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer.
     */
    @JvmName("swacswmbjgndqsdv")
    public suspend fun loadBalancerConfigurations(values: List<Output<LoadBalancerConfigurationArgs>>) {
        this.loadBalancerConfigurations = Output.all(values)
    }

    /**
     * @param value Slot type for the cloud service.
     * Possible values are <br /><br />**Production**<br /><br />**Staging**<br /><br />
     * If not specified, the default value is Production.
     */
    @JvmName("vkusvvepqojfrwdq")
    public suspend fun slotType(`value`: Output<Either<String, CloudServiceSlotType>>) {
        this.slotType = value
    }

    /**
     * @param value The id reference of the cloud service containing the target IP with which the subject cloud service can perform a swap. This property cannot be updated once it is set. The swappable cloud service referred by this id must be present otherwise an error will be thrown.
     */
    @JvmName("loqhmiifjukuakvn")
    public suspend fun swappableCloudService(`value`: Output<SubResourceArgs>) {
        this.swappableCloudService = value
    }

    /**
     * @param value List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer.
     */
    @JvmName("jsjnmtoatexlielk")
    public suspend fun loadBalancerConfigurations(`value`: List<LoadBalancerConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerConfigurations = mapped
    }

    /**
     * @param argument List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer.
     */
    @JvmName("mcxfevtyaupwaxod")
    public suspend fun loadBalancerConfigurations(argument: List<suspend LoadBalancerConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerConfigurations = mapped
    }

    /**
     * @param argument List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer.
     */
    @JvmName("jsqwwidbcrjabwqq")
    public suspend fun loadBalancerConfigurations(vararg argument: suspend LoadBalancerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LoadBalancerConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerConfigurations = mapped
    }

    /**
     * @param argument List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer.
     */
    @JvmName("lnansgaqiatadgcx")
    public suspend fun loadBalancerConfigurations(argument: suspend LoadBalancerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancerConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadBalancerConfigurations = mapped
    }

    /**
     * @param values List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer.
     */
    @JvmName("sjrucwgvuajaugrp")
    public suspend fun loadBalancerConfigurations(vararg values: LoadBalancerConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerConfigurations = mapped
    }

    /**
     * @param value Slot type for the cloud service.
     * Possible values are <br /><br />**Production**<br /><br />**Staging**<br /><br />
     * If not specified, the default value is Production.
     */
    @JvmName("kypnngnyvtkqtnjv")
    public suspend fun slotType(`value`: Either<String, CloudServiceSlotType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slotType = mapped
    }

    /**
     * @param value Slot type for the cloud service.
     * Possible values are <br /><br />**Production**<br /><br />**Staging**<br /><br />
     * If not specified, the default value is Production.
     */
    @JvmName("qvcvbqtlmdayijxs")
    public fun slotType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CloudServiceSlotType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slotType = mapped
    }

    /**
     * @param value Slot type for the cloud service.
     * Possible values are <br /><br />**Production**<br /><br />**Staging**<br /><br />
     * If not specified, the default value is Production.
     */
    @JvmName("ycxidwyvedhyuxxx")
    public fun slotType(`value`: CloudServiceSlotType) {
        val toBeMapped = Either.ofRight<String, CloudServiceSlotType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slotType = mapped
    }

    /**
     * @param value The id reference of the cloud service containing the target IP with which the subject cloud service can perform a swap. This property cannot be updated once it is set. The swappable cloud service referred by this id must be present otherwise an error will be thrown.
     */
    @JvmName("iifuseekpsmvnxuk")
    public suspend fun swappableCloudService(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.swappableCloudService = mapped
    }

    /**
     * @param argument The id reference of the cloud service containing the target IP with which the subject cloud service can perform a swap. This property cannot be updated once it is set. The swappable cloud service referred by this id must be present otherwise an error will be thrown.
     */
    @JvmName("okukufxaqilwkiqi")
    public suspend fun swappableCloudService(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.swappableCloudService = mapped
    }

    internal fun build(): CloudServiceNetworkProfileArgs = CloudServiceNetworkProfileArgs(
        loadBalancerConfigurations = loadBalancerConfigurations,
        slotType = slotType,
        swappableCloudService = swappableCloudService,
    )
}
